/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.modules.java.api.common.project.ProjectConfigurations;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.api.J2SEBuildPropertiesProvider;
import org.netbeans.modules.java.preprocessorbridge.spi.CompileOnSaveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;

public class J2SEActionProvider
extends BaseActionProvider {
    private static final Logger LOG = Logger.getLogger(J2SEActionProvider.class.getName());
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto"};
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    private final CosAction cosAction;
    private Map<String, String[]> commands = new HashMap<String, String[]>();
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;

    public J2SEActionProvider(J2SEProject project, UpdateHelper updateHelper) {
        super((Project)project, updateHelper, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots(), project.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(project));
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("profile.single", new String[]{"profile-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("profile.test.single", new String[]{"profile-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commands.put("run.single.method", new String[]{"test-single-method"});
        this.commands.put("debug.single.method", new String[]{"debug-single-method"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto", "run.single.method", "debug.single.method"));
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.cosAction = new CosAction(this, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots());
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return this.isCompileOnSaveUpdate() && this.cosAction.getTarget() == null;
    }

    protected boolean isCompileOnSaveUpdate() {
        return J2SEProjectUtil.isCompileOnSaveEnabled((J2SEProject)this.getProject());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        String[] names = super.getTargetNames(command, context, p, doJavaChecks);
        ProjectConfigurations.Configuration c = (ProjectConfigurations.Configuration)context.lookup(ProjectConfigurations.Configuration.class);
        if (c != null) {
            String config = !c.isDefault() ? c.getName() : "";
            p.setProperty("config", config);
        }
        return names;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        Runnable superCall = () -> super.invokeAction(command, context);
        if (this.isCompileOnSaveUpdate() && this.cosAction.getTarget() != null && this.getScanSensitiveActions().contains(command)) {
            LifecycleManager.getDefault().saveAll();
            JButton stopButton = new JButton(NbBundle.getMessage(J2SEActionProvider.class, (String)"TXT_StopBuild"));
            stopButton.setMnemonic(NbBundle.getMessage(J2SEActionProvider.class, (String)"MNE_StopBuild").charAt(0));
            stopButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2SEActionProvider.class, (String)"AN_StopBuild"));
            stopButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEActionProvider.class, (String)"AD_StopBuild"));
            AtomicBoolean showState = new AtomicBoolean(true);
            AtomicBoolean stopState = new AtomicBoolean();
            try {
                JavaSource js = J2SEActionProvider.createSource();
                js.runWhenScanFinished(cc -> this.cosAction.newSyncTask(() -> SwingUtilities.invokeLater(() -> {
                    showState.set(false);
                    boolean cancelled = stopState.get();
                    stopButton.doClick();
                    if (!cancelled) {
                        superCall.run();
                    }
                })), false);
                Timer timer = new Timer(1000, e -> {
                    if (showState.get()) {
                        NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(J2SEActionProvider.class, (String)"TXT_CosUpdateActive"), command, 0, 1, new Object[]{stopButton}, null);
                        Object res = DialogDisplayer.getDefault().notify(nd);
                        if (res == DialogDescriptor.CLOSED_OPTION || res == stopButton) {
                            stopState.set(true);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                superCall.run();
            }
        } else {
            superCall.run();
        }
    }

    @NonNull
    private static JavaSource createSource() {
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        return js;
    }

    public static J2SEActionProvider create(@NonNull Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        J2SEProject project = (J2SEProject)lkp.lookup(J2SEProject.class);
        J2SEActionProvider j2seActionProvider = new J2SEActionProvider(project, project.getUpdateHelper());
        j2seActionProvider.startFSListener();
        return j2seActionProvider;
    }

    public static final class Provider
    implements CompileOnSaveAction.Provider {
        public CompileOnSaveAction forRoot(URL root) {
            try {
                Project p = FileOwnerQuery.getOwner((URI)root.toURI());
                if (p != null) {
                    ActionProvider prov = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                    if (prov != null) {
                        prov.getSupportedActions();
                    }
                    CosAction action = CosAction.getInstance(p);
                    return action;
                }
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }
    }

    private static final class CosAction
    implements BuildArtifactMapper.ArtifactsUpdated,
    CompileOnSaveAction,
    PropertyChangeListener,
    FileChangeListener {
        private static Map<Project, Reference<CosAction>> instances = new WeakHashMap<Project, Reference<CosAction>>();
        private static final String COS_UPDATED = "$cos.update";
        private static final String COS_CUSTOM = "$cos.update.resources";
        private static final String PROP_TARGET = "cos.update.target.internal";
        private static final String PROP_SCRIPT = "cos.update.script.internal";
        private static final String PROP_SRCDIR = "cos.src.dir.internal";
        private static final String PROP_INCLUDES = "cos.includes.internal";
        private static final String SNIPPETS = "executor-snippets";
        private static final String SCRIPT = "cos-update.xml";
        private static final String TARGET = "cos-update-internal";
        private static final String SCRIPT_TEMPLATE = "/org/netbeans/modules/java/j2seproject/resources/cos-update-snippet.xml";
        private static final Object NONE = new Object();
        private static final RequestProcessor RUNNER = new RequestProcessor(CosAction.class);
        private final J2SEActionProvider owner;
        private final PropertyEvaluator eval;
        private final SourceRoots src;
        private final SourceRoots tests;
        private final BuildArtifactMapper mapper;
        private final Map<URL, BuildArtifactMapper.ArtifactsUpdated> currentListeners;
        private final ChangeSupport cs;
        private final AtomicReference<Pair<URI, Collection<File>>> importantFilesCache;
        private final Queue<Runnable> deferred = new ArrayDeque<Runnable>();
        private byte deferredGuard;
        private volatile Object targetCache;
        private volatile Object updatedFSProp;

        private CosAction(@NonNull J2SEActionProvider owner, @NonNull PropertyEvaluator eval, @NonNull SourceRoots src, @NonNull SourceRoots tests) {
            this.owner = owner;
            this.eval = eval;
            this.src = src;
            this.tests = tests;
            this.mapper = new BuildArtifactMapper();
            this.currentListeners = new HashMap<URL, BuildArtifactMapper.ArtifactsUpdated>();
            this.cs = new ChangeSupport((Object)this);
            this.importantFilesCache = new AtomicReference<Pair>(Pair.of(null, null));
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
            this.src.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.src));
            this.tests.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.tests));
            this.updateRootsListeners();
            instances.put(owner.getProject(), new WeakReference<CosAction>(this));
        }

        public boolean isEnabled() {
            return this.getTarget() != null && this.isCustomUpdate();
        }

        public boolean isUpdateClasses() {
            return this.isEnabled();
        }

        public boolean isUpdateResources() {
            return this.isEnabled();
        }

        public Boolean performAction(CompileOnSaveAction.Context ctx) throws IOException {
            switch (ctx.getOperation()) {
                case UPDATE: {
                    return this.performUpdate(ctx);
                }
                case CLEAN: {
                    return this.performClean(ctx);
                }
                case SYNC: {
                    return this.performSync(ctx);
                }
            }
            throw new IllegalArgumentException(String.valueOf(ctx.getOperation()));
        }

        public void artifactsUpdated(@NonNull Iterable<File> artifacts) {
            FileObject buildXml;
            String target;
            if (!this.isCustomUpdate() && (target = this.getTarget()) != null && (buildXml = this.owner.findBuildXml()) != null && this.checkImportantFiles(buildXml)) {
                RUNNER.execute(() -> {
                    try {
                        ExecutorTask task = CosAction.runTargetInDedicatedTab(NbBundle.getMessage(J2SEActionProvider.class, (String)"LBL_CompileOnSaveUpdate"), buildXml, new String[]{target}, null, null);
                        task.result();
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        LOG.log(Level.WARNING, "Cannot execute pos compile on save target: {0} in: {1} due to: {2}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml), ex.getMessage()});
                    }
                });
            }
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == null) {
                this.targetCache = null;
                this.updatedFSProp = null;
                this.cs.fireChange();
            } else if (COS_UPDATED.equals(name)) {
                this.targetCache = null;
                this.cs.fireChange();
            } else if (COS_CUSTOM.equals(name)) {
                this.updatedFSProp = null;
                this.cs.fireChange();
            } else if (SourceRoots.PROP_ROOTS.equals(name)) {
                this.updateRootsListeners();
            }
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        public void fileDeleted(FileEvent fe) {
            this.resetImportantFilesCache();
        }

        public void fileChanged(FileEvent fe) {
            this.resetImportantFilesCache();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.resetImportantFilesCache();
        }

        public void fileDataCreated(FileEvent fe) {
            this.resetImportantFilesCache();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.resetImportantFilesCache();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @NonNull
        Future<?> newSyncTask(@NonNull Runnable callback) {
            return RUNNER.submit(() -> {
                this.drainDeferred();
                callback.run();
            }, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRootsListeners() {
            HashSet newRoots = new HashSet();
            Collections.addAll(newRoots, this.src.getRootURLs());
            Collections.addAll(newRoots, this.tests.getRootURLs());
            CosAction cosAction = this;
            synchronized (cosAction) {
                BuildArtifactMapper.ArtifactsUpdated l;
                HashSet<URL> toRemove = new HashSet<URL>(this.currentListeners.keySet());
                toRemove.removeAll(newRoots);
                newRoots.removeAll(this.currentListeners.keySet());
                for (URL u : toRemove) {
                    l = this.currentListeners.remove(u);
                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)u, (BuildArtifactMapper.ArtifactsUpdated)l);
                }
                for (URL u : newRoots) {
                    l = new WeakArtifactUpdated(this, this.mapper, u);
                    this.currentListeners.put(u, l);
                    BuildArtifactMapper.addArtifactsUpdatedListener((URL)u, (BuildArtifactMapper.ArtifactsUpdated)l);
                }
            }
        }

        @CheckForNull
        private String getTarget() {
            Object target = this.targetCache;
            if (target == null) {
                String val = this.eval.getProperty(COS_UPDATED);
                this.targetCache = val != null && !val.isEmpty() ? val : NONE;
                target = this.targetCache;
            }
            if (target == NONE) {
                return null;
            }
            return this.owner.isCompileOnSaveUpdate() ? (String)target : null;
        }

        @CheckForNull
        private String getUpdatedFileSetProperty() {
            Object res = this.updatedFSProp;
            if (res == null) {
                String val = this.eval.getProperty(COS_CUSTOM);
                this.updatedFSProp = val != null && !val.isEmpty() ? val : NONE;
                res = this.updatedFSProp;
            }
            if (res == NONE) {
                res = null;
            }
            return (String)res;
        }

        private boolean isCustomUpdate() {
            return this.getUpdatedFileSetProperty() != null;
        }

        @CheckForNull
        private Boolean performUpdate(@NonNull CompileOnSaveAction.Context ctx) {
            FileObject buildXml;
            String target = this.getTarget();
            if (target != null && (buildXml = this.owner.findBuildXml()) != null && this.checkImportantFiles(buildXml)) {
                try {
                    FileObject cosScript = this.getCosScript();
                    Iterable updated = ctx.getUpdated();
                    Iterable deleted = ctx.getDeleted();
                    File root = ctx.isCopyResources() ? BaseUtilities.toFile((URI)ctx.getSourceRoot().toURI()) : ctx.getCacheRoot();
                    String includes = CosAction.createIncludes(root, updated);
                    if (includes != null) {
                        Properties props = new Properties();
                        props.setProperty(PROP_TARGET, target);
                        props.setProperty(PROP_SCRIPT, FileUtil.toFile((FileObject)buildXml).getAbsolutePath());
                        props.setProperty(PROP_SRCDIR, root.getAbsolutePath());
                        props.setProperty(PROP_INCLUDES, includes);
                        props.setProperty(COS_CUSTOM, this.getUpdatedFileSetProperty());
                        Runnable work = () -> {
                            try {
                                ExecutorTask task = CosAction.runTargetInDedicatedTab(NbBundle.getMessage(J2SEActionProvider.class, (String)"LBL_CompileOnSaveUpdate"), cosScript, new String[]{TARGET}, props, null);
                                task.result();
                            }
                            catch (IOException | IllegalArgumentException ex) {
                                LOG.log(Level.WARNING, "Cannot execute update targer: {0} in: {1} due to: {2}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml), ex.getMessage()});
                            }
                        };
                        if (ctx.isAllFilesIndexing()) {
                            this.enqueueDeferred(work);
                        } else {
                            RUNNER.execute(work);
                        }
                    } else {
                        LOG.warning("BuildArtifactMapper artifacts do not provide attributes.");
                    }
                }
                catch (IOException | URISyntaxException e) {
                    LOG.log(Level.WARNING, "Cannot execute update targer: {0} in: {1} due to: {2}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml), e.getMessage()});
                }
            }
            return true;
        }

        @CheckForNull
        private Boolean performClean(@NonNull CompileOnSaveAction.Context ctx) {
            return null;
        }

        @CheckForNull
        private Boolean performSync(@NonNull CompileOnSaveAction.Context ctx) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private FileObject getCosScript() throws IOException {
            FileObject snippets = FileUtil.createFolder((File)Places.getCacheSubdirectory((String)SNIPPETS));
            FileObject cosScript = snippets.getFileObject(SCRIPT);
            if (cosScript == null) {
                cosScript = FileUtil.createData((FileObject)snippets, (String)SCRIPT);
                FileLock lock = cosScript.lock();
                try (InputStream in = this.getClass().getResourceAsStream(SCRIPT_TEMPLATE);
                     OutputStream out = cosScript.getOutputStream(lock);){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    lock.releaseLock();
                }
            }
            return cosScript;
        }

        private boolean checkImportantFiles(@NonNull FileObject buildScript) {
            URI currentURI = buildScript.toURI();
            Pair<URI, Collection<File>> cacheLine = this.importantFilesCache.get();
            URI lastURI = (URI)cacheLine.first();
            ArrayList importantFiles = (ArrayList)cacheLine.second();
            if (!currentURI.equals(lastURI) || importantFiles == null) {
                Optional.ofNullable(lastURI).map(BaseUtilities::toFile).filter(f -> !currentURI.equals(lastURI)).ifPresent(this::safeRemoveFileChangeListener);
                Optional.ofNullable(FileUtil.toFile((FileObject)buildScript)).filter(f -> !currentURI.equals(lastURI)).ifPresent(this::safeAddFileChangeListener);
                importantFiles = new ArrayList();
                try {
                    File base = FileUtil.toFile((FileObject)buildScript.getParent());
                    if (base != null) {
                        Optional.ofNullable((AntProjectCookie)DataObject.find((FileObject)buildScript).getLookup().lookup(AntProjectCookie.class)).map(AntProjectCookie::getProjectElement).map(XMLUtil::findSubElements).map(Collection::stream).orElse(Stream.empty()).filter(e -> "import".equals(e.getNodeName())).map(e -> e.getAttribute("file")).filter(p -> !p.isEmpty()).map(p -> PropertyUtils.resolveFile((File)base, (String)p)).forEach(importantFiles::add);
                    }
                }
                catch (DataObjectNotFoundException e2) {
                    LOG.log(Level.WARNING, "No DataObject for: {0}, reason: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)buildScript), e2.getMessage()});
                }
                this.importantFilesCache.set((Pair<URI, Collection<File>>)Pair.of((Object)currentURI, importantFiles));
            }
            for (File importantFile : importantFiles) {
                if (importantFile.isFile()) continue;
                return false;
            }
            return true;
        }

        private void resetImportantFilesCache() {
            Pair update;
            Pair<URI, Collection<File>> expected;
            while (!this.importantFilesCache.compareAndSet(expected = this.importantFilesCache.get(), (Pair<URI, Collection<File>>)(update = Pair.of((Object)((URI)expected.first()), null)))) {
            }
        }

        private void safeAddFileChangeListener(@NonNull File f) {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void safeRemoveFileChangeListener(@NonNull File f) {
            try {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @NonNull
        private static ExecutorTask runTargetInDedicatedTab(@NullAllowed String tabName, @NonNull FileObject buildXml, @NullAllowed String[] targetNames, @NullAllowed Properties properties, @NullAllowed Set<String> concealedProperties) throws IOException, IllegalArgumentException {
            Object p;
            Parameters.notNull((CharSequence)"buildXml", (Object)buildXml);
            if (targetNames != null && targetNames.length == 0) {
                throw new IllegalArgumentException("No targets supplied");
            }
            AntProjectCookie apc = AntScriptUtils.antProjectCookieFor((FileObject)buildXml);
            AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
            if (properties != null) {
                p = execenv.getProperties();
                ((Properties)p).putAll((Map<?, ?>)properties);
                execenv.setProperties((Properties)p);
            }
            if (concealedProperties != null) {
                execenv.setConcealedProperties(concealedProperties);
            }
            execenv.setSaveAllDocuments(false);
            execenv.setPreferredName(tabName);
            p = s -> tabName == null ? true : tabName.equals(s);
            execenv.setTabReplaceStrategy((Predicate)p, (Predicate)p);
            execenv.setUserAction(false);
            return AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute(apc, targetNames);
        }

        @CheckForNull
        private static String createIncludes(@NonNull File root, @NonNull Iterable<? extends File> artifacts) {
            StringBuilder include = new StringBuilder();
            for (File file : artifacts) {
                if (include.length() > 0) {
                    include.append(',');
                }
                include.append(CosAction.relativize(file, root));
            }
            return include.length() == 0 ? null : include.toString();
        }

        private static String relativize(@NonNull File file, @NonNull File folder) {
            String folderPath = folder.getAbsolutePath();
            int start = folderPath.length();
            if (!folderPath.endsWith(File.separator)) {
                ++start;
            }
            return file.getAbsolutePath().substring(start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueDeferred(Runnable work) {
            boolean addGuard = false;
            CosAction cosAction = this;
            synchronized (cosAction) {
                this.deferred.offer(work);
                if (this.deferredGuard == 0) {
                    addGuard = true;
                    this.deferredGuard = 1;
                }
            }
            if (addGuard) {
                JavaSource js = J2SEActionProvider.createSource();
                CosAction cosAction2 = this;
                synchronized (cosAction2) {
                    if (this.deferredGuard == 1) {
                        this.deferredGuard = (byte)2;
                        try {
                            js.runWhenScanFinished(cc -> this.drainDeferred(), true);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drainDeferred() {
            Runnable[] runnableArray = this;
            synchronized (this) {
                Runnable[] todo = this.deferred.toArray(new Runnable[this.deferred.size()]);
                this.deferred.clear();
                this.deferredGuard = 0;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (Runnable r : todo) {
                    r.run();
                }
                return;
            }
        }

        @CheckForNull
        static CosAction getInstance(@NonNull Project p) {
            Reference<CosAction> r = instances.get(p);
            return r != null ? r.get() : null;
        }

        private static final class WeakArtifactUpdated
        extends WeakReference<BuildArtifactMapper.ArtifactsUpdated>
        implements BuildArtifactMapper.ArtifactsUpdated,
        Runnable {
            private final BuildArtifactMapper source;
            private final URL url;

            WeakArtifactUpdated(@NonNull BuildArtifactMapper.ArtifactsUpdated delegate, @NonNull BuildArtifactMapper source, @NonNull URL url) {
                super(delegate);
                Parameters.notNull((CharSequence)"source", (Object)source);
                Parameters.notNull((CharSequence)"url", (Object)url);
                this.source = source;
                this.url = url;
            }

            public void artifactsUpdated(@NonNull Iterable<File> artifacts) {
                BuildArtifactMapper.ArtifactsUpdated delegate = (BuildArtifactMapper.ArtifactsUpdated)this.get();
                if (delegate != null) {
                    delegate.artifactsUpdated(artifacts);
                }
            }

            @Override
            public void run() {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
        }
    }

    private static final class CallbackImpl
    implements BaseActionProvider.Callback3 {
        private final J2SEProject prj;

        CallbackImpl(@NonNull J2SEProject project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            this.prj = project;
        }

        @NonNull
        public Map<String, String> createAdditionalProperties(@NonNull String command, @NonNull Lookup context) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (J2SEBuildPropertiesProvider bpp : this.prj.getLookup().lookupAll(J2SEBuildPropertiesProvider.class)) {
                Map<String, String> contrib = bpp.createAdditionalProperties(command, context);
                assert (contrib != null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following build properties: {1}", new Object[]{bpp.getClass(), contrib});
                }
                result.putAll(contrib);
            }
            return Collections.unmodifiableMap(result);
        }

        public Set<String> createConcealedProperties(String command, Lookup context) {
            HashSet<String> result = new HashSet<String>();
            for (J2SEBuildPropertiesProvider bpp : this.prj.getLookup().lookupAll(J2SEBuildPropertiesProvider.class)) {
                Set<String> contrib = bpp.createConcealedProperties(command, context);
                assert (contrib != null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following concealed properties: {1}", new Object[]{bpp.getClass(), contrib});
                }
                result.addAll(contrib);
            }
            return Collections.unmodifiableSet(result);
        }

        public void antTargetInvocationStarted(@NonNull String command, @NonNull Lookup context) {
        }

        public void antTargetInvocationFinished(@NonNull String command, @NonNull Lookup context, int result) {
        }

        public void antTargetInvocationFailed(@NonNull String command, @NonNull Lookup context) {
        }

        @CheckForNull
        public ClassPath getProjectSourcesClassPath(@NonNull String type) {
            return this.prj.getClassPathProvider().getProjectSourcesClassPath(type);
        }

        @CheckForNull
        public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
            return this.prj.getClassPathProvider().findClassPath(file, type);
        }
    }
}

