/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.EntityClosure;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PersistenceClientEntitySelectionVisual
extends JPanel {
    private static final long serialVersionUID = -4552755466067867817L;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Project project;
    private boolean createPU = true;
    private EntityClosure entityClosure;
    private final boolean disableNoIdSelection;
    private JButton buttonAdd;
    private JButton buttonAddAll;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JCheckBox cbAddRelated;
    private JCheckBox createPUCheckbox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailableEntities;
    private JLabel labelSelectedEntities;
    private JList listAvailable;
    private JList listSelected;
    private JPanel panelButtons;
    private JPanel workAround1;
    private JPanel workAround2;
    private final ListCellRenderer ENTITY_LIST_RENDERER_AV = new EntityListCellRenderer(true);
    private final ListCellRenderer ENTITY_LIST_RENDERER_SEL = new EntityListCellRenderer(false);

    public PersistenceClientEntitySelectionVisual(String name, WizardDescriptor wizard) {
        this(name, wizard, false);
    }

    public PersistenceClientEntitySelectionVisual(String name, WizardDescriptor wizard, boolean requireReferencedClasses) {
        this.setName(name);
        this.initComponents();
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PersistenceClientEntitySelectionVisual.this.updateButtons();
            }
        };
        this.listAvailable.getSelectionModel().addListSelectionListener(selectionListener);
        this.listSelected.getSelectionModel().addListSelectionListener(selectionListener);
        boolean bl = this.disableNoIdSelection = wizard.getProperty("disableNoIdSelection") == Boolean.TRUE;
        if (requireReferencedClasses) {
            this.cbAddRelated.setSelected(true);
            this.cbAddRelated.setVisible(false);
        }
    }

    public boolean getCreatePersistenceUnit() {
        return this.createPU && this.createPUCheckbox.isVisible();
    }

    private Set<String> getSelectedEntities(JList list) {
        HashSet<String> result = new HashSet<String>();
        for (Object elem : Util.getSelectedItems(list, true)) {
            result.add((String)elem);
        }
        return result;
    }

    private Set<String> getEnabledEntities(JList list) {
        HashSet<String> result = new HashSet<String>();
        for (Object elem : Util.getEnabledItems(list)) {
            result.add((String)elem);
        }
        return result;
    }

    private void initComponents() {
        this.labelAvailableEntities = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JList();
        this.createPUCheckbox = new JCheckBox();
        this.workAround1 = new JPanel();
        this.panelButtons = new JPanel();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.buttonAddAll = new JButton();
        this.buttonRemoveAll = new JButton();
        this.workAround2 = new JPanel();
        this.labelSelectedEntities = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JList();
        this.cbAddRelated = new JCheckBox();
        this.setPreferredSize(new Dimension(500, 100));
        this.setLayout(new GridBagLayout());
        this.labelAvailableEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AvailableEntityClasses").charAt(0));
        this.labelAvailableEntities.setLabelFor(this.listAvailable);
        this.labelAvailableEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntities"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.labelAvailableEntities, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        this.listAvailable.setCellRenderer(this.ENTITY_LIST_RENDERER_AV);
        this.jScrollPane1.setViewportView(this.listAvailable);
        this.listAvailable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntitiesList"));
        this.listAvailable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AvailableEntitiesList"));
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.createPUCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.setEnabled(false);
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PersistenceClientEntitySelectionVisual.this.createPUCheckboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.createPUCheckbox, gridBagConstraints);
        GroupLayout workAround1Layout = new GroupLayout(this.workAround1);
        this.workAround1.setLayout(workAround1Layout);
        workAround1Layout.setHorizontalGroup(workAround1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        workAround1Layout.setVerticalGroup(workAround1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 444, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 32;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.workAround1, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.buttonAdd.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Add").charAt(0));
        this.buttonAdd.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Add"));
        this.buttonAdd.setActionCommand("&Add >");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 74;
        gridBagConstraints.anchor = 18;
        this.panelButtons.add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Add"));
        this.buttonRemove.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Remove").charAt(0));
        this.buttonRemove.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Remove"));
        this.buttonRemove.setActionCommand("< &Remove");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 54;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panelButtons.add((Component)this.buttonRemove, gridBagConstraints);
        this.buttonRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Remove"));
        this.buttonAddAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AddAll").charAt(0));
        this.buttonAddAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AddAll"));
        this.buttonAddAll.setActionCommand("Add A&ll >>");
        this.buttonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 52;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.panelButtons.add((Component)this.buttonAddAll, gridBagConstraints);
        this.buttonAddAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AddAll"));
        this.buttonRemoveAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_RemoveAll").charAt(0));
        this.buttonRemoveAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_RemoveAll"));
        this.buttonRemoveAll.setActionCommand("<< Re&moveAll");
        this.buttonRemoveAll.setMaximumSize(new Dimension(137, 23));
        this.buttonRemoveAll.setMinimumSize(new Dimension(137, 23));
        this.buttonRemoveAll.setPreferredSize(new Dimension(137, 23));
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panelButtons.add((Component)this.buttonRemoveAll, gridBagConstraints);
        this.buttonRemoveAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_RemoveAll"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 33;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
        GroupLayout workAround2Layout = new GroupLayout(this.workAround2);
        this.workAround2.setLayout(workAround2Layout);
        workAround2Layout.setHorizontalGroup(workAround2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        workAround2Layout.setVerticalGroup(workAround2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 444, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 34;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.workAround2, gridBagConstraints);
        this.labelSelectedEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_SelectedEntityClasses").charAt(0));
        this.labelSelectedEntities.setLabelFor(this.listSelected);
        this.labelSelectedEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 222;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.labelSelectedEntities, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout());
        this.listSelected.setCellRenderer(this.ENTITY_LIST_RENDERER_SEL);
        this.jScrollPane2.setViewportView(this.listSelected);
        this.listSelected.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntitiesList"));
        this.listSelected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_SelectedEntitiesList"));
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 222;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.cbAddRelated.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_InludeRelated").charAt(0));
        this.cbAddRelated.setSelected(true);
        this.cbAddRelated.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferenced"));
        this.cbAddRelated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddRelated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.cbAddRelatedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 222;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cbAddRelated, gridBagConstraints);
        this.cbAddRelated.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferencedCheckbox"));
        this.cbAddRelated.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_IncludeReferencedCheckbox"));
    }

    private void cbAddRelatedActionPerformed(ActionEvent evt) {
        this.listSelected.clearSelection();
        this.listAvailable.clearSelection();
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.changeSupport.fireChange();
    }

    private void createPUCheckboxItemStateChanged(ItemEvent evt) {
        this.createPU = this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
    }

    private void buttonRemoveAllActionPerformed(ActionEvent evt) {
        this.entityClosure.removeAllEntities();
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddAllActionPerformed(ActionEvent evt) {
        this.listAvailable.clearSelection();
        this.entityClosure.addEntities(this.getEnabledEntities(this.listAvailable));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        this.entityClosure.removeEntities(this.getSelectedEntities(this.listSelected));
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.entityClosure.addEntities(this.getSelectedEntities(this.listAvailable));
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public boolean valid(WizardDescriptor wizard) {
        ClassPath compileCP;
        SourceGroup[] groups = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (groups.length > 0 && ((compileCP = ClassPath.getClassPath((FileObject)groups[0].getRootFolder(), (String)"classpath/compile")) == null || compileCP.findResource("javax/persistence/Entity.class") == null)) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoPersistenceProvider"));
            return false;
        }
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_MissingServer"));
            return false;
        }
        if (!this.entityClosure.isModelReady()) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"scanning-in-progress"));
            return false;
        }
        if (this.listSelected.getModel().getSize() == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MSG_NoEntityClassesSelected"));
            return false;
        }
        if (this.entityClosure.isEjbModuleInvolved()) {
            wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"WARN_DetectedEntitiesFromEjbModule"));
            return true;
        }
        wizard.putProperty("WizardPanel_warningMessage", (Object)" ");
        wizard.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.project.getProjectDirectory());
        this.entityClosure = EntityClosure.create(entityClassScope, this.project);
        this.entityClosure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersistenceClientEntitySelectionVisual.this.changeSupport.fireChange();
                PersistenceClientEntitySelectionVisual.this.updateAddAllButton();
            }
        });
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.listAvailable.setModel(new EntityListModel(this.entityClosure, true));
        this.listSelected.setModel(new EntityListModel(this.entityClosure, false));
        ArrayList entities = (ArrayList)settings.getProperty("EntityClass");
        if (entities == null) {
            entities = new ArrayList();
        }
        this.entityClosure.addEntities(new HashSet<String>(entities));
        this.updateButtons();
        this.updatePersistenceUnitButton();
    }

    public void store(WizardDescriptor settings) {
        ListModel model = this.listSelected.getModel();
        if (model instanceof EntityListModel) {
            EntityListModel elm = (EntityListModel)model;
            settings.putProperty("EntityClass", elm.getEntityClasses());
        }
    }

    private void updateButtons() {
        Set selectedItems = Util.getSelectedItems(this.listAvailable, true);
        this.buttonAdd.setEnabled(!selectedItems.isEmpty());
        this.updateAddAllButton();
        this.buttonRemove.setEnabled(this.listSelected.getSelectedValues().length > 0);
        this.buttonRemoveAll.setEnabled(this.entityClosure.getSelectedEntities().size() > 0);
    }

    private void updateAddAllButton() {
        this.buttonAddAll.setEnabled(!Util.getEnabledItems(this.listAvailable).isEmpty());
    }

    public void updatePersistenceUnitButton() {
        boolean visible = true;
        if (ProviderUtil.isValidServerInstanceOrNone(this.project) && visible) {
            try {
                visible = !ProviderUtil.persistenceExists(this.project);
            }
            catch (InvalidPersistenceXmlException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.createPUCheckbox.setVisible(visible);
    }

    private final class EntityListCellRenderer
    extends DefaultListCellRenderer {
        private boolean available;

        public EntityListCellRenderer(boolean available) {
            this.setOpaque(true);
            this.available = available;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            String text = null;
            boolean disable = false;
            if (value instanceof Entity) {
                Entity entity = (Entity)value;
                text = entity.getClass2();
                if (text != null) {
                    String simpleName = JavaIdentifiers.unqualify((String)text);
                    String packageName = text.length() > simpleName.length() ? text.substring(0, text.length() - simpleName.length() - 1) : "<default package>";
                    text = simpleName + " (" + packageName + ")";
                } else {
                    Logger.getLogger("global").log(Level.INFO, "Entity:" + value + " returns null from getClass2(); see IZ 80024");
                }
                if (PersistenceClientEntitySelectionVisual.this.disableNoIdSelection && this.available && PersistenceClientEntitySelectionVisual.this.entityClosure.haveId(entity.getClass2()) != Boolean.TRUE) {
                    text = text + " (" + NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoId") + ")";
                    disable = PersistenceClientEntitySelectionVisual.this.disableNoIdSelection;
                }
            }
            if (text == null) {
                text = value.toString();
                if (PersistenceClientEntitySelectionVisual.this.disableNoIdSelection && this.available && PersistenceClientEntitySelectionVisual.this.entityClosure.haveId(text) != Boolean.TRUE && PersistenceClientEntitySelectionVisual.this.entityClosure.getEntity(text) != null) {
                    text = text + " (" + NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoId") + ")";
                    disable = PersistenceClientEntitySelectionVisual.this.disableNoIdSelection;
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (text.length() == 0) {
                text = " ";
            }
            label.setEnabled((PersistenceClientEntitySelectionVisual.this.entityClosure.getAvailableEntities().contains(value) || PersistenceClientEntitySelectionVisual.this.entityClosure.getWantedEntities().contains(value)) && !disable);
            label.setText(text);
            return label;
        }
    }

    private class EntityListModel
    extends AbstractListModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<String> entities = new ArrayList<String>();
        private boolean available;

        EntityListModel(EntityClosure entityClosure, boolean available) {
            this.entityClosure = entityClosure;
            this.available = available;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.entities.get(index);
        }

        public List<String> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.entities = new ArrayList<String>(this.available ? this.entityClosure.getAvailableEntities() : this.entityClosure.getSelectedEntities());
            Collections.sort(this.entities);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }
    }
}

