/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.awt.GraphicsUtils;

public class LinkButton
extends JButton
implements MouseListener {
    private static final Font BUTTON_FONT = LinkButton.getButtonFont();
    private static final Color LINK_IN_FOCUS_COLOR;
    private static final Color LINK_COLOR;
    private static final Color MOUSE_OVER_LINK_COLOR;
    private static final Color VISITED_LINK_COLOR;
    private static final Stroke LINK_IN_FOCUS_STROKE;
    private boolean underline = false;

    public LinkButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public LinkButton(Action a) {
        super(a);
        this.init();
    }

    public LinkButton(String text) {
        super(text);
        this.init();
    }

    public LinkButton(Icon icon) {
        super(icon);
        this.init();
    }

    public LinkButton() {
        this.init();
    }

    private void init() {
        this.setForeground(LINK_COLOR);
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(LINK_IN_FOCUS_COLOR);
            this.repaint();
            this.onMouseEntered(e);
            this.setForeground(MOUSE_OVER_LINK_COLOR);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            this.setForeground(this.isVisited() ? VISITED_LINK_COLOR : LINK_COLOR);
            this.repaint();
            this.onMouseExited(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g2);
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(LINK_IN_FOCUS_COLOR);
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled()) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    private static Font getButtonFont() {
        Font defaultFont = UIManager.getFont("Button.font");
        if (defaultFont != null) {
            return defaultFont;
        }
        return new Font(null, 0, 12);
    }

    static {
        LINK_IN_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
        Color c = UIManager.getColor("nb.html.link.foreground.focus");
        LINK_IN_FOCUS_COLOR = c == null ? new Color(16748032) : c;
        c = UIManager.getColor("nb.html.link.foreground");
        LINK_COLOR = c == null ? new Color(1461115) : c;
        c = UIManager.getColor("nb.html.link.foreground.hover");
        MOUSE_OVER_LINK_COLOR = c == null ? new Color(16748032) : c;
        c = UIManager.getColor("nb.html.link.foreground.visited");
        VISITED_LINK_COLOR = c == null ? new Color(5607890) : c;
    }
}

