/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api;

import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;

public final class PhpModifiers
extends BodyDeclaration.Modifier {
    private int mod;
    public static final int NO_FLAGS = 0;
    public static final int ALL_FLAGS = -1;
    private static final PhpModifiers EMPTY = new PhpModifiers(0);
    public static final String VISIBILITY_VAR = "var";
    public static final String VISIBILITY_PUBLIC = "public";
    public static final String VISIBILITY_PRIVATE = "private";
    public static final String VISIBILITY_PROTECTED = "protected";
    public static final String FINAL_MODIFIER = "final";
    public static final String ABSTRACT_MODIFIER = "abstract";
    public static final String READONLY_MODIFIER = "readonly";

    public static PhpModifiers noModifiers() {
        return PhpModifiers.fromBitMask(new int[0]);
    }

    public static PhpModifiers fromBitMask(int ... bitmasks) {
        return bitmasks.length == 0 ? EMPTY : new PhpModifiers(bitmasks);
    }

    public PhpModifiers setImplicitPublic() {
        this.mod |= 0x20;
        return this;
    }

    public PhpModifiers setPublic() {
        this.mod |= 1;
        return this;
    }

    public PhpModifiers setPrivate() {
        this.mod |= 2;
        return this;
    }

    public PhpModifiers setProtected() {
        this.mod |= 4;
        return this;
    }

    public PhpModifiers setStatic() {
        this.mod |= 8;
        return this;
    }

    public PhpModifiers setFinal() {
        this.mod |= 0x10;
        return this;
    }

    public PhpModifiers setAbstract() {
        this.mod |= 0x400;
        return this;
    }

    public PhpModifiers setReadonly() {
        this.mod |= 0x40;
        return this;
    }

    private PhpModifiers(int ... bitmask) {
        for (int mode : bitmask) {
            this.mod |= mode;
        }
        if (!(BodyDeclaration.Modifier.isPrivate(this.mod) || BodyDeclaration.Modifier.isProtected(this.mod) || BodyDeclaration.Modifier.isImplicitPublic(this.mod))) {
            this.mod |= 1;
        }
    }

    public Set<Modifier> toModifiers() {
        LinkedHashSet<Modifier> retval = new LinkedHashSet<Modifier>();
        if ((this.isPublic() || this.isImplicitPublic()) && !this.isStatic()) {
            retval.add(Modifier.PUBLIC);
        }
        if (this.isProtected()) {
            retval.add(Modifier.PROTECTED);
        }
        if (this.isPrivate()) {
            retval.add(Modifier.PRIVATE);
        }
        if (this.isStatic()) {
            retval.add(Modifier.STATIC);
        }
        if (this.isAbstract()) {
            retval.add(Modifier.ABSTRACT);
        }
        return retval;
    }

    public int toFlags() {
        return this.mod;
    }

    public boolean isImplicitPublic() {
        return BodyDeclaration.Modifier.isImplicitPublic(this.mod);
    }

    public boolean isPublic() {
        return BodyDeclaration.Modifier.isPublic(this.mod);
    }

    public boolean isPrivate() {
        return BodyDeclaration.Modifier.isPrivate(this.mod);
    }

    public boolean isProtected() {
        return BodyDeclaration.Modifier.isProtected(this.mod);
    }

    public boolean isStatic() {
        return BodyDeclaration.Modifier.isStatic(this.mod);
    }

    public boolean isFinal() {
        return BodyDeclaration.Modifier.isFinal(this.mod);
    }

    public boolean isAbstract() {
        return BodyDeclaration.Modifier.isAbstract(this.mod);
    }

    public boolean isReadonly() {
        return BodyDeclaration.Modifier.isReadonly(this.mod);
    }

    public String toString() {
        return BodyDeclaration.Modifier.toString(this.mod);
    }

    public boolean equals(Object obj) {
        return obj instanceof PhpModifiers ? ((PhpModifiers)obj).mod == this.mod : false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + this.mod;
        return hash;
    }
}

