/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Processor;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner14;
import javax.swing.SwingUtilities;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.ElementUtils;
import org.netbeans.modules.java.source.JavadocHelper;
import org.netbeans.modules.java.source.ModuleNames;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.Hacks;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class SourceUtils {
    private static final Logger LOG = Logger.getLogger(SourceUtils.class.getName());

    private SourceUtils() {
    }

    public static TokenSequence<JavaTokenId> getJavaTokenSequence(TokenHierarchy hierarchy, int offset) {
        if (hierarchy != null) {
            for (TokenSequence ts = hierarchy.tokenSequence(); ts != null && (offset == 0 || ts.moveNext()); ts = ts.embedded()) {
                ts.move(offset);
                if (ts.language() == JavaTokenId.language()) {
                    return ts;
                }
                if (ts.moveNext() || ts.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static Set<TreePath> computeDuplicates(CompilationInfo info, TreePath searchingFor, TreePath scope, AtomicBoolean cancel) {
        HashSet<TreePath> result = new HashSet<TreePath>();
        for (Occurrence occurrence : Matcher.create(info).setCancel(cancel).setSearchRoot(scope).match(Pattern.createSimplePattern(searchingFor))) {
            result.add(occurrence.getOccurrenceRoot());
        }
        return result;
    }

    public static boolean checkTypesAssignable(CompilationInfo info, TypeMirror from, TypeMirror to) {
        Context c = info.impl.getJavacTask().getContext();
        if (from.getKind() == TypeKind.TYPEVAR) {
            Types types = Types.instance(c);
            Type.TypeVar t = types.substBound((Type.TypeVar)from, List.of((Type)from), List.of(types.boxedTypeOrType((Type)to)));
            return info.getTypes().isAssignable(t.getUpperBound(), to) || info.getTypes().isAssignable(to, t.getUpperBound());
        }
        if (from.getKind() == TypeKind.WILDCARD) {
            from = Types.instance(c).wildUpperBound((Type)from);
        }
        return Check.instance(c).checkType(null, (Type)from, (Type)to).getKind() != TypeKind.ERROR;
    }

    public static TypeMirror getBound(WildcardType wildcardType) {
        Type.TypeVar bound = ((Type.WildcardType)wildcardType).bound;
        return bound != null ? bound.getUpperBound() : null;
    }

    public static java.util.List<? extends Completion> getAttributeValueCompletions(CompilationInfo info, Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        LinkedList<Completion> completions = new LinkedList<Completion>();
        if (info.getPhase().compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
            String fqn = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
            Collection<? extends Processor> processors = JavacParser.ProcessorHolder.instance(info.impl.getJavacTask().getContext()).getProcessors();
            if (processors != null) {
                for (Processor processor : processors) {
                    boolean match = false;
                    for (String string : processor.getSupportedAnnotationTypes()) {
                        if ("*".equals(string)) {
                            match = true;
                            break;
                        }
                        if (string.endsWith(".*")) {
                            String string2 = string.substring(0, string.length() - 1);
                            if (!fqn.startsWith(string2)) continue;
                            match = true;
                            break;
                        }
                        if (!fqn.equals(string)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    try {
                        for (Completion completion : processor.getCompletions(element, annotation, member, userText)) {
                            completions.add(completion);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(processor.getClass().getName()).log(Level.INFO, e.getMessage(), e);
                    }
                }
            }
        }
        return completions;
    }

    @Deprecated
    public static TypeElement getEnclosingTypeElement(Element element) throws IllegalArgumentException {
        return ElementUtilities.enclosingTypeElementImpl(element);
    }

    public static TypeElement getOutermostEnclosingTypeElement(Element element) {
        Element ec = SourceUtils.getEnclosingTypeElement(element);
        if (ec == null) {
            ec = element;
        }
        while (ec.getEnclosingElement().getKind().isClass() || ec.getEnclosingElement().getKind().isInterface()) {
            ec = ec.getEnclosingElement();
        }
        return (TypeElement)ec;
    }

    public static String findSourceFileName(Element element) {
        if (element instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol s = (Symbol.ClassSymbol)element;
            if (s.sourcefile != null) {
                return s.sourcefile.getName();
            }
        }
        return null;
    }

    @NonNull
    public static String[] getJVMSignature(@NonNull ElementHandle<?> handle) {
        Parameters.notNull((CharSequence)"handle", handle);
        return ElementHandleAccessor.getInstance().getJVMSignature(handle);
    }

    public static String resolveImport(final CompilationInfo info, TreePath context, String fqn) throws NullPointerException, IOException {
        if (info == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        if (fqn == null) {
            throw new NullPointerException();
        }
        CodeStyle cs = DiffContext.getCodeStyle(info);
        if (cs.useFQNs()) {
            return fqn;
        }
        CompilationUnitTree cut = info.getCompilationUnit();
        final Trees trees = info.getTrees();
        final com.sun.source.tree.Scope scope = trees.getScope(context);
        String qName = fqn;
        StringBuilder sqName = new StringBuilder();
        boolean clashing = false;
        ElementUtilities eu = info.getElementUtilities();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            @Override
            public boolean accept(Element e, TypeMirror type) {
                return (e.getKind().isClass() || e.getKind().isInterface()) && trees.isAccessible(scope, (TypeElement)e);
            }
        };
        Element el = info.getTrees().getElement(new TreePath(cut));
        ModuleElement modle = el != null ? info.getElements().getModuleOf(el) : null;
        QualifiedNameable toImport = null;
        while (qName != null && qName.length() > 0) {
            int lastDot = qName.lastIndexOf(46);
            QualifiedNameable element = modle != null ? info.getElements().getTypeElement(modle, qName) : info.getElements().getTypeElement(qName);
            if (element != null) {
                clashing = false;
                String simple = qName.substring(lastDot < 0 ? 0 : lastDot + 1);
                if (sqName.length() > 0) {
                    sqName.insert(0, '.');
                }
                sqName.insert(0, simple);
                if (cs.useSingleClassImport() && (toImport == null || !cs.importInnerClasses())) {
                    toImport = element;
                }
                boolean matchFound = false;
                for (Element element2 : eu.getLocalMembersAndVars(scope, acceptor)) {
                    if (!simple.contentEquals(element2.getSimpleName())) continue;
                    if (qName.contentEquals(((TypeElement)element2).getQualifiedName())) {
                        return sqName.toString();
                    }
                    clashing = true;
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    for (TypeElement typeElement : eu.getGlobalTypes(acceptor)) {
                        if (!simple.contentEquals(typeElement.getSimpleName())) continue;
                        if (qName.contentEquals(typeElement.getQualifiedName())) {
                            return sqName.toString();
                        }
                        clashing = true;
                        break;
                    }
                }
                if (cs.importInnerClasses()) {
                    break;
                }
            } else {
                element = modle != null ? info.getElements().getPackageElement(modle, qName) : info.getElements().getPackageElement(qName);
                if (element != null) {
                    if (toImport != null && !GeneratorUtilities.checkPackagesForStarImport(qName, cs)) break;
                    toImport = element;
                    break;
                }
            }
            qName = lastDot < 0 ? null : qName.substring(0, lastDot);
        }
        if (clashing || toImport == null) {
            return fqn;
        }
        String topLevelLanguageMIMEType = info.getFileObject().getMIMEType();
        if ("text/x-java".equals(topLevelLanguageMIMEType)) {
            Set<Object> elementsToImport = Collections.singleton(toImport);
            if (info instanceof WorkingCopy) {
                CompilationUnitTree nue = (CompilationUnitTree)((WorkingCopy)info).resolveRewriteTarget(cut);
                ((WorkingCopy)info).rewrite(info.getCompilationUnit(), GeneratorUtilities.get((WorkingCopy)info).addImports(nue, elementsToImport));
                ((WorkingCopy)info).invalidateSourceAfter = true;
            } else {
                final ElementHandle<Object> handle = ElementHandle.create(toImport);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult.runModificationTask(Collections.singletonList(info.getSnapshot().getSource()), new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    WorkingCopy copy = WorkingCopy.get(resultIterator.getParserResult());
                                    copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    Object elementToImport = handle.resolve(copy);
                                    if (elementToImport == null) {
                                        return;
                                    }
                                    copy.rewrite(copy.getCompilationUnit(), GeneratorUtilities.get(copy).addImports(copy.getCompilationUnit(), Collections.singleton(elementToImport)));
                                }
                            }).commit();
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)info.getCompilationUnit();
            if (toImport.getKind() == ElementKind.PACKAGE) {
                Scope.StarImportScope importScope = new Scope.StarImportScope(unit.packge);
                importScope.prependSubScope(unit.starImportScope);
                importScope.prependSubScope(((Symbol.PackageSymbol)toImport).members());
                unit.starImportScope = importScope;
            } else {
                Scope.NamedImportScope importScope;
                Class<Scope.NamedImportScope> nisClazz = Scope.NamedImportScope.class;
                try {
                    importScope = (Scope.NamedImportScope)nisClazz.getConstructor(Symbol.class, Scope.class).newInstance(unit.packge, unit.toplevelScope);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    try {
                        importScope = (Scope.NamedImportScope)nisClazz.getConstructor(Symbol.class).newInstance(unit.packge);
                    }
                    catch (ReflectiveOperationException ex2) {
                        throw new IllegalStateException(ex2);
                    }
                }
                for (Symbol symbol : unit.namedImportScope.getSymbols()) {
                    importScope.importType(symbol.owner.members(), symbol.owner.members(), symbol);
                }
                importScope.importType(((Symbol)((Object)toImport)).owner.members(), ((Symbol)((Object)toImport)).owner.members(), (Symbol)((Object)toImport));
                unit.namedImportScope = importScope;
            }
        } else {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)topLevelLanguageMIMEType));
            Collection instances = lookup.lookupAll(ImportProcessor.class);
            for (ImportProcessor importsProcesor : instances) {
                importsProcesor.addImport(info.getDocument(), fqn);
            }
        }
        return sqName.toString();
    }

    @Deprecated
    public static FileObject getFile(Element element, ClasspathInfo cpInfo) {
        Element prev;
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        Element element2 = prev = SourceUtils.isPkgOrMdl(element.getKind()) ? element : null;
        while (!SourceUtils.isPkgOrMdl(element.getKind())) {
            prev = element;
            element = element.getEnclosingElement();
        }
        ElementKind kind = prev.getKind();
        if (!(kind.isClass() || kind.isInterface() || SourceUtils.isPkgOrMdl(kind))) {
            return null;
        }
        ElementHandle<Element> handle = ElementHandle.create(prev);
        return SourceUtils.getFile(handle, cpInfo, null);
    }

    public static FileObject getFile(ElementHandle<? extends Element> handle, ClasspathInfo cpInfo) {
        return SourceUtils.getFile(handle, cpInfo, new String[0]);
    }

    public static FileObject getFile(ElementHandle<? extends Element> handle, ClasspathInfo cpInfo, String ... names) {
        Parameters.notNull((CharSequence)"handle", handle);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        try {
            String pkgName;
            boolean pkg = handle.getKind() == ElementKind.PACKAGE;
            String[] signature = handle.getSignature();
            assert (signature.length >= 1);
            ClassPath[] cps = new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.COMPILE)};
            String className = null;
            Predicate<FileObject> filter = p -> true;
            if (pkg) {
                pkgName = FileObjects.convertPackage2Folder(signature[0]);
            } else if (handle.getKind() == ElementKind.MODULE) {
                pkgName = "";
                className = "module-info";
                String moduleName = handle.getQualifiedName();
                JavaFileManager fm = ClasspathInfoAccessor.getINSTANCE().createFileManager(cpInfo, null);
                JavaFileManager.Location loc = fm.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_PATH, moduleName);
                if (loc == null && (loc = fm.getLocationForModule((JavaFileManager.Location)StandardLocation.SYSTEM_MODULES, moduleName)) == null) {
                    loc = fm.getLocationForModule((JavaFileManager.Location)StandardLocation.UPGRADE_MODULE_PATH, moduleName);
                }
                if (loc != null) {
                    FileObject foundFo;
                    FileObject fo2;
                    JavaFileObject jfo = fm.getJavaFileForInput(loc, className, JavaFileObject.Kind.CLASS);
                    FileObject fileObject = fo2 = jfo != null ? URLMapper.findFileObject((URL)jfo.toUri().toURL()) : null;
                    if (fo2 != null && (foundFo = SourceUtils.findSourceForBinary(fo2.getParent(), fo2, signature[0], pkgName, className, false, names)) != null) {
                        return foundFo;
                    }
                }
                filter = fo -> moduleName.equals(SourceUtils.getModuleName(fo.toURL()));
            } else {
                int index = signature[0].lastIndexOf(46);
                if (index < 0) {
                    pkgName = "";
                    className = signature[0];
                } else {
                    pkgName = FileObjects.convertPackage2Folder(signature[0].substring(0, index));
                    className = signature[0].substring(index + 1);
                }
            }
            java.util.List<Pair<FileObject, ClassPath>> fos = SourceUtils.findAllResources(pkgName, filter, cps);
            for (Pair<FileObject, ClassPath> pair : fos) {
                FileObject foundFo;
                FileObject root = ((ClassPath)pair.second()).findOwnerRoot((FileObject)pair.first());
                if (root == null || (foundFo = SourceUtils.findSourceForBinary(root, (FileObject)pair.first(), signature[0], pkgName, className, pkg, names)) == null) continue;
                return foundFo;
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static FileObject findSourceForBinary(FileObject binaryRoot, FileObject binary, String signature, String pkgName, String className, boolean isPkg, String[] names) throws IOException {
        FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)binaryRoot.toURL()).getRoots();
        ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
        LinkedList<FileObject> folders = new LinkedList<FileObject>(sourcePath.findAllResources(pkgName));
        if (isPkg) {
            return folders.isEmpty() ? binary : (FileObject)folders.get(0);
        }
        boolean caseSensitive = SourceUtils.isCaseSensitive();
        ArrayList<String> fnames = new ArrayList<String>();
        fnames.addAll(SourceUtils.getSourceFileNames(className));
        if (names != null) {
            fnames.addAll(Arrays.asList(names));
        }
        folders.addFirst(binary);
        if (fnames.size() == 1) {
            FileObject match = SourceUtils.findMatchingChild((String)fnames.get(0), folders, caseSensitive);
            if (match != null) {
                return match;
            }
        } else {
            for (String candidate : fnames) {
                FQN2Files fQN2Files;
                FileObject match = SourceUtils.findMatchingChild(candidate, folders, caseSensitive);
                if (match == null) continue;
                FileObject ownerRoot = sourcePath.entries().isEmpty() ? binaryRoot : sourcePath.findOwnerRoot(match);
                FQN2Files fQN2Files2 = fQN2Files = ownerRoot != null ? FQN2Files.forRoot(ownerRoot.toURL()) : null;
                if (fQN2Files != null && fQN2Files.check(signature, match.toURL())) continue;
                return match;
            }
        }
        return sourceRoots.length == 0 ? SourceUtils.findSource(signature, binaryRoot) : SourceUtils.findSource(signature, sourceRoots);
    }

    private static FileObject findMatchingChild(String sourceFileName, Collection<FileObject> folders, boolean caseSensitive) {
        Match matchSet = caseSensitive ? new CaseSensitiveMatch(sourceFileName) : new CaseInsensitiveMatch(sourceFileName);
        for (FileObject folder : folders) {
            for (FileObject child : folder.getChildren()) {
                if (!matchSet.apply(child)) continue;
                return child;
            }
        }
        return null;
    }

    @NonNull
    private static java.util.List<Pair<FileObject, ClassPath>> findAllResources(@NonNull String resourceName, @NonNull Predicate<? super FileObject> rootsFilter, ClassPath ... cps) {
        ArrayList<Pair<FileObject, ClassPath>> result = new ArrayList<Pair<FileObject, ClassPath>>();
        for (ClassPath cp : cps) {
            for (FileObject fo : cp.findAllResources(resourceName)) {
                FileObject root = cp.findOwnerRoot(fo);
                if (root == null || !rootsFilter.test((FileObject)root)) continue;
                result.add((Pair<FileObject, ClassPath>)Pair.of((Object)fo, (Object)cp));
            }
        }
        return result;
    }

    private static FileObject findSource(String binaryName, FileObject ... fos) throws IOException {
        ClassIndexManager cim = ClassIndexManager.getDefault();
        try {
            for (FileObject fo : fos) {
                FileObject result;
                String sourceName;
                ClassIndexImpl ci = cim.getUsagesQuery(fo.toURL(), true);
                if (ci == null || (sourceName = ci.getSourceName(binaryName)) == null || (result = fo.getFileObject(sourceName)) == null) continue;
                return result;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static URL getJavadoc(Element element, ClasspathInfo cpInfo) {
        Collection<? extends URL> res = SourceUtils.getJavadoc(element);
        return res.isEmpty() ? null : res.iterator().next();
    }

    @CheckForNull
    public static URL getPreferredJavadoc(@NonNull Element element) {
        Parameters.notNull((CharSequence)"element", (Object)element);
        JavadocHelper.TextStream page = JavadocHelper.getJavadoc(element);
        if (page == null) {
            return null;
        }
        return page.getLocation();
    }

    @NonNull
    public static Collection<? extends URL> getJavadoc(@NonNull Element element) {
        Parameters.notNull((CharSequence)"element", (Object)element);
        JavadocHelper.TextStream page = JavadocHelper.getJavadoc(element);
        if (page == null) {
            return Collections.emptySet();
        }
        page.close();
        return page.getLocations();
    }

    public static boolean isScanInProgress() {
        return IndexingManager.getDefault().isIndexing();
    }

    @Deprecated
    public static void waitScanFinished() throws InterruptedException {
        try {
            class T
            extends UserTask
            implements ClasspathInfoProvider {
                private final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
                private final ClasspathInfo cpinfo = ClasspathInfo.create(this.EMPTY_PATH, this.EMPTY_PATH, this.EMPTY_PATH);

                T() {
                }

                public void run(ResultIterator resultIterator) throws Exception {
                }

                @Override
                public ClasspathInfo getClasspathInfo() {
                    return this.cpinfo;
                }
            }
            Future f = ParserManager.parseWhenScanFinished((String)"text/x-java", (UserTask)new T());
            if (!f.isDone()) {
                f.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    public static Set<URL> getDependentRoots(@NonNull URL root) {
        return SourceUtils.getDependentRoots(root, true);
    }

    @NonNull
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    public static Set<URL> getDependentRoots(@NonNull URL root, boolean filterNonOpenedProjects) {
        FileObject rootFO = URLMapper.findFileObject((URL)root);
        if (rootFO != null) {
            return SourceUtils.mapToURLs(QuerySupport.findDependentRoots((FileObject)rootFO, (boolean)filterNonOpenedProjects));
        }
        return Collections.singleton(root);
    }

    public static boolean isClassFile(@NonNull FileObject file) {
        return "class".equals(file.getExt()) || "application/x-class-file".equals(file.getMIMEType(new String[]{"application/x-class-file"}));
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(@NonNull FileObject fo) {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        if (!fo.isValid()) {
            throw new IllegalArgumentException("FileObject : " + FileUtil.getFileDisplayName((FileObject)fo) + " is not valid.");
        }
        if (fo.isVirtual()) {
            throw new IllegalArgumentException("FileObject : " + FileUtil.getFileDisplayName((FileObject)fo) + " is virtual.");
        }
        JavaSource js = JavaSource.forFileObject(fo);
        if (js == null) {
            throw new IllegalArgumentException();
        }
        try {
            final LinkedHashSet<ElementHandle<TypeElement>> result = new LinkedHashSet<ElementHandle<TypeElement>>();
            js.runUserActionTask(new Task<CompilationController>(){

                @Override
                public void run(CompilationController control) throws Exception {
                    if (control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        final ArrayList types = new ArrayList();
                        ElementScanner14<Void, Void> visitor = new ElementScanner14<Void, Void>(){

                            @Override
                            public Void visitType(TypeElement e, Void p) {
                                if (e.getEnclosingElement().getKind() == ElementKind.PACKAGE || e.getModifiers().contains((Object)Modifier.STATIC)) {
                                    types.add(e);
                                    return (Void)super.visitType(e, p);
                                }
                                return null;
                            }
                        };
                        visitor.scan(control.getTopLevelElements(), null);
                        for (TypeElement type : types) {
                            for (ExecutableElement exec : ElementFilter.methodsIn(control.getElements().getAllMembers(type))) {
                                if (!SourceUtils.isMainMethod(exec)) continue;
                                result.add(ElementHandle.create(type));
                            }
                        }
                    }
                }
            }, true);
            return result;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptySet();
        }
    }

    public static boolean isMainClass(String qualifiedName, ClasspathInfo cpInfo) {
        return SourceUtils.isMainClass(qualifiedName, cpInfo, false);
    }

    public static boolean isMainClass(final String qualifiedName, ClasspathInfo cpInfo, boolean optimistic) {
        if (qualifiedName == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        block6: for (ClassPath.Entry entry : cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries()) {
            Iterable<? extends URL> mainClasses = ExecutableFilesIndex.DEFAULT.getMainClasses(entry.getURL());
            try {
                URI root = entry.getURL().toURI();
                for (URL uRL : mainClasses) {
                    try {
                        URI relative = root.relativize(uRL.toURI());
                        String resourceNameNoExt = FileObjects.stripExtension(relative.getPath());
                        String ffqn = FileObjects.convertFolder2Package(resourceNameNoExt, '/');
                        if (!qualifiedName.equals(ffqn)) continue;
                        ClassPath bootCp = cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                        if (bootCp.findResource(resourceNameNoExt + '.' + "class") != null) continue block6;
                        return true;
                    }
                    catch (URISyntaxException e) {
                        LOG.log(Level.INFO, "Ignoring fast check for file: {0} due to: {1}", new Object[]{uRL.toString(), e.getMessage()});
                    }
                }
            }
            catch (URISyntaxException e) {
                LOG.log(Level.INFO, "Ignoring fast check for root: {0} due to: {1}", new Object[]{entry.getURL().toString(), e.getMessage()});
            }
        }
        final boolean[] result = new boolean[]{false};
        if (!optimistic) {
            JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
            try {
                js.runUserActionTask(new Task<CompilationController>(){

                    @Override
                    public void run(CompilationController control) throws Exception {
                        control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        JavacElements elms = (JavacElements)control.getElements();
                        TypeElement type = ElementUtils.getTypeElementByBinaryName(control, qualifiedName);
                        if (type == null) {
                            return;
                        }
                        java.util.List<ExecutableElement> methods = ElementFilter.methodsIn(elms.getAllMembers(type));
                        for (ExecutableElement method : methods) {
                            if (!SourceUtils.isMainMethod(method)) continue;
                            result[0] = true;
                            break;
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return result[0];
    }

    public static boolean isMainMethod(ExecutableElement method) {
        if (!"main".contentEquals(method.getSimpleName())) {
            return false;
        }
        long flags = ((Symbol.MethodSymbol)method).flags();
        if ((flags & 1L) == 0L || (flags & 8L) == 0L) {
            return false;
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            return false;
        }
        java.util.List<? extends VariableElement> params = method.getParameters();
        if (params.size() != 1) {
            return false;
        }
        TypeMirror param = params.get(0).asType();
        if (param.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType array = (ArrayType)param;
        TypeMirror compound = array.getComponentType();
        if (compound.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return "java.lang.String".contentEquals(((TypeElement)((DeclaredType)compound).asElement()).getQualifiedName());
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject[] sourceRoots) {
        LinkedList<ElementHandle<TypeElement>> result = new LinkedList<ElementHandle<TypeElement>>();
        for (FileObject root : sourceRoots) {
            try {
                File rootFile = FileUtil.toFile((FileObject)root);
                ClassPath bootPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
                ClassPath compilePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
                ClassPath srcPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
                ClassPath systemModules = ClassPath.getClassPath((FileObject)root, (String)"modules/boot");
                ClassPath modulePath = ClassPath.getClassPath((FileObject)root, (String)"modules/compile");
                ClassPath allUnnamed = ClassPath.getClassPath((FileObject)root, (String)"modules/classpath");
                ClassPath moduleSourcePath = ClassPath.getClassPath((FileObject)root, (String)"modules/source");
                ClasspathInfo cpInfo = new ClasspathInfo.Builder(bootPath).setClassPath(compilePath).setSourcePath(srcPath).setModuleBootPath(systemModules).setModuleCompilePath(modulePath).setModuleClassPath(allUnnamed).setModuleSourcePath(moduleSourcePath).build();
                JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
                js.runUserActionTask(control -> {
                    control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    URL rootURL = root.toURL();
                    Iterable<? extends URL> mainClasses = ExecutableFilesIndex.DEFAULT.getMainClasses(rootURL);
                    LinkedList<? extends ElementHandle<TypeElement>> classes = new LinkedList<ElementHandle<TypeElement>>();
                    for (URL uRL : mainClasses) {
                        File mainFo = BaseUtilities.toFile((URI)URI.create(uRL.toExternalForm()));
                        if (!mainFo.exists()) continue;
                        classes.addAll(JavaCustomIndexer.getRelatedTypes(mainFo, rootFile));
                    }
                    block1: for (ElementHandle elementHandle : classes) {
                        TypeElement te = (TypeElement)elementHandle.resolve((CompilationInfo)control);
                        if (te == null) continue;
                        java.util.List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                        for (ExecutableElement method : methods) {
                            if (!SourceUtils.isMainMethod(method)) continue;
                            if (!SourceUtils.isIncluded(elementHandle, control.getClasspathInfo())) continue block1;
                            result.add(elementHandle);
                            continue block1;
                        }
                    }
                }, false);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return Collections.emptySet();
            }
        }
        return result;
    }

    private static boolean isIncluded(ElementHandle<TypeElement> element, ClasspathInfo cpInfo) {
        FileObject fobj = SourceUtils.getFile(element, cpInfo);
        if (fobj == null) {
            return true;
        }
        ClassPath sourcePath = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        for (ClassPath.Entry e : sourcePath.entries()) {
            FileObject root = e.getRoot();
            if (root == null || !FileUtil.isParentOf((FileObject)root, (FileObject)fobj)) continue;
            return e.includes(fobj);
        }
        return true;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static java.util.List<String> getSourceFileNames(String classFileName) {
        int index = classFileName.lastIndexOf(36);
        if (index == -1) {
            return Collections.singletonList(classFileName);
        }
        ArrayList<String> ll = new ArrayList<String>(3);
        ll.add(classFileName);
        while (index >= 0) {
            ll.add(classFileName.substring(0, index));
            index = classFileName.lastIndexOf(36, index - 1);
        }
        return ll;
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type = SourceUtils.resolveCapturedTypeInt(info, tm);
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            TypeMirror typeMirror = tmirr = tmirr != null ? tmirr : ((WildcardType)type).getSuperBound();
            if (tmirr != null) {
                return tmirr;
            }
            TypeElement tel = info.getElements().getTypeElement("java.lang.Object");
            return tel == null ? null : tel.asType();
        }
        return type;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        TypeMirror extendsBound;
        TypeMirror rct;
        if (tm == null) {
            return tm;
        }
        WildcardType orig = SourceUtils.resolveCapturedType(tm);
        if (orig != null) {
            tm = orig;
        }
        if (tm.getKind() == TypeKind.WILDCARD && (rct = SourceUtils.resolveCapturedTypeInt(info, (extendsBound = ((WildcardType)tm).getExtendsBound()) != null ? extendsBound : ((WildcardType)tm).getSuperBound())) != null) {
            return rct.getKind() == TypeKind.WILDCARD ? rct : info.getTypes().getWildcardType(extendsBound != null ? rct : null, extendsBound == null ? rct : null);
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)tm;
            TypeElement el = (TypeElement)dt.asElement();
            if (((DeclaredType)el.asType()).getTypeArguments().size() != dt.getTypeArguments().size()) {
                return info.getTypes().getDeclaredType(el, new TypeMirror[0]);
            }
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                typeArguments.add(SourceUtils.resolveCapturedTypeInt(info, typeMirror));
            }
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, el, typeArguments.toArray(new TypeMirror[0]));
            }
            return info.getTypes().getDeclaredType(el, typeArguments.toArray(new TypeMirror[0]));
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)tm;
            TypeMirror componentType = SourceUtils.resolveCapturedTypeInt(info, at.getComponentType());
            switch (componentType.getKind()) {
                case VOID: 
                case EXECUTABLE: 
                case WILDCARD: 
                case PACKAGE: {
                    break;
                }
                default: {
                    return info.getTypes().getArrayType(componentType);
                }
            }
        }
        return tm;
    }

    public static WildcardType resolveCapturedType(TypeMirror type) {
        if (type instanceof Type.CapturedType) {
            return ((Type.CapturedType)type).wildcard;
        }
        return null;
    }

    public static Collection<? extends Element> getForwardReferences(TreePath path, int pos, SourcePositions sourcePositions, Trees trees) {
        HashSet<Element> refs = new HashSet<Element>();
        while (path != null) {
            switch (path.getLeaf().getKind()) {
                case VARIABLE: {
                    TreePath parent;
                    Element el = trees.getElement(path);
                    if (el != null) {
                        refs.add(el);
                    }
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)(parent = path.getParentPath()).getLeaf().getKind())) break;
                    boolean isStatic = ((VariableTree)path.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                    for (Tree tree : ((ClassTree)parent.getLeaf()).getMembers()) {
                        if (tree.getKind() != Tree.Kind.VARIABLE || sourcePositions.getStartPosition(path.getCompilationUnit(), tree) < (long)pos || !isStatic && ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC) || (el = trees.getElement(new TreePath(parent, tree))) == null) continue;
                        refs.add(el);
                    }
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    Element el;
                    EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
                    if (sourcePositions.getEndPosition(path.getCompilationUnit(), efl.getExpression()) < (long)pos || (el = trees.getElement(new TreePath(path, efl.getVariable()))) == null) break;
                    refs.add(el);
                }
            }
            path = path.getParentPath();
        }
        return refs;
    }

    public static Set<String> getModuleNames(CompilationInfo info, @NonNull Set<? extends ClassIndex.SearchScopeType> scope) {
        HashSet<String> ret = new HashSet<String>();
        JavaFileManager jfm = info.impl.getJavacTask().getContext().get(JavaFileManager.class);
        if (jfm != null) {
            ArrayList<StandardLocation> toSearch = new ArrayList<StandardLocation>();
            for (ClassIndex.SearchScopeType searchScopeType : scope) {
                if (searchScopeType.isSources()) {
                    toSearch.add(StandardLocation.MODULE_SOURCE_PATH);
                }
                if (!searchScopeType.isDependencies()) continue;
                toSearch.add(StandardLocation.MODULE_PATH);
                toSearch.add(StandardLocation.UPGRADE_MODULE_PATH);
                toSearch.add(StandardLocation.SYSTEM_MODULES);
            }
            try {
                for (JavaFileManager.Location location : toSearch) {
                    for (Set<JavaFileManager.Location> locations : jfm.listLocationsForModules(location)) {
                        for (JavaFileManager.Location location2 : locations) {
                            ret.add(jfm.inferModuleName(location2));
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    @CheckForNull
    public static String getModuleName(@NonNull URL rootUrl) {
        return SourceUtils.getModuleName(rootUrl, false);
    }

    @CheckForNull
    public static String getModuleName(@NonNull URL rootUrl, @NonNull boolean canUseSources) {
        return ModuleNames.getInstance().getModuleName(rootUrl, canUseSources);
    }

    @CheckForNull
    public static String parseModuleName(@NonNull FileObject moduleInfo) {
        return ModuleNames.parseModuleName(moduleInfo);
    }

    private static ClassPath createClassPath(ClasspathInfo cpInfo, ClasspathInfo.PathKind kind) throws MalformedURLException {
        return ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(cpInfo, kind);
    }

    @NonNull
    private static Set<URL> mapToURLs(@NonNull Collection<? extends FileObject> fos) {
        HashSet<URL> res = new HashSet<URL>(fos.size());
        for (FileObject fileObject : fos) {
            res.add(fileObject.toURL());
        }
        return res;
    }

    private static boolean isPkgOrMdl(@NonNull ElementKind kind) {
        return kind == ElementKind.PACKAGE || kind == ElementKind.MODULE;
    }

    public static Object getDiagnosticParam(Diagnostic<?> d, int index) {
        return Hacks.getDiagnosticParam(d, index);
    }

    public static void forceSource(CompilationController cc, FileObject file) {
        if (cc.getPhase() != JavaSource.Phase.MODIFIED) {
            throw new IllegalStateException("Must invoke before running toPhase!");
        }
        cc.addForceSource(file);
    }

    private static class CaseInsensitiveMatch
    extends Match {
        CaseInsensitiveMatch(String name) {
            super(name);
        }

        @Override
        protected boolean match(String name1, String name2) {
            return name1.equalsIgnoreCase(name2);
        }
    }

    private static class CaseSensitiveMatch
    extends Match {
        CaseSensitiveMatch(String name) {
            super(name);
        }

        @Override
        protected boolean match(String name1, String name2) {
            return name1.equals(name2);
        }
    }

    private static abstract class Match {
        private final String name;

        Match(String names) {
            this.name = names;
        }

        final boolean apply(FileObject fo) {
            if (fo.getNameExt().equals(this.name)) {
                return true;
            }
            String foName = fo.getName();
            return this.match(foName, this.name) && this.isJava(fo);
        }

        protected abstract boolean match(String var1, String var2);

        private boolean isJava(FileObject fo) {
            return "java".equalsIgnoreCase(fo.getExt()) && fo.isData();
        }
    }
}

