/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.FacadeManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.facade.HttpServletRequestFacade;
import org.apache.tomcat.facade.HttpServletResponseFacade;
import org.apache.tomcat.facade.ServletConfigImpl;
import org.apache.tomcat.facade.ServletContextFacade;

public final class SimpleFacadeManager
implements FacadeManager {
    Context ctx;

    private SimpleFacadeManager() {
    }

    public SimpleFacadeManager(Context ctx) {
        this.ctx = ctx;
    }

    public ServletContext createServletContextFacade(Context ctx) {
        return new ServletContextFacade(ctx.getContextManager(), ctx);
    }

    public HttpServletRequest createHttpServletRequestFacade(Request req) {
        Context reqCtx = req.getContext();
        return new HttpServletRequestFacade(req);
    }

    public HttpServletResponse createHttpServletResponseFacade(Response res) {
        Context resCtx = res.getRequest().getContext();
        return new HttpServletResponseFacade(res);
    }

    public void recycle(Request rreq) {
        HttpServletRequest req = rreq.getFacade();
        if (!(req instanceof HttpServletRequestFacade)) {
            return;
        }
        ((HttpServletRequestFacade)req).recycle();
        Response rres = rreq.getResponse();
        if (rres == null) {
            return;
        }
        HttpServletResponse res = rres.getFacade();
        if (res != null) {
            ((HttpServletResponseFacade)res).recycle();
        }
    }

    public Request getRealRequest(HttpServletRequest req) {
        Request rreq = ((HttpServletRequestFacade)req).getRealRequest();
        if (rreq == null) {
            System.out.println("XXX XXX null req " + this.ctx + " " + req);
        }
        if (rreq.getContext() == null) {
            return rreq;
        }
        return rreq;
    }

    public Context getRealContext(ServletContext sctx) {
        Context realSctx = ((ServletContextFacade)sctx).getRealContext();
        return realSctx;
    }

    public ServletConfig createServletConfig(ServletWrapper sw) {
        return new ServletConfigImpl(sw);
    }
}

