/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.tomcat.context.DefaultCMSetter;
import org.apache.tomcat.context.LoadOnStartupInterceptor;
import org.apache.tomcat.context.LoaderInterceptor;
import org.apache.tomcat.context.PolicyInterceptor;
import org.apache.tomcat.context.WebXmlReader;
import org.apache.tomcat.context.WorkDirInterceptor;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.FacadeManager;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.net.SSLSocketFactory;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.request.AccessInterceptor;
import org.apache.tomcat.request.InvokerInterceptor;
import org.apache.tomcat.request.Jdk12Interceptor;
import org.apache.tomcat.request.SessionInterceptor;
import org.apache.tomcat.request.SimpleMapper1;
import org.apache.tomcat.request.StaticInterceptor;
import org.apache.tomcat.service.PoolTcpConnector;
import org.apache.tomcat.service.http.HttpConnectionHandler;
import org.apache.tomcat.session.StandardSessionInterceptor;

public class EmbededTomcat {
    ContextManager contextM = null;
    Object application;
    Vector requestInt = null;
    Vector contextInt = null;
    FacadeManager facadeM = null;
    Vector connectors = new Vector();
    String workDir;
    int debug = 0;
    Hashtable extraClassPaths = new Hashtable();

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void addApplicationAdapter(Object adapter) {
        if (this.requestInt == null) {
            this.initDefaultInterceptors();
        }
        if (adapter instanceof RequestInterceptor) {
            this.addRequestInterceptor((RequestInterceptor)adapter);
        }
    }

    public void setApplication(Object app) {
        this.application = app;
    }

    public Object getApplication() {
        return this.application;
    }

    public void setWorkDir(String dir) {
        this.workDir = dir;
    }

    public void addEndpoint(int port, InetAddress addr, String hostname) {
        if (this.debug > 0) {
            this.log("addConnector " + port + " " + addr + " " + hostname);
        }
        PoolTcpConnector sc = new PoolTcpConnector();
        sc.setServer(this.contextM);
        sc.setDebug(this.debug);
        sc.setAttribute("vhost_port", new Integer(port));
        if (addr != null) {
            sc.setAttribute("vhost_address", addr);
        }
        if (hostname != null) {
            sc.setAttribute("vhost_name", hostname);
        }
        sc.setTcpConnectionHandler(new HttpConnectionHandler());
        this.contextM.addServerConnector(sc);
    }

    public void addSecureEndpoint(int port, InetAddress addr, String hostname, String keyFile, String keyPass) {
        this.addSecureEndpoint(port, addr, hostname, keyFile, keyPass, false);
    }

    public void addSecureEndpoint(int port, InetAddress addr, String hostname, String keyStore, String keyPass, boolean clientAuth) {
        if (this.debug > 0) {
            this.log("addSecureConnector " + port + " " + addr + " " + hostname);
        }
        PoolTcpConnector sc = new PoolTcpConnector();
        sc.setServer(this.contextM);
        this.contextM.setSecurePort(port);
        sc.setAttribute("vhost_port", new Integer(port));
        if (addr != null) {
            sc.setAttribute("vhost_address", addr);
        }
        if (hostname != null) {
            sc.setAttribute("vhost_name", hostname);
        }
        if (keyStore != null) {
            sc.setAttribute("keystore", keyStore);
        }
        if (keyPass != null) {
            sc.setAttribute("keypass", keyPass);
        }
        if (clientAuth) {
            sc.setAttribute("clientAuth", "true");
        }
        sc.setSocketFactory(new SSLSocketFactory());
        HttpConnectionHandler ch = new HttpConnectionHandler();
        ch.setSecure(true);
        sc.setTcpConnectionHandler(ch);
        this.contextM.addServerConnector(sc);
    }

    public void addCustomEndpoint(int port, InetAddress addr, String hostname, boolean secure, ServerSocketFactory socketFactory) {
        if (this.debug > 0) {
            this.log("addCustomEndpoint " + port + " " + addr + " " + hostname);
        }
        PoolTcpConnector sc = new PoolTcpConnector();
        sc.setServer(this.contextM);
        if (secure) {
            this.contextM.setSecurePort(port);
        }
        sc.setAttribute("vhost_port", new Integer(port));
        if (addr != null) {
            sc.setAttribute("vhost_address", addr);
        }
        if (hostname != null) {
            sc.setAttribute("vhost_name", hostname);
        }
        sc.setSocketFactory(socketFactory);
        HttpConnectionHandler ch = new HttpConnectionHandler();
        ch.setSecure(secure);
        sc.setTcpConnectionHandler(ch);
        this.contextM.addServerConnector(sc);
    }

    public ServletContext addContext(String ctxPath, URL docRoot) {
        if (this.debug > 0) {
            this.log("add context \"" + ctxPath + "\" " + docRoot);
        }
        if (this.contextM == null) {
            this.initContextManager();
        }
        if (!"file".equals(docRoot.getProtocol())) {
            this.log("addContext() invalid docRoot: " + docRoot);
            throw new RuntimeException("Invalid docRoot " + docRoot);
        }
        try {
            Context ctx = new Context();
            ctx.setDebug(this.debug);
            ctx.setContextManager(this.contextM);
            ctx.setPath(ctxPath);
            ctx.setDocBase(docRoot.getFile());
            this.contextM.addContext(ctx);
            if (this.facadeM == null) {
                this.facadeM = ctx.getFacadeManager();
            }
            return ctx.getFacade();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void removeContext(ServletContext sctx) {
        if (this.debug > 0) {
            this.log("remove context " + sctx);
        }
        try {
            if (this.facadeM == null) {
                System.out.println("XXX ERROR: no facade manager");
                return;
            }
            Context ctx = this.facadeM.getRealContext(sctx);
            this.contextM.removeContext(ctx);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addClassPath(ServletContext context, String cpath) {
        if (this.debug > 0) {
            this.log("addClassPath " + context.getRealPath("") + " " + cpath);
        }
        try {
            Vector<String> cp = (Vector<String>)this.extraClassPaths.get(context);
            if (cp == null) {
                cp = new Vector<String>();
                this.extraClassPaths.put(context, cp);
            }
            cp.addElement(cpath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ServletContext getServletContext(String host, String cpath) {
        Context ctx = this.contextM.getContext(cpath);
        if (ctx == null) {
            return null;
        }
        return ctx.getFacade();
    }

    public void initContext(ServletContext sctx) {
        try {
            if (this.facadeM == null) {
                System.out.println("XXX ERROR: no facade manager");
                return;
            }
            Context ctx = this.facadeM.getRealContext(sctx);
            this.contextM.initContext(ctx);
            ServletLoader sl = ctx.getServletLoader();
            Object pd = ctx.getProtectionDomain();
            Vector cp = (Vector)this.extraClassPaths.get(sctx);
            if (cp != null) {
                int i = 0;
                while (i < cp.size()) {
                    String cpath = (String)cp.elementAt(i);
                    sl.addRepository(new File(cpath), pd);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void destroyContext(ServletContext ctx) {
    }

    public void start() {
        try {
            this.contextM.start();
        }
        catch (IOException ex) {
            System.out.println("Error starting endpoing " + ex.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.debug > 0) {
            this.log("Started");
        }
    }

    public void stop() {
    }

    public void addRequestInterceptor(RequestInterceptor ri) {
        if (this.requestInt == null) {
            this.requestInt = new Vector();
        }
        this.requestInt.addElement(ri);
        if (ri instanceof BaseInterceptor) {
            ((BaseInterceptor)ri).setDebug(this.debug);
        }
    }

    public void addContextInterceptor(ContextInterceptor ci) {
        if (this.contextInt == null) {
            this.contextInt = new Vector();
        }
        this.contextInt.addElement(ci);
        if (ci instanceof BaseInterceptor) {
            ((BaseInterceptor)ci).setDebug(this.debug);
        }
    }

    private void initContextManager() {
        if (this.requestInt == null) {
            this.initDefaultInterceptors();
        }
        this.contextM = new ContextManager();
        this.contextM.setDebug(this.debug);
        int i = 0;
        while (i < this.contextInt.size()) {
            this.contextM.addContextInterceptor((ContextInterceptor)this.contextInt.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.requestInt.size()) {
            this.contextM.addRequestInterceptor((RequestInterceptor)this.requestInt.elementAt(i2));
            ++i2;
        }
        this.contextM.setWorkDir(this.workDir);
        try {
            this.contextM.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.debug > 0) {
            this.log("ContextManager initialized");
        }
    }

    private void initDefaultInterceptors() {
        WebXmlReader webXmlI = new WebXmlReader();
        webXmlI.setValidate(false);
        this.addContextInterceptor(webXmlI);
        PolicyInterceptor polI = new PolicyInterceptor();
        this.addContextInterceptor(polI);
        polI.setDebug(0);
        LoaderInterceptor loadI = new LoaderInterceptor();
        this.addContextInterceptor(loadI);
        DefaultCMSetter defaultCMI = new DefaultCMSetter();
        this.addContextInterceptor(defaultCMI);
        WorkDirInterceptor wdI = new WorkDirInterceptor();
        this.addContextInterceptor(wdI);
        LoadOnStartupInterceptor loadOnSI = new LoadOnStartupInterceptor();
        this.addContextInterceptor(loadOnSI);
        SessionInterceptor sessI = new SessionInterceptor();
        this.addRequestInterceptor(sessI);
        SimpleMapper1 mapI = new SimpleMapper1();
        this.addRequestInterceptor(mapI);
        mapI.setDebug(0);
        InvokerInterceptor invI = new InvokerInterceptor();
        this.addRequestInterceptor(invI);
        invI.setDebug(0);
        StaticInterceptor staticI = new StaticInterceptor();
        this.addRequestInterceptor(staticI);
        mapI.setDebug(0);
        this.addRequestInterceptor(new StandardSessionInterceptor());
        AccessInterceptor accessI = new AccessInterceptor();
        this.addRequestInterceptor(accessI);
        accessI.setDebug(0);
        Jdk12Interceptor jdk12I = new Jdk12Interceptor();
        this.addRequestInterceptor(jdk12I);
    }

    private void log(String s) {
        System.out.println("WebAdapter: " + s);
    }

    public static void main(String[] args) {
        try {
            EmbededTomcat tc = new EmbededTomcat();
            tc.setWorkDir("/home/costin/src/jakarta/build/tomcat/work");
            ServletContext sctx = tc.addContext("", new URL("file:/home/costin/src/jakarta/build/tomcat/webapps/ROOT"));
            tc.initContext(sctx);
            sctx = tc.addContext("/examples", new URL("file:/home/costin/src/jakarta/build/tomcat/webapps/examples"));
            tc.initContext(sctx);
            tc.addEndpoint(8080, null, null);
            tc.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

