/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateOrResetUIPasswordRequest
extends BmcRequest<Void> {
    private String userId;
    private String opcRetryToken;

    @ConstructorProperties(value={"userId", "opcRetryToken"})
    CreateOrResetUIPasswordRequest(String userId, String opcRetryToken) {
        this.userId = userId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).opcRetryToken(this.opcRetryToken);
    }

    public String toString() {
        return "CreateOrResetUIPasswordRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", opcRetryToken=" + this.getOpcRetryToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOrResetUIPasswordRequest)) {
            return false;
        }
        CreateOrResetUIPasswordRequest other = (CreateOrResetUIPasswordRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        return !(this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateOrResetUIPasswordRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOrResetUIPasswordRequest, Void> {
        private String userId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOrResetUIPasswordRequest o) {
            this.userId(o.getUserId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOrResetUIPasswordRequest build() {
            CreateOrResetUIPasswordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateOrResetUIPasswordRequest buildWithoutInvocationCallback() {
            return new CreateOrResetUIPasswordRequest(this.userId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateOrResetUIPasswordRequest.Builder(userId=" + this.userId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

