/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";

    private ToolProvider() {
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return (JavaCompiler)JavaCompiler.class.cast(((Supplier<Object>)() -> {
            try {
                JavaCompiler v;
                try {
                    v = ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
                }
                catch (Error err) {
                    v = null;
                }
                if (v == null) {
                    v = Class.forName(systemJavaCompilerName).newInstance();
                }
                return JavaCompiler.class.cast(v);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }).get());
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return (DocumentationTool)DocumentationTool.class.cast(((Supplier<Object>)() -> {
            try {
                DocumentationTool v;
                try {
                    v = ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
                }
                catch (Error err) {
                    v = null;
                }
                if (v == null) {
                    v = Class.forName(systemDocumentationToolName).newInstance();
                }
                return DocumentationTool.class.cast(v);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }).get());
    }

    @Deprecated
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String moduleName, String className) {
        try {
            ServiceLoader sl = ServiceLoaderWrapper.loadTool(clazz);
            for (Object tool : sl) {
                if (!ToolProvider.matches(tool, moduleName)) continue;
                return (T)tool;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new Error(e);
        }
        return null;
    }

    private static <T> boolean matches(T tool, String moduleName) {
        PrivilegedAction<Boolean> pa = () -> {
            ModuleWrapper toolModule = ModuleWrapper.getModule(tool.getClass());
            String toolModuleName = toolModule.getName();
            return Objects.equals(toolModuleName, moduleName);
        };
        return AccessController.doPrivileged(pa);
    }
}

