/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cordova.CordovaPerformer;
import org.netbeans.modules.cordova.CordovaPlatform;
import org.netbeans.modules.cordova.project.Bundle;
import org.netbeans.modules.cordova.project.CordovaNotFound;
import org.netbeans.modules.cordova.project.CordovaPanel;
import org.netbeans.modules.cordova.project.PluginsPanel;
import org.netbeans.modules.cordova.updatetask.CordovaPlugin;
import org.netbeans.modules.cordova.updatetask.SourceConfig;
import org.netbeans.modules.cordova.wizard.CordovaProjectExtender;
import org.netbeans.modules.cordova.wizard.CordovaTemplate;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CordovaCustomizerPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private Project project;
    private SourceConfig config;
    private final ProjectCustomizer.Category cat;
    private boolean cordovaReady;
    private CordovaPanel cordovaPanel;
    private JButton createConfigs;
    private JLabel createConfigsLabel;
    private JPanel generatePanel;
    private JTabbedPane jTabbedPane1;
    private JButton mobilePlatformsSetup;
    private PluginsPanel pluginsPanel1;

    public CordovaCustomizerPanel(Project p, final ProjectCustomizer.Category cat) {
        this.project = p;
        this.cat = cat;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(Bundle.LBL_InitializeCordovaPanel(), 0), "Center");
        this.validate();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                CordovaCustomizerPanel.this.cordovaReady = CordovaPlatform.getDefault().isReady();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CordovaCustomizerPanel.this.initialize(cat);
                    }
                });
            }
        });
    }

    private void createMobileConfigs() {
        try {
            CordovaProjectExtender.createMobileConfigs(this.project.getProjectDirectory());
            CordovaPerformer.getDefault().createPlatforms(this.project).waitFinished();
            this.config = CordovaPerformer.getConfig(this.project);
            this.setVisibility();
            CordovaTemplate.CordovaExtender.setPhoneGapBrowser(this.project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.generatePanel = new JPanel();
        this.createConfigs = new JButton();
        this.createConfigsLabel = new JLabel();
        this.mobilePlatformsSetup = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.cordovaPanel = new CordovaPanel();
        this.pluginsPanel1 = new PluginsPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.createConfigs, (String)NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaPanel.createConfigs.text"));
        this.createConfigs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CordovaCustomizerPanel.this.createConfigsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.createConfigsLabel, (String)NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaCustomizerPanel.createConfigsLabel.text"));
        GroupLayout generatePanelLayout = new GroupLayout(this.generatePanel);
        this.generatePanel.setLayout(generatePanelLayout);
        generatePanelLayout.setHorizontalGroup(generatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generatePanelLayout.createSequentialGroup().addComponent(this.createConfigs).addContainerGap(-1, Short.MAX_VALUE)).addGroup(generatePanelLayout.createSequentialGroup().addComponent(this.createConfigsLabel).addGap(0, 0, Short.MAX_VALUE)));
        generatePanelLayout.setVerticalGroup(generatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generatePanelLayout.createSequentialGroup().addComponent(this.createConfigsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createConfigs).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.mobilePlatformsSetup, (String)NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaCustomizerPanel.mobilePlatformsSetup.text"));
        this.mobilePlatformsSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CordovaCustomizerPanel.this.mobilePlatformsSetupActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addTab(NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaCustomizerPanel.cordovaPanel.TabConstraints.tabTitle"), this.cordovaPanel);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaCustomizerPanel.pluginsPanel1.TabConstraints.tabTitle"), this.pluginsPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.mobilePlatformsSetup)).addComponent(this.generatePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 516, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.generatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 209, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mobilePlatformsSetup)));
    }

    private void createConfigsActionPerformed(ActionEvent evt) {
        this.createConfigs.setVisible(false);
        this.createConfigsLabel.setVisible(false);
        this.mobilePlatformsSetup.setVisible(true);
        this.jTabbedPane1.setVisible(true);
        ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                CordovaCustomizerPanel.this.createMobileConfigs();
            }
        }, (String)NbBundle.getMessage(CordovaCustomizerPanel.class, (String)"CordovaPanel.createConfigsProgress.text"));
        this.validate();
    }

    private void mobilePlatformsSetupActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/MobilePlatforms");
    }

    private void initControls() {
        this.initComponents();
        this.cordovaPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CordovaCustomizerPanel.this.checkIdValid(CordovaCustomizerPanel.this.cordovaPanel.getPackageName());
            }
        });
        try {
            this.pluginsPanel1.init(this.getCurrent(), this.getAll());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setVisibility();
    }

    private List<CordovaPlugin> getCurrent() throws IOException {
        ArrayList<CordovaPlugin> requestedPlugins = new ArrayList<CordovaPlugin>();
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/plugins.properties");
        if (fileObject == null) {
            return new ArrayList<CordovaPlugin>();
        }
        Properties props = new Properties();
        try (InputStream inputStream = fileObject.getInputStream();){
            props.load(inputStream);
        }
        for (String name : props.stringPropertyNames()) {
            requestedPlugins.add(new CordovaPlugin(name, props.getProperty(name)));
        }
        return requestedPlugins;
    }

    private List<CordovaPlugin> getAll() throws IOException {
        ArrayList<CordovaPlugin> requestedPlugins = new ArrayList<CordovaPlugin>();
        Properties props = new Properties();
        props.load(CordovaPerformer.class.getResourceAsStream("plugins.properties"));
        for (String name : props.stringPropertyNames()) {
            requestedPlugins.add(new CordovaPlugin(name, props.getProperty(name)));
        }
        return requestedPlugins;
    }

    private void checkIdValid(String packageName) {
        if (SourceConfig.isValidId((String)packageName)) {
            this.cat.setValid(true);
            this.cat.setErrorMessage("");
        } else {
            this.cat.setValid(false);
            this.cat.setErrorMessage(Bundle.ERR_InvalidAppId(packageName));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.cordovaPanel == null) {
                return;
            }
            if (!CordovaPlatform.isCordovaProject(this.project)) {
                return;
            }
            Preferences preferences = ProjectUtils.getPreferences((Project)this.project, CordovaPlatform.class, (boolean)true);
            preferences.put("phonegap", Boolean.toString(this.cordovaPanel.isPanelEnabled()));
            List<CordovaPlugin> selected = this.pluginsPanel1.getSelectedPlugins();
            EditableProperties props = new EditableProperties(false);
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/plugins.properties");
            if (fileObject == null) {
                CordovaPerformer.createScript(this.project, "empty.properties", "nbproject/plugins.properties", false);
                fileObject = this.project.getProjectDirectory().getFileObject("nbproject/plugins.properties");
            }
            try (InputStream inputStream = fileObject.getInputStream();){
                props.load(inputStream);
            }
            HashSet<CordovaPlugin> pluginsToAdd = new HashSet<CordovaPlugin>();
            pluginsToAdd.addAll(selected);
            pluginsToAdd.removeAll(this.getCurrent());
            HashSet<CordovaPlugin> pluginsToRemove = new HashSet<CordovaPlugin>();
            pluginsToRemove.addAll(this.getCurrent());
            pluginsToRemove.removeAll(selected);
            for (CordovaPlugin plugin : pluginsToAdd) {
                props.put(plugin.getId(), plugin.getUrl());
            }
            for (CordovaPlugin plugin : pluginsToRemove) {
                props.remove((Object)plugin.getId());
            }
            try (OutputStream outputStream = fileObject.getOutputStream();){
                props.store(outputStream);
            }
            try {
                this.cordovaPanel.save(this.config);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setVisibility() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                boolean platformsReady = CordovaPlatform.getDefault().isReady();
                boolean isCordovaProject = CordovaPlatform.isCordovaProject(CordovaCustomizerPanel.this.project);
                CordovaCustomizerPanel.this.createConfigs.setVisible(!isCordovaProject && platformsReady);
                CordovaCustomizerPanel.this.createConfigsLabel.setVisible(!isCordovaProject && platformsReady);
                CordovaCustomizerPanel.this.jTabbedPane1.setVisible(isCordovaProject && platformsReady);
                CordovaCustomizerPanel.this.mobilePlatformsSetup.setVisible(isCordovaProject && platformsReady);
                CordovaCustomizerPanel.this.cordovaPanel.update();
                if (CordovaCustomizerPanel.this.config != null) {
                    CordovaCustomizerPanel.this.cordovaPanel.load(CordovaCustomizerPanel.this.config);
                }
                CordovaCustomizerPanel.this.validate();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.cordova.project.CordovaCustomizerPanel");
    }

    public void initialize(ProjectCustomizer.Category cat) {
        this.removeAll();
        if (!this.cordovaReady) {
            this.setLayout(new BorderLayout());
            this.add((Component)new CordovaNotFound(), "Center");
            this.validate();
            CordovaPlatform.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (CordovaCustomizerPanel.this.cordovaReady) {
                        if (CordovaPlatform.isCordovaProject(CordovaCustomizerPanel.this.project)) {
                            CordovaCustomizerPanel.this.config = CordovaPerformer.getConfig(CordovaCustomizerPanel.this.project);
                        }
                        CordovaCustomizerPanel.this.removeAll();
                        CordovaCustomizerPanel.this.initControls();
                    }
                }
            });
        } else {
            if (CordovaPlatform.isCordovaProject(this.project) && this.cordovaReady) {
                this.config = CordovaPerformer.getConfig(this.project);
            }
            this.initControls();
        }
        cat.setStoreListener((ActionListener)this);
    }
}

