/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYSelectionOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.ColorFactory;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;

public final class SurvivingGenerationsGraphPanel
extends GraphPanel {
    private final Color GENERATIONS_COLOR = ColorFactory.getPredefinedColor(0);
    private final Color GC_INTERVALS_COLOR = ColorFactory.getPredefinedColor(1);
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final DataManagerListener listener;
    private final boolean smallPanel;

    public static SurvivingGenerationsGraphPanel createBigPanel(VMTelemetryModels models) {
        return new SurvivingGenerationsGraphPanel(models, false, null);
    }

    public static SurvivingGenerationsGraphPanel createSmallPanel(VMTelemetryModels models, Action chartAction) {
        return new SurvivingGenerationsGraphPanel(models, true, chartAction);
    }

    private SurvivingGenerationsGraphPanel(VMTelemetryModels models, boolean smallPanel, Action chartAction) {
        this.models = models;
        this.smallPanel = smallPanel;
        this.initComponents(chartAction);
        this.listener = new DataManagerListener(){

            public void dataChanged() {
                SurvivingGenerationsGraphPanel.this.updateData();
            }

            public void dataReset() {
                SurvivingGenerationsGraphPanel.this.resetData();
            }
        };
        models.getDataManager().addDataListener(this.listener);
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    @Override
    public void cleanup() {
        this.models.getDataManager().removeDataListener(this.listener);
    }

    private void updateData() {
        VMTelemetryDataManager manager;
        long[] timestamps;
        if (this.smallPanel && this.chart.fitsWidth() && (timestamps = manager.timeStamps)[(manager = this.models.getDataManager()).getItemCount() - 1] - timestamps[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 11L));
    }

    private void initComponents(Action chartAction) {
        PaintersModel paintersModel = this.createGenerationsPaintersModel();
        this.chart = this.createChart(this.models.generationsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.generationsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 1, 2);
        hAxis.setForeground(Color.GRAY);
        SynchronousXYItem survgenItem = this.models.generationsItemsModel().getItem(1);
        XYItemPainter survgenPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)survgenItem);
        SimpleLongMarksPainter survgenMarksPainter = new SimpleLongMarksPainter();
        AxisComponent sAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)survgenItem, survgenPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)survgenMarksPainter, 7, 2);
        sAxis.setForeground(Color.GRAY);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 5, 5, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{1, 2, 8});
        chartPanel.add((Component)sAxis, new Integer[]{7, 6});
        JScrollBar scroller = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(scroller);
        chartPanel.add((Component)scroller, new Integer[]{5});
        if (!this.smallPanel) {
            ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(this.createTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
            this.chart.getSelectionModel().setHoverMode(102);
            ProfilerXYSelectionOverlay selectionOverlay = new ProfilerXYSelectionOverlay();
            this.chart.addOverlayComponent(selectionOverlay);
            selectionOverlay.registerChart((ChartComponent)this.chart);
            this.chart.getSelectionModel().setMoveMode(1);
            JPanel chartContainer = new JPanel(new BorderLayout());
            chartContainer.setBorder(BorderFactory.createEmptyBorder());
            chartContainer.add((Component)chartPanel, "Center");
            JPanel sidePanel = new JPanel(new BorderLayout());
            sidePanel.setOpaque(false);
            int h = new JLabel((String)"XXX").getPreferredSize().height;
            sidePanel.setBorder(BorderFactory.createEmptyBorder(h + 17, 0, 0, 10));
            InvisibleToolbar toolbar = new InvisibleToolbar(1);
            toolbar.setOpaque(true);
            toolbar.setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.toggleViewAction()).setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.zoomInAction()).setBackground(UIUtils.getProfilerResultsBackground());
            toolbar.add(this.chart.zoomOutAction()).setBackground(UIUtils.getProfilerResultsBackground());
            sidePanel.add((Component)toolbar, "Center");
            JLabel heapSizeBig = new JLabel(GraphsUI.SURVGEN_NAME, new ColorIcon(this.GENERATIONS_COLOR, Color.BLACK, 18, 9), 10);
            heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel usedHeapBig = new JLabel(GraphsUI.GC_INTERVALS_NAME, new ColorIcon(this.GC_INTERVALS_COLOR, Color.BLACK, 18, 9), 10);
            usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 7, 0));
            bigLegendPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 30));
            bigLegendPanel.setOpaque(true);
            bigLegendPanel.setBackground(UIUtils.getProfilerResultsBackground());
            bigLegendPanel.add(heapSizeBig);
            bigLegendPanel.add(usedHeapBig);
            this.setLayout(new BorderLayout());
            this.setBackground(UIUtils.getProfilerResultsBackground());
            JLabel caption = new JLabel(GraphsUI.GC_CAPTION, 0);
            caption.setFont(caption.getFont().deriveFont(1));
            caption.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
            caption.setOpaque(true);
            caption.setBackground(UIUtils.getProfilerResultsBackground());
            this.add((Component)caption, "North");
            this.add((Component)chartContainer, "Center");
            this.add((Component)bigLegendPanel, "South");
            this.add((Component)sidePanel, "East");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 1;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.SURVGEN_NAME;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.SURVGEN_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.GC_TIME_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                switch (index) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(itemValue);
                    }
                    case 1: {
                        String val = GraphPanel.PERCENT_FORMATTER.format((float)itemValue / 1000.0f);
                        return this.trimPercents(val);
                    }
                }
                return null;
            }

            @Override
            public String getRowUnits(int index) {
                switch (index) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "%";
                    }
                }
                return null;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return SurvivingGenerationsGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = SurvivingGenerationsGraphPanel.this.models.generationsItemsModel().getItem(index + 1);
                switch (index) {
                    case 0: {
                        return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
                    }
                    case 1: {
                        String val = GraphPanel.PERCENT_FORMATTER.format((float)item.getMaxYValue() / 1000.0f);
                        return this.trimPercents(val);
                    }
                }
                return null;
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index);
            }

            private String trimPercents(String percents) {
                return !percents.endsWith("%") ? percents : percents.substring(0, percents.length() - 1).trim();
            }
        };
    }

    private PaintersModel createGenerationsPaintersModel() {
        ProfilerXYItemPainter survgenPainter;
        ProfilerXYItemPainter sgp = survgenPainter = ProfilerXYItemPainter.absolutePainter(2.0f, this.GENERATIONS_COLOR, null);
        ProfilerGCXYItemPainter gep = ProfilerGCXYItemPainter.painter(this.GC_INTERVALS_COLOR);
        SynchronousXYItemsModel items = this.models.generationsItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1)}, (ItemPainter[])new XYItemPainter[]{gep, sgp});
        return model;
    }
}

