/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.netbeans.jemmy.JemmyException;

public class ImageTool {
    public static BufferedImage getImage(Rectangle rect) {
        try {
            return new Robot().createScreenCapture(rect);
        }
        catch (AWTException e) {
            throw new JemmyException("Exception during screen capturing", e);
        }
    }

    public static BufferedImage getImage(Component comp) {
        return ImageTool.getImage(new Rectangle(comp.getLocationOnScreen(), comp.getSize()));
    }

    public static BufferedImage getImage() {
        return ImageTool.getImage(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    public static BufferedImage enlargeImage(BufferedImage image, int zoom) {
        int wight = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(wight * zoom, height * zoom, image.getType());
        for (int x = 0; x < wight; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = image.getRGB(x, y);
                for (int i = 0; i < zoom; ++i) {
                    for (int j = 0; j < zoom; ++j) {
                        result.setRGB(x * zoom + i, y * zoom + j, rgb);
                    }
                }
            }
        }
        return result;
    }

    public static BufferedImage substractImage(BufferedImage minuend, BufferedImage deduction) {
        return ImageTool.subtractImage(minuend, deduction);
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction) {
        return ImageTool.subtractImage(minuend, deduction, 0, 0);
    }

    public static BufferedImage substractImage(BufferedImage minuend, BufferedImage deduction, int relativeX, int relativeY) {
        return ImageTool.subtractImage(minuend, deduction, relativeX, relativeY);
    }

    public static BufferedImage subtractImage(BufferedImage minuend, BufferedImage deduction, int relativeX, int relativeY) {
        int mWidth = minuend.getWidth();
        int mHeight = minuend.getHeight();
        int dWidth = deduction.getWidth();
        int dHeight = deduction.getHeight();
        int maxWidth = mWidth > relativeX + dWidth ? mWidth : relativeX + dWidth;
        int maxHeight = mHeight > relativeY + dHeight ? mHeight : relativeY + dHeight;
        BufferedImage result = new BufferedImage(maxWidth, maxHeight, 1);
        for (int x = 0; x < maxWidth; ++x) {
            for (int y = 0; y < maxHeight; ++y) {
                int mColor = x >= mWidth || y >= mHeight ? 0 : minuend.getRGB(x, y);
                int dColor = x >= dWidth + relativeX || y >= dHeight + relativeY || x < relativeX || y < relativeY ? 0 : deduction.getRGB(x - relativeX, y - relativeY);
                result.setRGB(x, y, ImageTool.subtractColors(mColor, dColor));
            }
        }
        return result;
    }

    private static int subtractColors(int mRGB, int dRGB) {
        Color mColor = new Color(mRGB);
        Color dColor = new Color(dRGB);
        int red = ImageTool.subtractColor(mColor.getRed(), dColor.getRed());
        int green = ImageTool.subtractColor(mColor.getGreen(), dColor.getGreen());
        int blue = ImageTool.subtractColor(mColor.getBlue(), dColor.getBlue());
        return new Color(red, green, blue).getRGB();
    }

    private static int subtractColor(int mColor, int dColor) {
        if (mColor >= dColor) {
            return mColor - dColor;
        }
        return mColor - dColor + 255;
    }
}

