/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.backend.smo.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.search.MAVEN;
import org.apache.maven.search.Record;
import org.apache.maven.search.SearchRequest;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.SmoSearchResponse;
import org.apache.maven.search.backend.smo.SmoSearchTransport;
import org.apache.maven.search.backend.smo.internal.SmoSearchResponseImpl;
import org.apache.maven.search.request.BooleanQuery;
import org.apache.maven.search.request.Field;
import org.apache.maven.search.request.FieldQuery;
import org.apache.maven.search.request.Paging;
import org.apache.maven.search.request.Query;
import org.apache.maven.search.support.SearchBackendSupport;

public class SmoSearchBackendImpl
extends SearchBackendSupport
implements SmoSearchBackend {
    private static final Map<Field, String> FIELD_TRANSLATION;
    private final String smoUri;
    private final SmoSearchTransport transportSupport;
    private final Map<String, String> commonHeaders;
    private static final JsonPrimitive EC_SOURCE_JAR;
    private static final JsonPrimitive EC_JAVADOC_JAR;

    public SmoSearchBackendImpl(String backendId, String repositoryId, String smoUri, SmoSearchTransport transportSupport) {
        super(backendId, repositoryId);
        this.smoUri = Objects.requireNonNull(smoUri);
        this.transportSupport = Objects.requireNonNull(transportSupport);
        this.commonHeaders = new HashMap<String, String>();
        this.commonHeaders.put("User-Agent", "Apache-Maven-Search-SMO/" + this.discoverVersion() + " " + transportSupport.getClass().getSimpleName());
        this.commonHeaders.put("Accept", "application/json");
    }

    private String discoverVersion() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/search/backend/smo/internal/smo-version.properties");
        if (inputStream != null) {
            try (InputStream is = inputStream;){
                properties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties.getProperty("version", "unknown");
    }

    @Override
    public String getSmoUri() {
        return this.smoUri;
    }

    @Override
    public SmoSearchResponse search(SearchRequest searchRequest) throws IOException {
        String searchUri = this.toURI(searchRequest);
        String payload = this.transportSupport.fetch(searchUri, this.commonHeaders);
        JsonObject raw = JsonParser.parseString((String)payload).getAsJsonObject();
        ArrayList<Record> page = new ArrayList<Record>(searchRequest.getPaging().getPageSize());
        int totalHits = this.populateFromRaw(raw, page);
        return new SmoSearchResponseImpl(searchRequest, totalHits, page, searchUri, payload);
    }

    private String toURI(SearchRequest searchRequest) {
        Paging paging = searchRequest.getPaging();
        HashSet<Field> searchedFields = new HashSet<Field>();
        String smoQuery = this.toSMOQuery(searchedFields, searchRequest.getQuery());
        smoQuery = smoQuery + "&start=" + paging.getPageSize() * paging.getPageOffset();
        smoQuery = smoQuery + "&rows=" + paging.getPageSize();
        smoQuery = smoQuery + "&wt=json";
        if (searchedFields.contains(MAVEN.GROUP_ID) && searchedFields.contains(MAVEN.ARTIFACT_ID)) {
            smoQuery = smoQuery + "&core=gav";
        }
        return this.smoUri + "?q=" + smoQuery;
    }

    private String toSMOQuery(HashSet<Field> searchedFields, Query query) {
        if (query instanceof BooleanQuery.And) {
            BooleanQuery bq = (BooleanQuery)query;
            return this.toSMOQuery(searchedFields, bq.getLeft()) + "%20AND%20" + this.toSMOQuery(searchedFields, bq.getRight());
        }
        if (query instanceof FieldQuery) {
            FieldQuery fq = (FieldQuery)query;
            String smoFieldName = FIELD_TRANSLATION.get(fq.getField());
            if (smoFieldName != null) {
                searchedFields.add(fq.getField());
                return smoFieldName + ":" + this.encodeQueryParameterValue(fq.getValue());
            }
            throw new IllegalArgumentException("Unsupported SMO field: " + fq.getField());
        }
        return this.encodeQueryParameterValue(query.getValue());
    }

    private String encodeQueryParameterValue(String parameterValue) {
        try {
            return URLEncoder.encode(parameterValue, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int populateFromRaw(JsonObject raw, List<Record> page) {
        JsonObject response = raw.getAsJsonObject("response");
        Number numFound = response.get("numFound").getAsNumber();
        JsonArray docs = response.getAsJsonArray("docs");
        for (JsonElement doc : docs) {
            page.add(this.convert((JsonObject)doc));
        }
        return numFound.intValue();
    }

    private Record convert(JsonObject doc) {
        JsonArray ec;
        Number versionCount;
        HashMap<Field, Object> result = new HashMap<Field, Object>();
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.GROUP_ID, SmoSearchBackendImpl.mayGet("g", doc));
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.ARTIFACT_ID, SmoSearchBackendImpl.mayGet("a", doc));
        String version = SmoSearchBackendImpl.mayGet("v", doc);
        if (version == null) {
            version = SmoSearchBackendImpl.mayGet("latestVersion", doc);
        }
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.VERSION, version);
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.PACKAGING, SmoSearchBackendImpl.mayGet("p", doc));
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.CLASSIFIER, SmoSearchBackendImpl.mayGet("l", doc));
        Number number = versionCount = doc.has("versionCount") ? (Number)doc.get("versionCount").getAsNumber() : (Number)null;
        if (versionCount != null) {
            SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.VERSION_COUNT, versionCount.intValue());
        }
        if ((ec = doc.getAsJsonArray("ec")) != null) {
            result.put((Field)MAVEN.HAS_SOURCE, ec.contains((JsonElement)EC_SOURCE_JAR));
            result.put((Field)MAVEN.HAS_JAVADOC, ec.contains((JsonElement)EC_JAVADOC_JAR));
        }
        return new Record(this.getBackendId(), this.getRepositoryId(), doc.has("id") ? doc.get("id").getAsString() : null, doc.has("timestamp") ? Long.valueOf(doc.get("timestamp").getAsLong()) : null, result);
    }

    private static String mayGet(String field, JsonObject object) {
        return object.has(field) ? object.get(field).getAsString() : null;
    }

    private static void mayPut(Map<Field, Object> result, Field fieldName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && ((String)value).trim().isEmpty()) {
            return;
        }
        result.put(fieldName, value);
    }

    static {
        HashMap<Field.StringField, String> map = new HashMap<Field.StringField, String>();
        map.put(MAVEN.GROUP_ID, "g");
        map.put(MAVEN.ARTIFACT_ID, "a");
        map.put(MAVEN.VERSION, "v");
        map.put(MAVEN.CLASSIFIER, "l");
        map.put(MAVEN.PACKAGING, "p");
        map.put(MAVEN.CLASS_NAME, "c");
        map.put(MAVEN.FQ_CLASS_NAME, "fc");
        map.put(MAVEN.SHA1, "1");
        FIELD_TRANSLATION = Collections.unmodifiableMap(map);
        EC_SOURCE_JAR = new JsonPrimitive("-sources.jar");
        EC_JAVADOC_JAR = new JsonPrimitive("-javadoc.jar");
    }
}

