/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.util.Lookup;

public abstract class ProfilingPoint {
    static final String PROPERTY_NAME = "p_name";
    static final String PROPERTY_ENABLED = "p_enabled";
    static final String PROPERTY_PROJECT = "p_project";
    static final String PROPERTY_RESULTS = "p_results";
    static final String PROPERTY_CUSTOM = "p_custom";
    private final ProfilingPointFactory factory;
    private Lookup.Provider project;
    private PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);
    private ResultsRenderer resultsRenderer;
    private String name;
    private boolean enabled = true;

    ProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        this.name = name;
        this.project = project;
        this.factory = factory;
    }

    public final ProfilingPointFactory getFactory() {
        return this.factory;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.getChangeSupport().firePropertyChange(PROPERTY_ENABLED, !this.enabled, this.enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        if (this.name.equals(name) || name == null) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        this.getChangeSupport().firePropertyChange(PROPERTY_NAME, oldName, this.name);
    }

    public String getName() {
        return this.name;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean hasResults();

    public abstract void hideResults();

    public abstract void showResults(URL var1);

    public ResultsRenderer getResultsRenderer() {
        if (this.resultsRenderer == null) {
            this.resultsRenderer = new ResultsRenderer();
        }
        return this.resultsRenderer;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void customize(boolean deleteOnCancel, boolean focusToEditor) {
        final ValidityAwarePanel customizer = this.getCustomizer();
        if (!ProfilingPointsManager.getDefault().customize(customizer, new Runnable(){

            @Override
            public void run() {
                ProfilingPoint.this.setValues(customizer);
            }
        }, focusToEditor) && deleteOnCancel) {
            ProfilingPointsManager.getDefault().removeProfilingPoint(this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean supportsProfilingSettings(ProfilingSettings profilingSettings) {
        int profilingType = profilingSettings.getProfilingType();
        ProfilingPointFactory ppFactory = this.getFactory();
        return (profilingType == 8 || profilingType == 256 || profilingType == 16) && ppFactory.supportsCPU() || (profilingType == 2 || profilingType == 4) && ppFactory.supportsMemory() || profilingType == 1 && ppFactory.supportsMonitor();
    }

    public String toString() {
        return this.getName();
    }

    protected abstract String getResultsText();

    protected abstract void updateCustomizer(ValidityAwarePanel var1);

    protected PropertyChangeSupport getChangeSupport() {
        return this.propertyChangeSupport;
    }

    abstract void setValues(ValidityAwarePanel var1);

    abstract void reset();

    ValidityAwarePanel getCustomizer() {
        ValidityAwarePanel customizer = this.getFactory().getCustomizer();
        if (customizer != null) {
            this.updateCustomizer(customizer);
        }
        return customizer;
    }

    public static class ResultsRenderer
    extends HTMLLabel
    implements TableCellRenderer {
        private Reference<JComponent> lastTable;
        private Reference<ProfilingPoint> lastProfilingPoint;

        public ResultsRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProfilingPoint ppoint = (ProfilingPoint)value;
            if (ppoint == null && table != null) {
                ppoint = (ProfilingPoint)table.getValueAt(row, column);
            }
            if (ppoint == null) {
                this.setText("");
                this.setEnabled(true);
            } else {
                this.setText("<table cellspacing='0' cellpadding='0'><tr><td height='" + table.getRowHeight() + "' valign='middle'><nobr>&nbsp;" + ppoint.getResultsText() + "&nbsp;</nobr></td></tr></table>");
                this.setEnabled(ppoint.isEnabled());
            }
            this.lastTable = new WeakReference<JTable>(table);
            this.lastProfilingPoint = new WeakReference<ProfilingPoint>(ppoint);
            return this;
        }

        public void dispatchMouseEvent(MouseEvent e, Rectangle offset) {
            this.setSize(this.getPreferredSize());
            int w = offset.width - this.getPreferredSize().width;
            MouseEvent event = new MouseEvent((Component)((Object)this), e.getID(), e.getWhen(), e.getModifiers(), e.getX() - offset.x - w, e.getY() - offset.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.processEvent(event);
        }

        public void setCaretPosition(int position) {
        }

        public void moveCaretPosition(int position) {
        }

        public void setCursor(Cursor cursor) {
            JComponent table;
            super.setCursor(cursor);
            JComponent jComponent = table = this.lastTable != null ? this.lastTable.get() : null;
            if (table != null) {
                table.setCursor(cursor);
            }
        }

        protected void showURL(URL url) {
            ProfilingPoint ppoint;
            ProfilingPoint profilingPoint = ppoint = this.lastProfilingPoint != null ? this.lastProfilingPoint.get() : null;
            if (ppoint != null) {
                ppoint.showResults(url);
            }
        }
    }
}

