/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bsf.BSFException;
import org.apache.bsf.engines.javascript.BreakPoint;
import org.apache.bsf.engines.javascript.FnOrScript;
import org.apache.bsf.engines.javascript.RhinoEngineDebugger;

public class DocumentCell {
    RhinoEngineDebugger m_rhinoDebugger;
    String m_docName;
    Vector m_fnOrScripts;
    Vector m_breakpoints;
    private boolean m_entryexit;
    private FnOrScript m_lastFnOrScript;
    Hashtable m_functionMap;

    public DocumentCell(RhinoEngineDebugger rhinoEngineDebugger, String string) {
        this.m_rhinoDebugger = rhinoEngineDebugger;
        this.m_docName = string;
        this.m_breakpoints = new Vector();
        this.m_functionMap = new Hashtable();
        this.m_fnOrScripts = new Vector();
        this.m_entryexit = false;
        this.m_lastFnOrScript = null;
    }

    public String getName() {
        return this.m_docName;
    }

    public void addBreakpointAtLine(int n, int n2) {
        BreakPoint breakPoint = new BreakPoint(this, n);
        breakPoint.setLineNo(n2);
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            try {
                if (!fnOrScript.contains(breakPoint)) continue;
                fnOrScript.addBreakpoint(breakPoint);
                return;
            }
            catch (BSFException bSFException) {
                // empty catch block
            }
        }
        this.m_breakpoints.addElement(breakPoint);
    }

    public void addBreakpointAtOffset(int n, int n2) {
        BreakPoint breakPoint = new BreakPoint(this, n);
        breakPoint.setOffset(n2);
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            try {
                if (!fnOrScript.contains(breakPoint)) continue;
                fnOrScript.addBreakpoint(breakPoint);
                return;
            }
            catch (BSFException bSFException) {
                // empty catch block
            }
        }
        this.m_breakpoints.addElement(breakPoint);
    }

    private void attachBreakpoints(FnOrScript fnOrScript) {
        BreakPoint breakPoint;
        Vector<BreakPoint> vector = new Vector<BreakPoint>();
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            breakPoint = (BreakPoint)enumeration.nextElement();
            try {
                if (!fnOrScript.contains(breakPoint)) continue;
                fnOrScript.addBreakpoint(breakPoint);
                vector.addElement(breakPoint);
            }
            catch (BSFException bSFException) {
                // empty catch block
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            breakPoint = (BreakPoint)enumeration.nextElement();
            this.m_breakpoints.removeElement(breakPoint);
        }
    }

    public BreakPoint findBreakpointAtLine(int n) throws BSFException {
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            BreakPoint breakPoint = fnOrScript.findBreakpointAtLine(n);
            if (breakPoint == null) continue;
            return breakPoint;
        }
        return null;
    }

    public BreakPoint findBreakpointAtOffset(int n) throws BSFException {
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            BreakPoint breakPoint = fnOrScript.findBreakpointAtOffset(n);
            if (breakPoint == null) continue;
            return breakPoint;
        }
        return null;
    }

    public FnOrScript findFnOrScript(int n, int n2) {
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            if (fnOrScript.m_startLine != n || fnOrScript.m_column != n2) continue;
            return fnOrScript;
        }
        return null;
    }

    public FnOrScript findFnOrScriptContaining(int n) {
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            if (fnOrScript.m_startLine > n || fnOrScript.m_startLine + fnOrScript.m_lineCount < n) continue;
            return fnOrScript;
        }
        return null;
    }

    public Enumeration fnOrScripts() {
        return this.m_fnOrScripts.elements();
    }

    public FnOrScript registerFnOrScriptLines(Reader reader, int n, int n2) throws BSFException {
        FnOrScript fnOrScript;
        Enumeration enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            fnOrScript = (FnOrScript)enumeration.nextElement();
            if (fnOrScript.getFirstLine() != n || fnOrScript.getColumn() != n2) continue;
            return fnOrScript;
        }
        try {
            fnOrScript = new FnOrScript(this);
            this.m_fnOrScripts.addElement(fnOrScript);
            fnOrScript.specifyLinesPos(reader, n, n2);
            this.attachBreakpoints(fnOrScript);
        }
        catch (IOException iOException) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "while registering script or function.", iOException);
        }
        return fnOrScript;
    }

    public FnOrScript registerFnOrScriptLines(String string, int n, int n2) throws BSFException {
        StringReader stringReader = new StringReader(string);
        return this.registerFnOrScriptLines(stringReader, n, n2);
    }

    public FnOrScript registerFnOrScriptRange(Reader reader, int n) throws BSFException {
        FnOrScript fnOrScript;
        try {
            fnOrScript = new FnOrScript(this);
            this.m_fnOrScripts.addElement(fnOrScript);
            fnOrScript.specifyRange(reader, n);
            this.attachBreakpoints(fnOrScript);
        }
        catch (IOException iOException) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "while registering script or function.", iOException);
        }
        return fnOrScript;
    }

    public FnOrScript registerFnOrScriptRange(String string, int n) throws BSFException {
        StringReader stringReader = new StringReader(string);
        return this.registerFnOrScriptRange(stringReader, n);
    }

    public BreakPoint removeBreakpoint(int n) {
        BreakPoint breakPoint = null;
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            breakPoint = (BreakPoint)enumeration.nextElement();
            if (breakPoint.getId() != n) continue;
            this.m_breakpoints.removeElement(breakPoint);
            return breakPoint;
        }
        enumeration = this.m_fnOrScripts.elements();
        while (enumeration.hasMoreElements()) {
            FnOrScript fnOrScript = (FnOrScript)enumeration.nextElement();
            breakPoint = fnOrScript.removeBreakpoint(n);
            if (null != breakPoint) break;
        }
        return breakPoint;
    }

    public void setEntryExit(boolean bl) {
        this.m_entryexit = bl;
    }

    public boolean getEntryExit() {
        return this.m_entryexit;
    }

    public void setLastFnOrScript(FnOrScript fnOrScript) {
        this.m_lastFnOrScript = fnOrScript;
    }

    public FnOrScript getLastFnOrScript() {
        return this.m_lastFnOrScript;
    }
}

