/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.openide.filesystems.FileObject;

public class PhpProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOrRenameOperationImplementation {
    private final PhpProject project;

    public PhpProjectOperations(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public void notifyDeleted() throws IOException {
        this.project.getHelper().notifyDeleted();
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyCopied(Project originalProject, File file, String newName) throws IOException {
        if (originalProject == null) {
            return;
        }
        this.project.setName(newName);
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyMoved(Project originalProject, File file, String newName) throws IOException {
        if (originalProject == null) {
            this.project.getHelper().notifyDeleted();
            return;
        }
        this.project.setName(newName);
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyRenaming() throws IOException {
    }

    public void notifyRenamed(String nueName) throws IOException {
        this.project.setName(nueName);
    }

    public List<FileObject> getDataFiles() {
        return Arrays.asList(PhpProjectUtils.getSourceObjects(this.project));
    }

    public List<FileObject> getMetadataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>(1);
        FileObject nbProject = this.project.getHelper().getProjectDirectory().getFileObject("nbproject");
        if (nbProject != null) {
            files.add(nbProject);
        }
        return files;
    }
}

