/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class ExportClauseNode
extends Node {
    private final List<ExportSpecifierNode> exportSpecifiers;

    public ExportClauseNode(long token, int start, int finish, List<ExportSpecifierNode> exportSpecifiers) {
        super(token, start, finish);
        this.exportSpecifiers = exportSpecifiers;
    }

    private ExportClauseNode(ExportClauseNode node, List<ExportSpecifierNode> exportSpecifiers) {
        super(node);
        this.exportSpecifiers = exportSpecifiers;
    }

    public List<ExportSpecifierNode> getExportSpecifiers() {
        return Collections.unmodifiableList(this.exportSpecifiers);
    }

    public ExportClauseNode setExportSpecifiers(List<ExportSpecifierNode> exportSpecifiers) {
        if (this.exportSpecifiers == exportSpecifiers) {
            return this;
        }
        return new ExportClauseNode(this, exportSpecifiers);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterExportClauseNode(this)) {
            return visitor.leaveExportClauseNode(this.setExportSpecifiers(Node.accept(visitor, this.exportSpecifiers)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterExportClauseNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append('{');
        for (int i = 0; i < this.exportSpecifiers.size(); ++i) {
            this.exportSpecifiers.get(i).toString(sb, printType);
            if (i >= this.exportSpecifiers.size() - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
    }
}

