/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.ListRemoteObjectsCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListRemoteTagsCommand
extends ListRemoteObjectsCommand {
    private Map<String, String> remoteTags;
    private final String remoteUrl;

    public ListRemoteTagsCommand(Repository repository, GitClassFactory gitFactory, String remoteRepositoryUrl, ProgressMonitor monitor) {
        super(repository, gitFactory, remoteRepositoryUrl, monitor);
        this.remoteUrl = remoteRepositoryUrl;
    }

    @Override
    protected void processRefs() {
        this.remoteTags = new LinkedHashMap<String, String>();
        this.remoteTags.putAll(Utils.refsToTags(this.getRefs()));
    }

    @Override
    protected String getCommandDescription() {
        return "git ls-remote --heads " + this.remoteUrl.toString();
    }

    public Map<String, String> getTags() {
        return this.remoteTags;
    }
}

