/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.ui.nodes.Bundle;
import org.netbeans.modules.hudson.ui.nodes.HudsonFolderNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class HudsonInstanceNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/hudson/ui/resources/instance.png";
    private final HudsonInstance instance;
    private Sheet.Set set;
    private boolean warn = false;
    private boolean run = false;
    private boolean alive = false;
    private boolean forbidden;
    private boolean version = false;
    public static final String SELECTED_VIEW = "view";

    public HudsonInstanceNode(HudsonInstance instance) {
        super((Children)new InstanceNodeChildren(instance), Lookups.singleton((Object)instance));
        this.setName(instance.getUrl());
        this.setDisplayName(instance.getName());
        this.setShortDescription(instance.getUrl());
        this.setIconBaseWithExtension(ICON_BASE);
        this.setValue("customDelete", true);
        this.instance = instance;
        instance.addHudsonChangeListener(new HudsonChangeListener(){

            public void stateChanged() {
                HudsonInstanceNode.this.refreshState();
            }

            public void contentChanged() {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        this.refreshState();
        this.refreshContent();
    }

    public String getHtmlDisplayName() {
        String selectedView = this.instance.prefs().get(SELECTED_VIEW, null);
        return (this.run ? "<b>" : "") + (this.warn ? "<font color=\"#A40000\">" : "") + this.instance.getName() + (this.warn ? "</font>" : "") + (this.run ? "</b>" : "") + (selectedView != null ? " <font color='!controlShadow'>[" + selectedView + "]</font>" : "") + (this.alive ? (this.version ? "" : " <font color=\"#A40000\">" + Bundle.MSG_WrongVersion(HudsonVersion.SUPPORTED_VERSION) + "</font>") : " <font color=\"#A40000\">" + (this.forbidden ? Bundle.MSG_forbidden() : Bundle.MSG_Disconnected()) + "</font>") + this.getProjectInfoString();
    }

    private String getProjectInfoString() {
        boolean pers = this.instance.isPersisted();
        String info = this.instance.getPersistence().getInfo(Bundle.HudsonInstanceNode_from_open_project());
        return !pers ? " <font color='!controlShadow'>" + info + "</font>" : "";
    }

    public Action[] getActions(boolean context) {
        List actions = Utilities.actionsForPath((String)"org-netbeans-modules-hudson/Actions/instance");
        return actions.toArray(new Action[actions.size()]);
    }

    public boolean canDestroy() {
        return this.instance.isPersisted();
    }

    public void destroy() throws IOException {
        HudsonManager.removeInstance((HudsonInstance)this.instance);
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[]{this.getSheetSet()};
    }

    private Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName(this.instance.getName());
            this.set.put(new Node.Property[]{new PropertySupport<String>("name", String.class, Bundle.TXT_Instance_Prop_Name(), Bundle.DESC_Instance_Prop_Name(), true, false){

                public String getValue() {
                    return HudsonInstanceNode.this.instance.getName();
                }

                public void setValue(String val) {
                }
            }, new PropertySupport<String>("url", String.class, Bundle.TXT_Instance_Prop_Url(), Bundle.DESC_Instance_Prop_Url(), true, false){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return HudsonInstanceNode.this.instance.getUrl();
                }

                public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            }, new PropertySupport<Integer>("sync", Integer.class, Bundle.TXT_Instance_Prop_Sync(), Bundle.DESC_Instance_Prop_Sync(), true, true){

                public Integer getValue() {
                    return HudsonInstanceNode.this.instance.getSyncInterval();
                }

                public void setValue(Integer val) {
                    if (val == null || val < 0) {
                        throw new IllegalArgumentException();
                    }
                    HudsonInstanceNode.this.instance.setSyncInterval(val.intValue());
                }

                public boolean canWrite() {
                    return HudsonInstanceNode.this.instance.isPersisted();
                }
            }});
        }
        return this.set;
    }

    private synchronized void refreshState() {
        this.alive = this.instance.isConnected();
        this.forbidden = this.instance.isForbidden();
        this.version = org.netbeans.modules.hudson.api.Utilities.isSupportedVersion((HudsonVersion)this.instance.getVersion());
        this.fireDisplayNameChange(null, this.getHtmlDisplayName());
    }

    private synchronized void refreshContent() {
        this.warn = false;
        this.run = false;
        for (HudsonJob job : this.instance.getJobs()) {
            if (job.getColor().equals((Object)HudsonJob.Color.red) || job.getColor().equals((Object)HudsonJob.Color.red_anime)) {
                this.warn = true;
            }
            if (job.getColor().isRunning()) {
                this.run = true;
            }
            if (!this.warn || !this.run) continue;
            break;
        }
        this.fireDisplayNameChange(null, this.getHtmlDisplayName());
    }

    private static class InstanceNodeChildren
    extends Children.Keys<Union2<HudsonJob, HudsonFolder>>
    implements HudsonChangeListener {
        private final HudsonInstance instance;

        InstanceNodeChildren(HudsonInstance instance) {
            this.instance = instance;
            instance.addHudsonChangeListener((HudsonChangeListener)this);
            instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(Union2<HudsonJob, HudsonFolder> item) {
            return new Node[]{item.hasFirst() ? new HudsonJobNode((HudsonJob)item.first()) : new HudsonFolderNode((HudsonFolder)item.second())};
        }

        protected void addNotify() {
            super.addNotify();
            if (!this.instance.isConnected()) {
                this.setKeys(Collections.emptySet());
                this.instance.synchronize(true);
            } else {
                this.refreshKeys();
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            ArrayList<HudsonJob> jobs = new ArrayList<HudsonJob>();
            HudsonView view = this.instance.getPrimaryView();
            String selectedView = this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
            if (selectedView != null) {
                for (HudsonView v : this.instance.getViews()) {
                    if (!v.getName().equals(selectedView)) continue;
                    view = v;
                    break;
                }
            }
            for (HudsonJob job : this.instance.getJobs()) {
                if (!job.getViews().contains(view)) continue;
                jobs.add(job);
            }
            Collections.sort(jobs);
            LinkedList<Union2> items = new LinkedList<Union2>();
            for (HudsonFolder folder : this.instance.getFolders()) {
                items.add(Union2.createSecond((Object)folder));
            }
            for (HudsonJob job : jobs) {
                items.add(Union2.createFirst((Object)job));
            }
            this.setKeys(items);
        }

        public void stateChanged() {
            this.refreshKeys();
        }

        public void contentChanged() {
            this.refreshKeys();
        }
    }
}

