/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.netbeans.modules.micronaut.completion.MicronautDataCompletionTask;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.micronaut.expression.EvaluationContext;
import org.netbeans.modules.micronaut.expression.ExpressionTree;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageParser;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautExpressionLanguageCompletion {
    private static final String PATTERN = "(?:\\b[_a-zA-Z]|\\B\\$)[_$a-zA-Z0-9]*+";
    private final CompilationInfo info;
    private final EvaluationContext ctx;
    private final int startOffset;
    private final ExpressionTree tree;
    private final TokenSequence<?> ts;

    public MicronautExpressionLanguageCompletion(CompilationInfo info, EvaluationContext ctx, String text, int startOffset) {
        this.info = info;
        this.ctx = ctx;
        this.startOffset = startOffset;
        this.tree = new MicronautExpressionLanguageParser(text).parse();
        TokenHierarchy th = TokenHierarchy.create((CharSequence)text, (Language)Language.find((String)"text/x-micronaut-el"));
        this.ts = th.tokenSequence();
    }

    /*
     * WARNING - void declaration
     */
    public <T> Result<T> query(int offset, ItemFactory<T> factory) {
        int anchorOffset = -1;
        ArrayList<T> items = new ArrayList<T>();
        int d = this.ts.move(offset);
        if (d == 0 && this.ts.movePrevious() || this.ts.moveNext() || this.ts.isEmpty()) {
            List<String> kws = null;
            List<String> builtins = null;
            List<ExecutableElement> elements = null;
            List properties = null;
            Object prefix = "";
            boolean wrapProperties = true;
            String pkgPrefix = null;
            if (this.tree == null) {
                kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("true", "false", "null", "this", "empty", "not") : Arrays.asList("true", "false", "null", "empty", "not");
                builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                elements = this.ctx.getContextMethods();
                anchorOffset = this.startOffset + offset;
            } else {
                void var14_19;
                String tokenText = this.ts.token().text().subSequence(0, offset - this.ts.offset()).toString().trim();
                if (Pattern.matches(PATTERN, tokenText)) {
                    prefix = tokenText;
                    offset -= ((String)prefix).length();
                }
                anchorOffset = this.startOffset + offset;
                ExpressionTree.Path path = ExpressionTree.Path.get(this.tree, offset);
                while (var14_19 != null && var14_19.getLeaf().getKind() == ExpressionTree.Kind.ERRONEOUS) {
                    ExpressionTree.Path path2 = var14_19.getParentPath();
                }
                if (var14_19 == null) {
                    if (offset <= this.tree.getStartPosition()) {
                        kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("true", "false", "null", "this", "empty", "not") : Arrays.asList("true", "false", "null", "empty", "not");
                        builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                        elements = this.ctx.getContextMethods();
                    } else {
                        ExpressionTree lastTree = this.tree;
                        if (this.tree.getKind() == ExpressionTree.Kind.ERRONEOUS) {
                            for (ExpressionTree expressionTree : ((ExpressionTree.Erroneous)this.tree).getErrorTrees()) {
                                if (offset <= expressionTree.getStartPosition()) continue;
                                lastTree = expressionTree;
                            }
                        }
                        TypeMirror treeType = lastTree.getTypeMirror(this.ctx);
                        block0 : switch (treeType.getKind()) {
                            case BOOLEAN: {
                                TypeMirror typeMirror = lastTree instanceof ExpressionTree.BinaryExpression ? ((ExpressionTree.BinaryExpression)lastTree).getRightOperand().getTypeMirror(this.ctx) : this.info.getTypes().getNoType(TypeKind.NONE);
                                switch (typeMirror.getKind()) {
                                    case INT: 
                                    case LONG: 
                                    case FLOAT: 
                                    case DOUBLE: {
                                        kws = Arrays.asList("and", "or", "div", "mod", "instanceof");
                                        break block0;
                                    }
                                }
                                kws = Arrays.asList("and", "or", "instanceof");
                                break;
                            }
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                kws = Arrays.asList("div", "mod", "instanceof");
                                break;
                            }
                            case DECLARED: {
                                if ("java.lang.String".contentEquals(((TypeElement)((DeclaredType)treeType).asElement()).getQualifiedName())) {
                                    kws = Arrays.asList("matches", "instanceof");
                                    break;
                                }
                            }
                            case ARRAY: {
                                kws = Arrays.asList("instanceof");
                                break;
                            }
                            case NONE: {
                                String prev = this.prevNonWSTokenText((String)prefix);
                                if (!"#".equals(prev)) break;
                                elements = this.ctx.getContextMethods();
                            }
                        }
                    }
                } else {
                    TypeMirror lastTreeType = null;
                    switch (var14_19.getLeaf().getKind()) {
                        case STRING_LITERAL: {
                            if (var14_19.getParentPath() == null || var14_19.getParentPath().getLeaf().getKind() != ExpressionTree.Kind.ENVIRONMENT_ACCESS) break;
                            String value = (String)((ExpressionTree.Literal)var14_19.getLeaf()).getValue();
                            if (value.startsWith(tokenText)) {
                                prefix = tokenText;
                                anchorOffset = this.startOffset + this.ts.offset();
                            }
                            wrapProperties = false;
                            ExpressionTree.Path path3 = var14_19.getParentPath();
                        }
                        case ENVIRONMENT_ACCESS: {
                            Project project;
                            void var14_22;
                            ExpressionTree.EnvironmentAccess environmentAccess = (ExpressionTree.EnvironmentAccess)var14_22.getLeaf();
                            ExpressionTree propertyName = environmentAccess.getPropertyName();
                            if (propertyName.getKind() != ExpressionTree.Kind.ERRONEOUS && offset >= propertyName.getEndPosition() || (project = FileOwnerQuery.getOwner((FileObject)this.info.getFileObject())) == null) break;
                            properties = MicronautConfigProperties.getProperties(project).values().stream().filter(property -> !property.getId().contains("*")).collect(Collectors.toList());
                            break;
                        }
                        case BEAN_CONTEXT_ACCESS: {
                            if (offset > ((ExpressionTree.BeanContextAccess)var14_19.getLeaf()).getTypeReference().getEndPosition()) break;
                            builtins = Arrays.asList("T", "()");
                            ExpressionTree.Path path4 = new ExpressionTree.Path((ExpressionTree.Path)var14_19, ((ExpressionTree.BeanContextAccess)var14_19.getLeaf()).getTypeReference());
                        }
                        case TYPE_REFERENCE: {
                            void var14_24;
                            ExpressionTree.TypeReference tr = (ExpressionTree.TypeReference)var14_24.getLeaf();
                            int len = offset - tr.getTypeStartPosition();
                            if (len > tr.getTypeName().length()) break;
                            pkgPrefix = len >= 0 && tr.getTypeName().length() > len ? tr.getTypeName().substring(0, len) : tr.getTypeName();
                            PackageElement pkg = this.info.getElements().getPackageElement(pkgPrefix.isEmpty() ? "java.lang" : pkgPrefix.substring(0, pkgPrefix.length() - 1));
                            if (pkg == null) break;
                            elements = pkg.getEnclosedElements().stream().filter(e -> e.getKind().isClass() || e.getKind().isInterface()).collect(Collectors.toList());
                            break;
                        }
                        case PLUS: 
                        case MINUS: 
                        case MULTIPLY: 
                        case DIVIDE: 
                        case REMAINDER: 
                        case POWER: 
                        case GREATER_THAN: 
                        case LESS_THAN: 
                        case GREATER_THAN_EQUAL: 
                        case LESS_THAN_EQUAL: 
                        case MATCHES: {
                            ExpressionTree.BinaryExpression binary = (ExpressionTree.BinaryExpression)var14_19.getLeaf();
                            if (this.nextNonWSTokenCategory((String)prefix, binary.getRightOperand().getStartPosition()).startsWith("keyword.operator")) {
                                lastTreeType = binary.getLeftOperand().getTypeMirror(this.ctx);
                                break;
                            }
                            if (this.ctx.getScope().getEnclosingMethod() != null) {
                                kws = Arrays.asList("this");
                            }
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case EQUAL_TO: 
                        case NOT_EQUAL_TO: {
                            ExpressionTree.BinaryExpression binary = (ExpressionTree.BinaryExpression)var14_19.getLeaf();
                            if (this.nextNonWSTokenCategory((String)prefix, binary.getRightOperand().getStartPosition()).startsWith("keyword.operator")) {
                                lastTreeType = binary.getLeftOperand().getTypeMirror(this.ctx);
                                break;
                            }
                            kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("null", "this") : Arrays.asList("null");
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case AND: 
                        case OR: {
                            ExpressionTree.BinaryExpression binary = (ExpressionTree.BinaryExpression)var14_19.getLeaf();
                            if (this.nextNonWSTokenCategory((String)prefix, binary.getRightOperand().getStartPosition()).startsWith("keyword.operator")) {
                                lastTreeType = binary.getLeftOperand().getTypeMirror(this.ctx);
                                break;
                            }
                        }
                        case NOT: {
                            kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("true", "false", "not", "empty", "this") : Arrays.asList("true", "false", "not", "empty");
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case EMPTY: {
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case INSTANCE_OF: {
                            ExpressionTree.InstanceOf instanceOf = (ExpressionTree.InstanceOf)var14_19.getLeaf();
                            if (this.nextNonWSTokenCategory((String)prefix, instanceOf.getType().getStartPosition()).startsWith("keyword.operator")) {
                                lastTreeType = instanceOf.getExpression().getTypeMirror(this.ctx);
                                break;
                            }
                            builtins = Arrays.asList("T", "()");
                            break;
                        }
                        case TERNARY: {
                            ExpressionTree.TernaryExpression ternary = (ExpressionTree.TernaryExpression)var14_19.getLeaf();
                            String next = this.nextNonWSTokenCategory((String)prefix, ternary.getTrueExpression().getStartPosition());
                            if ("keyword.control.ternary.qmark.mexp".equals(next)) {
                                lastTreeType = ternary.getCondition().getTypeMirror(this.ctx);
                                break;
                            }
                            String prev = this.prevNonWSTokenText((String)prefix);
                            if (!"?".equals(prev) && !":".equals(prev)) break;
                            kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("true", "false", "null", "this", "empty", "not") : Arrays.asList("true", "false", "null", "empty", "not");
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case PROPERTY_ACCESS: {
                            String prev = this.prevNonWSTokenText((String)prefix);
                            if (!".".equals(prev) && !"?.".equals(prev) && !"#".equals(prev)) break;
                            ExpressionTree.PropertyAccess pa = (ExpressionTree.PropertyAccess)var14_19.getLeaf();
                            ExpressionTree callee = pa.getCallee();
                            if (callee != null) {
                                TypeMirror pacTM = callee.getTypeMirror(this.ctx);
                                if (pacTM.getKind() != TypeKind.DECLARED) break;
                                elements = ElementFilter.methodsIn(((DeclaredType)pacTM).asElement().getEnclosedElements()).stream().filter(ee -> callee.getKind() != ExpressionTree.Kind.TYPE_REFERENCE || ee.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
                                break;
                            }
                            elements = this.ctx.getContextMethods();
                            break;
                        }
                        case METHOD_CALL: {
                            ExpressionTree callee;
                            String prev = this.prevNonWSTokenText((String)prefix);
                            if (".".equals(prev) || "?.".equals(prev) || "#".equals(prev)) {
                                ExpressionTree.MethodCall methCall = (ExpressionTree.MethodCall)var14_19.getLeaf();
                                callee = methCall.getCallee();
                                if (callee != null) {
                                    TypeMirror methTM = callee.getTypeMirror(this.ctx);
                                    if (methTM.getKind() != TypeKind.DECLARED) break;
                                    elements = ElementFilter.methodsIn(((DeclaredType)methTM).asElement().getEnclosedElements()).stream().filter(ee -> callee.getKind() != ExpressionTree.Kind.TYPE_REFERENCE || ee.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
                                    break;
                                }
                                elements = this.ctx.getContextMethods();
                                break;
                            }
                            if (!"(".equals(prev) && !",".equals(prev)) break;
                            kws = this.ctx.getScope().getEnclosingMethod() != null ? Arrays.asList("true", "false", "null", "this", "empty", "not") : Arrays.asList("true", "false", "null", "empty", "not");
                            builtins = Arrays.asList("T", "()", "ctx", "[]", "env", "[]");
                            elements = this.ctx.getContextMethods();
                        }
                    }
                    if (lastTreeType != null) {
                        block25 : switch (lastTreeType.getKind()) {
                            case BOOLEAN: {
                                ExpressionTree.TernaryExpression ternaryExpression;
                                void var14_25;
                                TypeMirror rtm = this.info.getTypes().getNoType(TypeKind.NONE);
                                if (var14_25.getLeaf().getKind() == ExpressionTree.Kind.TERNARY && (ternaryExpression = (ExpressionTree.TernaryExpression)var14_25.getLeaf()).getCondition() instanceof ExpressionTree.BinaryExpression) {
                                    rtm = ((ExpressionTree.BinaryExpression)ternaryExpression.getCondition()).getRightOperand().getTypeMirror(this.ctx);
                                }
                                switch (rtm.getKind()) {
                                    case INT: 
                                    case LONG: 
                                    case FLOAT: 
                                    case DOUBLE: {
                                        kws = Arrays.asList("and", "or", "div", "mod", "instanceof");
                                        break block25;
                                    }
                                }
                                kws = Arrays.asList("and", "or", "instanceof");
                                break;
                            }
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                NoType ptm;
                                void var14_25;
                                ExpressionTree.Path path5 = var14_25.getParentPath();
                                TypeMirror typeMirror = ptm = path5 != null && path5.getLeaf() instanceof ExpressionTree.BinaryExpression ? path5.getLeaf().getTypeMirror(this.ctx) : this.info.getTypes().getNoType(TypeKind.NONE);
                                if (ptm.getKind() == TypeKind.BOOLEAN) {
                                    kws = Arrays.asList("and", "or", "div", "mod", "instanceof");
                                    break;
                                }
                                kws = Arrays.asList("div", "mod", "instanceof");
                                break;
                            }
                            case DECLARED: {
                                if ("java.lang.String".contentEquals(((TypeElement)((DeclaredType)lastTreeType).asElement()).getQualifiedName())) {
                                    kws = Arrays.asList("matches", "instanceof");
                                    break;
                                }
                            }
                            case ARRAY: {
                                kws = Arrays.asList("instanceof");
                            }
                        }
                    }
                }
            }
            if (kws != null) {
                for (String string : kws) {
                    if (!Utils.startsWith(string, (String)prefix)) continue;
                    items.add(factory.createKeywordItem(string, anchorOffset));
                }
            }
            if (builtins != null) {
                for (int j = 0; j < builtins.size(); j += 2) {
                    if (!Utils.startsWith((String)builtins.get(j), (String)prefix)) continue;
                    items.add(factory.createBuiltInItem(builtins.get(j), builtins.get(j + 1), anchorOffset));
                }
            }
            if (elements != null) {
                for (Element element : elements) {
                    String name = element.getSimpleName().toString();
                    if (element.getKind() == ElementKind.METHOD) {
                        String string;
                        TypeMirror enclType = element.getEnclosingElement().asType();
                        if (enclType.getKind() != TypeKind.DECLARED) continue;
                        if (Utils.startsWith(name, (String)prefix) && this.info.getTrees().isAccessible(this.ctx.getScope(), element, (DeclaredType)enclType)) {
                            items.add(factory.createJavaElementItem(this.info, element, anchorOffset));
                        }
                        if (!Utils.startsWith(string = element.getKind() == ElementKind.METHOD ? ExpressionTree.getPropertyName((ExecutableElement)element) : null, (String)prefix) || !this.info.getTrees().isAccessible(this.ctx.getScope(), element, (DeclaredType)enclType)) continue;
                        String returnType = MicronautDataCompletionTask.getTypeName(this.info, ((ExecutableElement)element).getReturnType(), false, false).toString();
                        items.add(factory.createBeanPropertyItem(string, returnType, anchorOffset));
                        continue;
                    }
                    if (!Utils.startsWith(name, (String)prefix) || !this.info.getTrees().isAccessible(this.ctx.getScope(), (TypeElement)element)) continue;
                    items.add(factory.createJavaElementItem(this.info, element, anchorOffset));
                }
            }
            if (properties != null) {
                for (ConfigurationMetadataProperty configurationMetadataProperty : properties) {
                    if (!Utils.startsWith(configurationMetadataProperty.getId(), (String)prefix)) continue;
                    items.add(factory.createEnvPropertyItem(wrapProperties ? "'" + configurationMetadataProperty.getId() + "'" : configurationMetadataProperty.getId(), new MicronautConfigDocumentation(configurationMetadataProperty).getText(), anchorOffset, this.startOffset + offset));
                }
            }
            if (pkgPrefix != null) {
                HashSet<String> seenPkgs = new HashSet<String>();
                for (String pkgName : this.info.getClasspathInfo().getClassIndex().getPackageNames(pkgPrefix, false, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                    if (!Utils.startsWith(pkgName, pkgPrefix + (String)prefix)) continue;
                    String name = pkgName.substring(pkgPrefix.length());
                    int n = name.indexOf(46);
                    if (n > 0) {
                        name = name.substring(0, n);
                    }
                    if (!seenPkgs.add(name)) continue;
                    items.add(factory.createPackageItem(name, anchorOffset));
                }
            }
        }
        return new Result(items, anchorOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prevNonWSTokenText(String prefix) {
        int idx = this.ts.index();
        try {
            if ((prefix.isEmpty() || this.ts.movePrevious()) && this.ts.token().text().toString().trim().isEmpty()) {
                this.ts.movePrevious();
            }
            String string = this.ts.token().text().toString();
            return string;
        }
        finally {
            while (this.ts.index() > idx) {
                this.ts.movePrevious();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextNonWSTokenCategory(String prefix, int upToOffset) {
        int idx = this.ts.index();
        try {
            List categories;
            if ((!prefix.isEmpty() || this.ts.moveNext()) && this.ts.offset() < upToOffset && (categories = (List)this.ts.token().getProperty((Object)"categories")) != null && categories.size() > 1) {
                String string = (String)categories.get(categories.size() - 1);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            while (this.ts.index() > idx) {
                this.ts.movePrevious();
            }
        }
    }

    public static class Result<T> {
        private final List<T> items;
        private final int anchorOffset;

        private Result(List<T> items, int anchorOffset) {
            this.items = items;
            this.anchorOffset = anchorOffset;
        }

        public List<T> getItems() {
            return this.items;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }
    }

    public static interface ItemFactory<T> {
        public T createKeywordItem(String var1, int var2);

        public T createBuiltInItem(String var1, String var2, int var3);

        public T createPackageItem(String var1, int var2);

        public T createBeanPropertyItem(String var1, String var2, int var3);

        public T createEnvPropertyItem(String var1, String var2, int var3, int var4);

        public T createJavaElementItem(CompilationInfo var1, Element var2, int var3);
    }
}

