/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.LazyCodeAction;
import org.netbeans.api.lsp.Range;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.EndpointSelectorPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.lsp.CodeActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Union2;

public class MicronautDataEndpointGenerator
implements CodeActionProvider {
    private static final String SOURCE = "source";
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";

    public List<CodeAction> getCodeActions(Document doc, Range range, Lookup context) {
        try {
            CompilationController cc;
            List only = (List)context.lookup(List.class);
            if (only == null || !only.contains(SOURCE)) {
                return Collections.emptyList();
            }
            ResultIterator resultIterator = (ResultIterator)context.lookup(ResultIterator.class);
            CompilationController compilationController = cc = resultIterator != null && resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
            if (cc == null) {
                return Collections.emptyList();
            }
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            int offset = range.getStartOffset();
            TreePath path = cc.getTreeUtilities().pathFor(offset);
            path = cc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return Collections.emptyList();
            }
            TypeElement te = (TypeElement)cc.getTrees().getElement(path);
            if (te == null || !te.getKind().isClass()) {
                return Collections.emptyList();
            }
            AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
            if (controllerAnn == null) {
                return Collections.emptyList();
            }
            List<VariableElement> repositories = Utils.getRepositoriesFor((CompilationInfo)cc, te);
            if (repositories.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList endpoints = new ArrayList();
            Utils.collectMissingDataEndpoints((CompilationInfo)cc, te, null, (repository, delegateMethod, id) -> {
                switch (delegateMethod.getSimpleName().toString()) {
                    case "findAll": {
                        endpoints.add(id != null ? id + "/ -- GET" : "/ -- GET");
                        break;
                    }
                    case "findById": {
                        endpoints.add(id != null ? id + "/{id} -- GET" : "/{id} -- GET");
                        break;
                    }
                    case "deleteById": {
                        endpoints.add(id != null ? id + "/{id} -- DELETE" : "/{id} -- DELETE");
                    }
                }
            });
            if (!endpoints.isEmpty()) {
                FileObject fo = cc.getFileObject();
                List repositoryHandles = repositories.stream().map(repository -> ElementHandle.create((Element)repository)).collect(Collectors.toList());
                return Collections.singletonList(new LazyCodeAction(Bundle.DN_GenerateDataEndpoint(), SOURCE, null, () -> {
                    try {
                        List items = endpoints.stream().map(endpoint -> new NotifyDescriptor.QuickPick.Item(endpoint, null)).collect(Collectors.toList());
                        NotifyDescriptor.QuickPick pick = new NotifyDescriptor.QuickPick(Bundle.DN_GenerateDataEndpoint(), Bundle.DN_SelectEndpoints(), items, true);
                        if (DialogDescriptor.OK_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)pick)) {
                            return null;
                        }
                        ArrayList<String> selectedIds = new ArrayList<String>();
                        for (NotifyDescriptor.QuickPick.Item item : pick.getItems()) {
                            if (!item.isSelected()) continue;
                            selectedIds.add(item.getLabel());
                        }
                        if (selectedIds.isEmpty()) {
                            return null;
                        }
                        JavaSource js = JavaSource.forFileObject((FileObject)fo);
                        if (js == null) {
                            throw new IOException("Cannot get JavaSource for: " + fo.toURL().toString());
                        }
                        return MicronautDataEndpointGenerator.modify2Edit(js, MicronautDataEndpointGenerator.getTask(offset, repositoryHandles, selectedIds));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return null;
                    }
                }));
            }
        }
        catch (IOException | ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    private static Task<WorkingCopy> getTask(int offset, List<ElementHandle<VariableElement>> repositoryHandles, List<String> endpointIds) {
        return copy -> {
            copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePath tp = copy.getTreeUtilities().pathFor(offset);
            tp = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                ClassTree clazz = (ClassTree)tp.getLeaf();
                ArrayList<MethodTree> members = new ArrayList<MethodTree>();
                for (ElementHandle repositoryHandle : repositoryHandles) {
                    TypeMirror repositoryType;
                    VariableElement repository = (VariableElement)repositoryHandle.resolve((CompilationInfo)copy);
                    if (repository == null || (repositoryType = repository.asType()).getKind() != TypeKind.DECLARED) continue;
                    TypeElement repositoryTypeElement = (TypeElement)((DeclaredType)repositoryType).asElement();
                    String id = null;
                    if (repositoryHandles.size() > 1 && (id = '/' + repositoryTypeElement.getSimpleName().toString().toLowerCase()).endsWith("repository")) {
                        id = id.substring(0, id.length() - 10);
                    }
                    for (String endpointId : endpointIds) {
                        String delegateMethodName = null;
                        if (endpointId.equals(id != null ? id + "/ -- GET" : "/ -- GET")) {
                            delegateMethodName = "findAll";
                        } else if (endpointId.equals(id != null ? id + "/{id} -- GET" : "/{id} -- GET")) {
                            delegateMethodName = "findById";
                        } else if (endpointId.equals(id != null ? id + "/{id} -- DELETE" : "/{id} -- DELETE")) {
                            delegateMethodName = "deleteById";
                        }
                        if (delegateMethodName == null) continue;
                        members.add(Utils.createControllerDataEndpointMethod(copy, repositoryTypeElement, repository.getSimpleName().toString(), delegateMethodName, id));
                    }
                }
                copy.rewrite((Tree)clazz, (Tree)GeneratorUtilities.get((WorkingCopy)copy).insertClassMembers(clazz, members, offset));
            }
        };
    }

    private static WorkspaceEdit modify2Edit(JavaSource js, Task<WorkingCopy> task) throws IOException {
        FileObject[] file = new FileObject[1];
        ModificationResult changes = js.runModificationTask(wc -> {
            task.run(wc);
            file[0] = wc.getFileObject();
        });
        List diffs = changes.getDifferences(file[0]);
        if (diffs != null) {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            for (ModificationResult.Difference diff : diffs) {
                edits.add(new TextEdit(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset(), diff.getNewText()));
            }
            return new WorkspaceEdit(Collections.singletonList(Union2.createFirst((Object)new TextDocumentEdit(file[0].toURI().toString(), edits))));
        }
        return null;
    }

    private static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[]{new JButton(Bundle.LBL_GenerateButton()), new JButton(Bundle.LBL_CancelButton())};
        DialogDescriptor dd = new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
        dd.addPropertyChangeListener(arg_0 -> MicronautDataEndpointGenerator.lambda$createDialogDescriptor$6((JButton[])buttons, dd, arg_0));
        return dd;
    }

    private static /* synthetic */ void lambda$createDialogDescriptor$6(JButton[] buttons, DialogDescriptor dd, PropertyChangeEvent evt) {
        if ("valid".equals(evt.getPropertyName())) {
            buttons[0].setEnabled(dd.isValid());
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<1> ret = new ArrayList<1>();
            JTextComponent comp = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController cc = (CompilationController)context.lookup(CompilationController.class);
            if (comp == null || cc == null) {
                return ret;
            }
            TreePath path = (TreePath)context.lookup(TreePath.class);
            path = cc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return ret;
            }
            try {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            TypeElement te = (TypeElement)cc.getTrees().getElement(path);
            if (te == null || !te.getKind().isClass()) {
                return ret;
            }
            AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), MicronautDataEndpointGenerator.CONTROLLER_ANNOTATION_NAME);
            if (controllerAnn == null) {
                return Collections.emptyList();
            }
            List<VariableElement> repositories = Utils.getRepositoriesFor((CompilationInfo)cc, te);
            if (repositories.isEmpty()) {
                return Collections.emptyList();
            }
            final ArrayList endpoints = new ArrayList();
            Utils.collectMissingDataEndpoints((CompilationInfo)cc, te, null, (repository, delegateMethod, id) -> {
                switch (delegateMethod.getSimpleName().toString()) {
                    case "findAll": {
                        endpoints.add(id != null ? id + "/ -- GET" : "/ -- GET");
                        break;
                    }
                    case "findById": {
                        endpoints.add(id != null ? id + "/{id} -- GET" : "/{id} -- GET");
                        break;
                    }
                    case "deleteById": {
                        endpoints.add(id != null ? id + "/{id} -- DELETE" : "/{id} -- DELETE");
                    }
                }
            });
            if (!endpoints.isEmpty()) {
                final int offset = comp.getCaretPosition();
                final FileObject fo = cc.getFileObject();
                final List repositoryHandles = repositories.stream().map(repository -> ElementHandle.create((Element)repository)).collect(Collectors.toList());
                ret.add(new CodeGenerator(){

                    public String getDisplayName() {
                        return Bundle.DN_DataEndpoint();
                    }

                    public void invoke() {
                        EndpointSelectorPanel panel = new EndpointSelectorPanel(endpoints);
                        DialogDescriptor dialogDescriptor = MicronautDataEndpointGenerator.createDialogDescriptor(panel, Bundle.LBL_GenerateDataEndpoint());
                        panel.addPropertyChangeListener(evt -> {
                            List<String> selected = panel.getSelectedEndpoints();
                            dialogDescriptor.setValid(selected != null && !selected.isEmpty());
                        });
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                        if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                            return;
                        }
                        List<String> selectedEndpoints = panel.getSelectedEndpoints();
                        if (selectedEndpoints.isEmpty()) {
                            return;
                        }
                        try {
                            JavaSource js = JavaSource.forFileObject((FileObject)fo);
                            if (js == null) {
                                throw new IOException("Cannot get JavaSource for: " + fo.toURL().toString());
                            }
                            js.runModificationTask(MicronautDataEndpointGenerator.getTask(offset, repositoryHandles, selectedEndpoints)).commit();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            return ret;
        }
    }
}

