/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.database;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.DatabaseConnectionStringProfile;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.database.Bundle;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class DatabaseNode
extends OCINode {
    private static final String DB_ICON = "org/netbeans/modules/cloud/oracle/resources/database.svg";
    private static final String SERVICE_CONSOLE_SUFFIX = "admin/_sdw/";

    public DatabaseNode(DatabaseItem dbSummary) {
        super((OCIItem)dbSummary, Children.LEAF);
        this.setName(dbSummary.getName());
        this.setDisplayName(dbSummary.getName());
        this.setIconBaseWithExtension(DB_ICON);
        this.setShortDescription(dbSummary.getDescription());
    }

    public static NodeProvider<DatabaseItem> createNode() {
        return DatabaseNode::new;
    }

    public static ChildrenProvider<CompartmentItem, DatabaseItem> getDatabases() {
        return compartmentId -> {
            DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());
            ListAutonomousDatabasesRequest listAutonomousDatabasesRequest = ListAutonomousDatabasesRequest.builder().compartmentId(compartmentId.getKey().getValue()).limit(Integer.valueOf(88)).build();
            return client.listAutonomousDatabases(listAutonomousDatabasesRequest).getItems().stream().map(d -> {
                List profiles = d.getConnectionStrings().getProfiles();
                DatabaseItem item = new DatabaseItem(OCID.of(d.getId(), "Databases"), d.getDbName(), d.getConnectionUrls().getOrdsUrl() + SERVICE_CONSOLE_SUFFIX, DatabaseNode.getConnectionName(profiles));
                StringBuilder sb = new StringBuilder();
                sb.append(Bundle.LBL_WorkloadType(d.getDbWorkload().getValue()));
                sb.append(Bundle.LBL_DatabaseVersion(d.getDbVersion()));
                sb.append(Bundle.LBL_Storage(d.getDataStorageSizeInTBs()));
                item.setDescription(sb.toString());
                return item;
            }).collect(Collectors.toList());
        };
    }

    private static String getConnectionName(List<DatabaseConnectionStringProfile> profiles) {
        if (profiles != null && !profiles.isEmpty()) {
            for (DatabaseConnectionStringProfile profile : profiles) {
                if (!profile.getDisplayName().contains("high")) continue;
                return profile.getDisplayName();
            }
            return profiles.get(0).getDisplayName();
        }
        return null;
    }
}

