/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.xml.retriever.impl.CertificationPanel;
import org.netbeans.modules.xml.retriever.impl.URLResourceRetriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SecureURLResourceRetriever
extends URLResourceRetriever {
    private static Set<X509Certificate> acceptedCertificates;
    private static final String URI_SCHEME = "https";
    private static final KeyStore DEFAULT_TRUST_STORE;

    @Override
    public boolean accept(String baseAddr, String currentAddr) throws URISyntaxException {
        URI baseURI;
        URI currURI = new URI(currentAddr);
        if (currURI.isAbsolute() && currURI.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return baseAddr != null && (baseURI = new URI(baseAddr)).getScheme().equalsIgnoreCase(URI_SCHEME);
    }

    @Override
    public Map<String, InputStream> retrieveDocument(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        String effAddr = this.getEffectiveAddress(baseAddress, documentAddress);
        if (effAddr == null) {
            return null;
        }
        URI currURI = new URI(effAddr);
        HashMap<String, InputStream> result = null;
        if (acceptedCertificates == null) {
            acceptedCertificates = new HashSet<X509Certificate>();
        }
        InputStream is = this.getInputStreamOfURL(currURI.toURL(), ProxySelector.getDefault().select(currURI).get(0));
        result = new HashMap<String, InputStream>();
        result.put(this.effectiveURL.toString(), is);
        return result;
    }

    @Override
    protected void configureURLConnection(URLConnection ucn) {
        super.configureURLConnection(ucn);
        if (ucn instanceof HttpsURLConnection) {
            this.setRetrieverTrustManager((HttpsURLConnection)ucn);
        }
    }

    private void setRetrieverTrustManager(HttpsURLConnection con) {
        TrustManager[] defaultTrustManagers;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(DEFAULT_TRUST_STORE);
            defaultTrustManagers = tmf.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            defaultTrustManagers = new TrustManager[]{};
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        if (acceptedCertificates.contains(certs[i])) continue;
                        DialogDescriptor desc = new DialogDescriptor((Object)new CertificationPanel(certs[i]), NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (DialogDescriptor.YES_OPTION.equals(desc.getValue())) {
                            acceptedCertificates.add(certs[i]);
                            continue;
                        }
                        throw new CertificateException(NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        TrustManager[] combinedTrustManagers = (TrustManager[])Stream.of(defaultTrustManagers, trustAllCerts).flatMap(Stream::of).toArray(TrustManager[]::new);
        KeyManager[] keyManagersFromSystemProperties = null;
        try {
            File keyStoreFile;
            KeyStore keyStoreFromSystemProperties = null;
            char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray();
            if (System.getProperty("javax.net.ssl.keyStore") != null && (keyStoreFile = new File(System.getProperty("javax.net.ssl.keyStore"))).exists()) {
                KeyStore keyStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
                    keyStore.load(keyStoreStream, keyStorePassword);
                }
                keyStoreFromSystemProperties = keyStore;
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStoreFromSystemProperties, keyStorePassword);
            keyManagersFromSystemProperties = keyManagerFactory.getKeyManagers();
        }
        catch (IOException | GeneralSecurityException ex) {
            keyManagersFromSystemProperties = new KeyManager[]{};
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagersFromSystemProperties, combinedTrustManagers, new SecureRandom());
            con.setSSLSocketFactory(sslContext.getSocketFactory());
            con.setHostnameVerifier(this::acceptAllHosts);
        }
        catch (GeneralSecurityException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private boolean acceptAllHosts(String host, SSLSession sslSession) {
        return true;
    }

    @Override
    public String getEffectiveAddress(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        URI currURI = new URI(documentAddress);
        String result = null;
        if (currURI.isAbsolute()) {
            result = currURI.toString();
            return result;
        }
        if (baseAddress != null) {
            URI baseURI = new URI(baseAddress);
            URI finalURI = baseURI.resolve(currURI);
            result = finalURI.toString();
            return result;
        }
        return null;
    }

    static {
        DEFAULT_TRUST_STORE = null;
    }
}

