/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.generator;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.generator.EitherTypeArgument;
import org.eclipse.lsp4j.generator.JsonType;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceBuildContext;
import org.eclipse.xtend.lib.macro.services.Problem;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JsonRpcDataTransformationContext
implements TransformationContext {
    @Delegate
    private final TransformationContext delegate;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final TypeReference eitherType;

    public JsonRpcDataTransformationContext(TransformationContext delegate) {
        this.delegate = delegate;
        this.eitherType = this.newTypeReference(Either.class, new TypeReference[0]);
    }

    public boolean isEither(TypeReference typeReference) {
        return typeReference != null && this.eitherType.isAssignableFrom(typeReference);
    }

    public TypeReference getLeftType(TypeReference typeReference) {
        Type _type;
        boolean _tripleEquals;
        Type type = typeReference.getType();
        boolean bl = _tripleEquals = type == (_type = this.eitherType.getType());
        if (_tripleEquals) {
            return (TypeReference)IterableExtensions.head((Iterable)typeReference.getActualTypeArguments());
        }
        if (type instanceof InterfaceDeclaration) {
            Functions.Function1 _function = it -> this.getLeftType((TypeReference)it);
            return (TypeReference)IterableExtensions.head((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)((InterfaceDeclaration)type).getExtendedInterfaces(), (Functions.Function1)_function)));
        }
        return null;
    }

    public TypeReference getRightType(TypeReference typeReference) {
        Type _type;
        boolean _tripleEquals;
        Type type = typeReference.getType();
        boolean bl = _tripleEquals = type == (_type = this.eitherType.getType());
        if (_tripleEquals) {
            return (TypeReference)IterableExtensions.last((Iterable)typeReference.getActualTypeArguments());
        }
        if (type instanceof InterfaceDeclaration) {
            Functions.Function1 _function = it -> this.getRightType((TypeReference)it);
            return (TypeReference)IterableExtensions.head((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)((InterfaceDeclaration)type).getExtendedInterfaces(), (Functions.Function1)_function)));
        }
        return null;
    }

    public Collection<EitherTypeArgument> getChildTypes(TypeReference typeReference) {
        ArrayList types = CollectionLiterals.newArrayList();
        boolean _isEither = this.isEither(typeReference);
        if (_isEither) {
            this.collectChildTypes(this.getLeftType(typeReference), null, false, types);
            this.collectChildTypes(this.getRightType(typeReference), null, true, types);
        }
        return types;
    }

    protected void collectChildTypes(TypeReference type, EitherTypeArgument parent, boolean right, Collection<EitherTypeArgument> types) {
        EitherTypeArgument argument = new EitherTypeArgument(type, parent, right);
        boolean _isEither = this.isEither(type);
        if (_isEither) {
            this.collectChildTypes(this.getLeftType(type), argument, false, types);
            this.collectChildTypes(this.getRightType(type), argument, true, types);
        } else if (type != null) {
            types.add(argument);
        }
    }

    public boolean isJsonNull(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.NULL;
    }

    public boolean isJsonString(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.STRING;
    }

    public boolean isJsonNumber(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.NUMBER;
    }

    public boolean isJsonBoolean(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.BOOLEAN;
    }

    public boolean isJsonArray(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.ARRAY;
    }

    public boolean isJsonObject(TypeReference type) {
        JsonType _jsonType = this.getJsonType(type);
        return _jsonType == JsonType.OBJECT;
    }

    public JsonType getJsonType(TypeReference type) {
        boolean _not;
        if (type == null) {
            return JsonType.NULL;
        }
        if (type.isArray() || this.newTypeReference(List.class, new TypeReference[0]).isAssignableFrom(type)) {
            return JsonType.ARRAY;
        }
        if (this.newTypeReference(Enum.class, new TypeReference[0]).isAssignableFrom(type) || this.newTypeReference(Number.class, new TypeReference[0]).isAssignableFrom(type)) {
            return JsonType.NUMBER;
        }
        boolean _isAssignableFrom = this.newTypeReference(Boolean.class, new TypeReference[0]).isAssignableFrom(type);
        if (_isAssignableFrom) {
            return JsonType.BOOLEAN;
        }
        if (this.newTypeReference(String.class, new TypeReference[0]).isAssignableFrom(type) || this.newTypeReference(Character.class, new TypeReference[0]).isAssignableFrom(type)) {
            return JsonType.STRING;
        }
        boolean _isPrimitive = type.isPrimitive();
        boolean bl = _not = !_isPrimitive;
        if (_not) {
            return JsonType.OBJECT;
        }
        throw new IllegalStateException("Unexpected type reference: " + type);
    }

    public void addError(Element arg0, String arg1) {
        this.delegate.addError(arg0, arg1);
    }

    public void addWarning(Element arg0, String arg1) {
        this.delegate.addWarning(arg0, arg1);
    }

    public boolean exists(Path arg0) {
        return this.delegate.exists(arg0);
    }

    public MutableAnnotationTypeDeclaration findAnnotationType(String arg0) {
        return this.delegate.findAnnotationType(arg0);
    }

    public MutableClassDeclaration findClass(String arg0) {
        return this.delegate.findClass(arg0);
    }

    public MutableEnumerationTypeDeclaration findEnumerationType(String arg0) {
        return this.delegate.findEnumerationType(arg0);
    }

    public MutableInterfaceDeclaration findInterface(String arg0) {
        return this.delegate.findInterface(arg0);
    }

    public Type findTypeGlobally(Class<?> arg0) {
        return this.delegate.findTypeGlobally(arg0);
    }

    public Type findTypeGlobally(String arg0) {
        return this.delegate.findTypeGlobally(arg0);
    }

    public TypeReference getAnyType() {
        return this.delegate.getAnyType();
    }

    public String getCharset(Path arg0) {
        return this.delegate.getCharset(arg0);
    }

    public Iterable<? extends Path> getChildren(Path arg0) {
        return this.delegate.getChildren(arg0);
    }

    public CharSequence getContents(Path arg0) {
        return this.delegate.getContents(arg0);
    }

    public InputStream getContentsAsStream(Path arg0) {
        return this.delegate.getContentsAsStream(arg0);
    }

    public long getLastModification(Path arg0) {
        return this.delegate.getLastModification(arg0);
    }

    public TypeReference getList(TypeReference arg0) {
        return this.delegate.getList(arg0);
    }

    public TypeReference getObject() {
        return this.delegate.getObject();
    }

    public Element getPrimaryGeneratedJavaElement(Element arg0) {
        return this.delegate.getPrimaryGeneratedJavaElement(arg0);
    }

    public Element getPrimarySourceElement(Element arg0) {
        return this.delegate.getPrimarySourceElement(arg0);
    }

    public TypeReference getPrimitiveBoolean() {
        return this.delegate.getPrimitiveBoolean();
    }

    public TypeReference getPrimitiveByte() {
        return this.delegate.getPrimitiveByte();
    }

    public TypeReference getPrimitiveChar() {
        return this.delegate.getPrimitiveChar();
    }

    public TypeReference getPrimitiveDouble() {
        return this.delegate.getPrimitiveDouble();
    }

    public TypeReference getPrimitiveFloat() {
        return this.delegate.getPrimitiveFloat();
    }

    public TypeReference getPrimitiveInt() {
        return this.delegate.getPrimitiveInt();
    }

    public TypeReference getPrimitiveLong() {
        return this.delegate.getPrimitiveLong();
    }

    public TypeReference getPrimitiveShort() {
        return this.delegate.getPrimitiveShort();
    }

    public TypeReference getPrimitiveVoid() {
        return this.delegate.getPrimitiveVoid();
    }

    public List<? extends Problem> getProblems(Element arg0) {
        return this.delegate.getProblems(arg0);
    }

    public Path getProjectFolder(Path arg0) {
        return this.delegate.getProjectFolder(arg0);
    }

    public Set<Path> getProjectSourceFolders(Path arg0) {
        return this.delegate.getProjectSourceFolders(arg0);
    }

    public TypeReference getSet(TypeReference arg0) {
        return this.delegate.getSet(arg0);
    }

    public Path getSourceFolder(Path arg0) {
        return this.delegate.getSourceFolder(arg0);
    }

    public TypeReference getString() {
        return this.delegate.getString();
    }

    public Path getTargetFolder(Path arg0) {
        return this.delegate.getTargetFolder(arg0);
    }

    public boolean isExternal(Element arg0) {
        return this.delegate.isExternal(arg0);
    }

    public boolean isFile(Path arg0) {
        return this.delegate.isFile(arg0);
    }

    public boolean isFolder(Path arg0) {
        return this.delegate.isFolder(arg0);
    }

    public boolean isGenerated(Element arg0) {
        return this.delegate.isGenerated(arg0);
    }

    public boolean isSource(Element arg0) {
        return this.delegate.isSource(arg0);
    }

    public boolean isThePrimaryGeneratedJavaElement(Element arg0) {
        return this.delegate.isThePrimaryGeneratedJavaElement(arg0);
    }

    public AnnotationReference newAnnotationReference(AnnotationReference arg0) {
        return this.delegate.newAnnotationReference(arg0);
    }

    public AnnotationReference newAnnotationReference(AnnotationReference arg0, Procedures.Procedure1<AnnotationReferenceBuildContext> arg1) {
        return this.delegate.newAnnotationReference(arg0, arg1);
    }

    public AnnotationReference newAnnotationReference(Class<?> arg0) {
        return this.delegate.newAnnotationReference(arg0);
    }

    public AnnotationReference newAnnotationReference(Class<?> arg0, Procedures.Procedure1<AnnotationReferenceBuildContext> arg1) {
        return this.delegate.newAnnotationReference(arg0, arg1);
    }

    public AnnotationReference newAnnotationReference(String arg0) {
        return this.delegate.newAnnotationReference(arg0);
    }

    public AnnotationReference newAnnotationReference(String arg0, Procedures.Procedure1<AnnotationReferenceBuildContext> arg1) {
        return this.delegate.newAnnotationReference(arg0, arg1);
    }

    public AnnotationReference newAnnotationReference(Type arg0) {
        return this.delegate.newAnnotationReference(arg0);
    }

    public AnnotationReference newAnnotationReference(Type arg0, Procedures.Procedure1<AnnotationReferenceBuildContext> arg1) {
        return this.delegate.newAnnotationReference(arg0, arg1);
    }

    public TypeReference newArrayTypeReference(TypeReference arg0) {
        return this.delegate.newArrayTypeReference(arg0);
    }

    public TypeReference newSelfTypeReference(Type arg0) {
        return this.delegate.newSelfTypeReference(arg0);
    }

    public TypeReference newTypeReference(Class<?> arg0, TypeReference ... arg1) {
        return this.delegate.newTypeReference(arg0, arg1);
    }

    public TypeReference newTypeReference(String arg0, TypeReference ... arg1) {
        return this.delegate.newTypeReference(arg0, arg1);
    }

    public TypeReference newTypeReference(Type arg0, TypeReference ... arg1) {
        return this.delegate.newTypeReference(arg0, arg1);
    }

    public TypeReference newWildcardTypeReference() {
        return this.delegate.newWildcardTypeReference();
    }

    public TypeReference newWildcardTypeReference(TypeReference arg0) {
        return this.delegate.newWildcardTypeReference(arg0);
    }

    public TypeReference newWildcardTypeReferenceWithLowerBound(TypeReference arg0) {
        return this.delegate.newWildcardTypeReferenceWithLowerBound(arg0);
    }

    public void setPrimarySourceElement(MutableElement arg0, Element arg1) {
        this.delegate.setPrimarySourceElement(arg0, arg1);
    }

    public URI toURI(Path arg0) {
        return this.delegate.toURI(arg0);
    }

    public void validateLater(Procedures.Procedure0 arg0) {
        this.delegate.validateLater(arg0);
    }

    @Pure
    public TypeReference getEitherType() {
        return this.eitherType;
    }
}

