/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum OperatingSystem implements Api
{
    ALPINE_LINUX("Alpine Linux", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, LINUX_MUSL);
        }
    }
    ,
    LINUX("Linux", "linux", LibCType.GLIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    LINUX_MUSL("Linux Musl", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, ALPINE_LINUX);
        }
    }
    ,
    MACOS("Mac OS", "macos", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    WINDOWS("Windows", "windows", LibCType.C_STD_LIB){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    SOLARIS("Solaris", "solaris", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    QNX("QNX", "qnx", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    AIX("AIX", "aix", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NONE("-", "", LibCType.NONE){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NOT_FOUND("", "", LibCType.NOT_FOUND){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    };

    private final String uiString;
    private final String apiString;
    private final LibCType libCType;

    private OperatingSystem(String uiString, String apiString, LibCType libCType) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.libCType = libCType;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public OperatingSystem getDefault() {
        return NONE;
    }

    @Override
    public OperatingSystem getNotFound() {
        return NOT_FOUND;
    }

    public OperatingSystem[] getAll() {
        return OperatingSystem.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static OperatingSystem fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "-linux": 
            case "linux": 
            case "Linux": 
            case "LINUX": 
            case "unix": 
            case "UNIX": 
            case "Unix": 
            case "-unix": {
                return LINUX;
            }
            case "-linux-musl": 
            case "-linux_musl": 
            case "Linux-Musl": 
            case "linux-musl": 
            case "Linux_Musl": 
            case "LINUX_MUSL": 
            case "linux_musl": 
            case "alpine": 
            case "ALPINE": 
            case "Alpine": 
            case "alpine-linux": 
            case "ALPINE-LINUX": 
            case "alpine_linux": 
            case "Alpine_Linux": 
            case "ALPINE_LINUX": 
            case "Alpine Linux": 
            case "alpine linux": 
            case "ALPINE LINUX": {
                return ALPINE_LINUX;
            }
            case "-solaris": 
            case "solaris": 
            case "SOLARIS": 
            case "Solaris": {
                return SOLARIS;
            }
            case "-qnx": 
            case "qnx": 
            case "QNX": {
                return QNX;
            }
            case "-aix": 
            case "aix": 
            case "AIX": {
                return AIX;
            }
            case "darwin": 
            case "-darwin": 
            case "-macosx": 
            case "-MACOSX": 
            case "MacOS": 
            case "Mac OS": 
            case "mac_os": 
            case "Mac_OS": 
            case "mac-os": 
            case "Mac-OS": 
            case "mac": 
            case "MAC": 
            case "macos": 
            case "MACOS": 
            case "osx": 
            case "OSX": 
            case "macosx": 
            case "MACOSX": 
            case "Mac OSX": 
            case "mac osx": {
                return MACOS;
            }
            case "-win": 
            case "windows": 
            case "Windows": 
            case "WINDOWS": 
            case "win": 
            case "Win": 
            case "WIN": {
                return WINDOWS;
            }
        }
        return NOT_FOUND;
    }

    public LibCType getLibCType() {
        return this.libCType;
    }

    public static List<OperatingSystem> getAsList() {
        return Arrays.asList(OperatingSystem.values());
    }

    public abstract List<OperatingSystem> getSynonyms();
}

