/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.ClassesSelectorPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MicronautController
implements TemplateWizard.Iterator {
    private WizardDescriptor.Panel panel;
    private WizardDescriptor wizardDescriptor;
    private FileObject targetFolder;
    private final boolean fromRepository;

    public static TemplateWizard.Iterator create() {
        return new MicronautController(false);
    }

    public static TemplateWizard.Iterator createFromReposiory() {
        return new MicronautController(true);
    }

    public static CreateFromTemplateHandler handler() {
        return MicronautController.handler(false);
    }

    public static CreateFromTemplateHandler fromReposioryHandler() {
        return MicronautController.handler(true);
    }

    private MicronautController(boolean fromRepository) {
        this.fromRepository = fromRepository;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        HashSet<DataObject> generated = new HashSet<DataObject>();
        if (this.fromRepository) {
            Map selectedRepositories = (Map)wiz.getProperty("wizard-selected-classes");
            for (String fqn : selectedRepositories.keySet()) {
                FileObject fo;
                String label;
                int idx = fqn.lastIndexOf(46);
                String string = label = idx < 0 ? fqn : fqn.substring(idx + 1);
                if (label.toLowerCase().endsWith("repository")) {
                    label = label.substring(0, label.length() - 10);
                }
                if ((fo = MicronautController.generate(this.targetFolder, label, fqn)) == null) continue;
                generated.add(DataObject.find((FileObject)fo));
            }
        } else {
            FileObject fo;
            String targetName = Templates.getTargetName((WizardDescriptor)wiz);
            if (targetName != null && !targetName.isEmpty() && (fo = MicronautController.generate(this.targetFolder, targetName, null)) != null) {
                generated.add(DataObject.find((FileObject)fo));
            }
        }
        return generated;
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (this.fromRepository) {
            Set<ElementHandle<TypeElement>> repositoryClasses;
            this.panel = new ClassesSelectorPanel.WizardPanel(NbBundle.getMessage(MicronautController.class, (String)"Templates/Micronaut/Controller"), "Repositories", selectedRepositories -> selectedRepositories.isEmpty() ? NbBundle.getMessage(MicronautController.class, (String)"ERR_SelectRepositories") : null);
            SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)this.targetFolder);
            if (sourceGroup != null && !(repositoryClasses = MicronautController.getRepositoryClasses(sourceGroup)).isEmpty()) {
                HashMap<String, ElementHandle<TypeElement>> repositories = new HashMap<String, ElementHandle<TypeElement>>();
                for (ElementHandle<TypeElement> handle : repositoryClasses) {
                    repositories.put(handle.getQualifiedName(), handle);
                }
                wiz.putProperty("wizard-classes", repositories);
            }
        } else if (sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
            this.panel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create();
        } else {
            this.panel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups);
        }
        Wizards.mergeSteps((WizardDescriptor)wiz, (WizardDescriptor.Panel[])new WizardDescriptor.Panel[]{this.panel}, null);
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static CreateFromTemplateHandler handler(final boolean fromRepository) {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                try {
                    FileObject folder = desc.getTarget();
                    Project project = FileOwnerQuery.getOwner((FileObject)folder);
                    if (project == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoProject(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    if (fromRepository) {
                        SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)folder);
                        if (sourceGroup == null) {
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoSourceGroup(folder.getPath()), 0));
                            return Collections.emptyList();
                        }
                        Set repositoryClasses = MicronautController.getRepositoryClasses(sourceGroup);
                        if (repositoryClasses.isEmpty()) {
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoRepositories(sourceGroup.getRootFolder().getPath()), 0));
                            return Collections.emptyList();
                        }
                        List items = repositoryClasses.stream().map(handle -> {
                            String fqn = handle.getQualifiedName();
                            int idx = fqn.lastIndexOf(46);
                            return idx < 0 ? new NotifyDescriptor.QuickPick.Item(fqn, null) : new NotifyDescriptor.QuickPick.Item(fqn.substring(idx + 1), fqn.substring(0, idx));
                        }).collect(Collectors.toList());
                        NotifyDescriptor.QuickPick qpt = new NotifyDescriptor.QuickPick(Bundle.MSG_SelectRepository(), Bundle.MSG_SelectRepository_Prompt(), items, true);
                        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)qpt)) {
                            ArrayList<FileObject> generated = new ArrayList<FileObject>();
                            for (NotifyDescriptor.QuickPick.Item item : qpt.getItems()) {
                                FileObject fo;
                                if (!item.isSelected()) continue;
                                String label = item.getLabel();
                                if (label.toLowerCase().endsWith("repository")) {
                                    label = label.substring(0, label.length() - 10);
                                }
                                if ((fo = MicronautController.generate(folder, label, item.getDescription() != null ? item.getDescription() + '.' + item.getLabel() : item.getLabel())) == null) continue;
                                generated.add(fo);
                            }
                            return generated;
                        }
                    } else {
                        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Bundle.MSG_SelectControllerName(), Bundle.MSG_SelectControllerName());
                        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) {
                            ArrayList<FileObject> generated = new ArrayList<FileObject>();
                            String name = inputLine.getInputText();
                            if (!name.isEmpty()) {
                                FileObject fo;
                                if (name.toLowerCase().endsWith("controller")) {
                                    name = name.substring(0, name.length() - 10);
                                }
                                if ((fo = MicronautController.generate(desc.getTarget(), name, null)) != null) {
                                    generated.add(fo);
                                }
                            }
                            return generated;
                        }
                    }
                }
                catch (Exception ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                return Collections.emptyList();
            }
        };
    }

    private static Set<ElementHandle<TypeElement>> getRepositoryClasses(SourceGroup sourceGroup) throws IllegalArgumentException {
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)sourceGroup.getRootFolder());
        HashSet<ElementHandle<TypeElement>> repositoryClasses = new HashSet<ElementHandle<TypeElement>>();
        LinkedList<ElementHandle> bases = new LinkedList<ElementHandle>();
        bases.add(ElementHandle.createTypeElementHandle((ElementKind)ElementKind.INTERFACE, (String)"io.micronaut.data.repository.CrudRepository"));
        while (!bases.isEmpty()) {
            ElementHandle base = (ElementHandle)bases.removeFirst();
            bases.addAll(cpInfo.getClassIndex().getElements(base, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES)));
            Set srcElements = cpInfo.getClassIndex().getElements(base, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            bases.addAll(srcElements);
            repositoryClasses.addAll(srcElements);
        }
        return repositoryClasses;
    }

    private static FileObject generate(FileObject folder, String name, String repositoryFQN) {
        try {
            JavaSource js;
            String controllerName = name.substring(0, 1).toUpperCase() + name.substring(1) + "Controller";
            FileObject fo = GenerationUtils.createClass((FileObject)folder, (String)controllerName, (String)Bundle.MSG_ControllerClass(controllerName));
            if (fo != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                js.runModificationTask(copy -> {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    Tree origTree = copy.getCompilationUnit().getTypeDecls().get(0);
                    if (origTree.getKind() == Tree.Kind.CLASS) {
                        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
                        TreeMaker tm = copy.getTreeMaker();
                        String controllerId = "/" + name.toLowerCase();
                        ClassTree cls = gu.addAnnotation((ClassTree)origTree, gu.createAnnotation("io.micronaut.http.annotation.Controller", List.of(tm.Literal((Object)controllerId))));
                        if (repositoryFQN != null) {
                            MethodTree mt;
                            String repositoryFieldName = name.substring(0, 1).toLowerCase() + name.substring(1) + "Repository";
                            VariableTree repositoryField = tm.Variable(tm.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.FINAL)), (CharSequence)repositoryFieldName, (Tree)tm.QualIdent(repositoryFQN), null);
                            cls = tm.addClassMember(cls, (Tree)repositoryField);
                            cls = tm.addClassMember(cls, (Tree)GeneratorUtilities.get((WorkingCopy)copy).createConstructor(cls, Collections.singleton(repositoryField)));
                            TypeElement te = copy.getElements().getTypeElement(repositoryFQN);
                            MethodTree methodTree = mt = te != null ? Utils.createControllerFindAllDataEndpointMethod(copy, te, repositoryFieldName, controllerId, null) : null;
                            if (mt != null) {
                                cls = tm.addClassMember(cls, (Tree)mt);
                            }
                        } else {
                            List<ExpressionTree> getAnnArgs = Arrays.asList(gu.createAnnotationArgument("uri", (Object)"/"), gu.createAnnotationArgument("produces", (Object)"text/plain"));
                            ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(gu.createAnnotation("io.micronaut.http.annotation.Get", getAnnArgs)));
                            MethodTree indexMethod = tm.Method(mods, (CharSequence)"index", (Tree)tm.QualIdent("java.lang.String"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return \"Example Response\";}", null);
                            cls = tm.addClassMember(cls, (Tree)indexMethod);
                        }
                        copy.rewrite(origTree, (Tree)cls);
                    }
                }).commit();
            }
            return fo;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

