/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class NewFileIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 1L;
    private transient WizardDescriptor.Iterator<WizardDescriptor> simpleIterator;
    private transient WizardDescriptor.Panel<WizardDescriptor> panel;
    private transient WizardDescriptor wiz;
    private transient Project currentProject;
    private final transient boolean isFolder;

    private NewFileIterator(boolean isFolderIterator) {
        this.isFolder = isFolderIterator;
    }

    public static NewFileIterator genericFileIterator() {
        return new NewFileIterator(false);
    }

    public static NewFileIterator folderIterator() {
        return new NewFileIterator(true);
    }

    private WizardDescriptor.Iterator<WizardDescriptor> getSimpleIterator() {
        if (this.simpleIterator == null) {
            assert (this.panel != null);
            this.simpleIterator = new WizardDescriptor.ArrayIterator(Collections.singletonList(this.panel));
        }
        return this.simpleIterator;
    }

    private WizardDescriptor.Panel<WizardDescriptor> getPanel(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        if (project == null) {
            FileObject folder = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
            if (folder == null) {
                String home = System.getProperty("user.home");
                if (home != null && new File(home).isDirectory()) {
                    folder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(home)));
                }
                if (folder == null) {
                    folder = FileUtil.toFileObject((File)new File(""));
                }
            }
            final FileObject ffolder = folder;
            SourceGroup sg = new SourceGroup(){

                public FileObject getRootFolder() {
                    return ffolder;
                }

                public String getName() {
                    return "name";
                }

                public String getDisplayName() {
                    return "dname";
                }

                public Icon getIcon(boolean opened) {
                    return null;
                }

                public boolean contains(FileObject file) {
                    return file.equals(ffolder) || FileUtil.isParentOf((FileObject)ffolder, (FileObject)file);
                }

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }
            };
            this.panel = this.isFolder ? new SimpleTargetChooserPanel(project, new SourceGroup[]{sg}, null, true, false) : Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])new SourceGroup[]{sg}).create();
            return this.panel;
        }
        if (!project.equals(this.currentProject) || this.panel == null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            this.panel = this.isFolder ? new SimpleTargetChooserPanel(project, sources.getSourceGroups("generic"), null, true, false) : Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sources.getSourceGroups("generic")).create();
        }
        return this.panel;
    }

    private String[] createSteps(String[] before) {
        assert (this.panel != null);
        if (before == null) {
            before = new String[]{};
        }
        String[] res = new String[before.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - 1 ? before[i] : this.panel.getComponent().getName();
        }
        return res;
    }

    public Set instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = this.isFolder ? FileUtil.createMemoryFileSystem().getRoot() : Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wiz));
        return Collections.singleton(dobj.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wiz) {
        this.panel = this.getPanel(wiz);
        this.wiz = wiz;
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < 1; ++i) {
            Component c = this.panel.getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.simpleIterator = null;
        this.wiz = null;
        this.panel = null;
    }

    public String name() {
        return this.getSimpleIterator().name();
    }

    public boolean hasNext() {
        return this.getSimpleIterator().hasNext();
    }

    public boolean hasPrevious() {
        return this.getSimpleIterator().hasPrevious();
    }

    public void nextPanel() {
        this.getSimpleIterator().nextPanel();
    }

    public void previousPanel() {
        this.getSimpleIterator().previousPanel();
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getSimpleIterator().current();
    }

    public final void addChangeListener(ChangeListener l) {
        this.getSimpleIterator().addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.getSimpleIterator().removeChangeListener(l);
    }
}

