/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.utils.helper.swing.NbiDirectoryChooser;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiList;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiScrollPane;
import org.netbeans.installer.utils.helper.swing.NbiTextField;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public abstract class ApplicationLocationPanel
extends ErrorMessagePanel {
    public static final String LOCATION_LABEL_TEXT_PROPERTY = "location.label.text";
    public static final String LOCATION_BUTTON_TEXT_PROPERTY = "location.button.text";
    public static final String LIST_LABEL_TEXT_PROPERTY = "list.label.text";
    public static final String DEFAULT_LOCATION_LABEL_TEXT = ResourceUtils.getString(ApplicationLocationPanel.class, "ALP.location.label.text");
    public static final String DEFAULT_LOCATION_BUTTON_TEXT = ResourceUtils.getString(ApplicationLocationPanel.class, "ALP.location.button.text");
    public static final String DEFAULT_LIST_LABEL_TEXT = ResourceUtils.getString(ApplicationLocationPanel.class, "ALP.list.label.text");
    public static final String ERROR_NOTHING_FOUND_PROPERTY = "error.nothing.found";
    public static final String DEFAULT_ERROR_NOTHING_FOUND = ResourceUtils.getString(ApplicationLocationPanel.class, "ALP.error.nothing.found");
    public static final String DEFAULT_LOCATION = ResourceUtils.getString(ApplicationLocationPanel.class, "ALP.default.location");

    public ApplicationLocationPanel() {
        this.setProperty(LOCATION_LABEL_TEXT_PROPERTY, DEFAULT_LOCATION_LABEL_TEXT);
        this.setProperty(LOCATION_BUTTON_TEXT_PROPERTY, DEFAULT_LOCATION_BUTTON_TEXT);
        this.setProperty(LIST_LABEL_TEXT_PROPERTY, DEFAULT_LIST_LABEL_TEXT);
        this.setProperty(ERROR_NOTHING_FOUND_PROPERTY, DEFAULT_ERROR_NOTHING_FOUND);
    }

    public abstract List<File> getLocations();

    public abstract List<String> getLabels();

    public abstract File getSelectedLocation();

    public abstract String validateLocation(String var1);

    public abstract void setLocation(File var1);

    @Override
    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new ApplicationLocationPanelUi(this);
        }
        return this.wizardUi;
    }

    public static class ApplicationLocationPanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        protected ApplicationLocationPanel component;

        public ApplicationLocationPanelUi(ApplicationLocationPanel component) {
            super(component);
            this.component = component;
        }

        @Override
        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new ApplicationLocationPanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }

    public static interface LocationValidator {
        public void validate(String var1);
    }

    public static class LocationsComboBoxModel
    implements ComboBoxModel {
        private List<ListDataListener> listeners;
        private List<String> locations = new LinkedList<String>();
        private List<String> labels;
        private String selectedItem;
        private boolean selectedItemFromList;

        public LocationsComboBoxModel(List<File> locations, List<String> labels) {
            for (File file : locations) {
                this.locations.add(file.toString());
            }
            this.labels = new LinkedList<String>();
            this.labels.addAll(labels);
            this.listeners = new LinkedList<ListDataListener>();
            if (labels.size() > 0) {
                this.selectedItem = labels.get(0);
                this.selectedItemFromList = true;
            } else {
                this.selectedItem = "";
                this.selectedItemFromList = false;
            }
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public List<String> getLocations() {
            return this.locations;
        }

        public String getLocation() {
            if (this.selectedItemFromList) {
                return this.locations.get(this.labels.indexOf(this.selectedItem));
            }
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selectedItem = (String)item;
            this.selectedItemFromList = this.labels.indexOf(item) != -1;
            this.fireContentsChanged(-1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.labels.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.labels.get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener listener) {
            List<ListDataListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener listener) {
            List<ListDataListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireContentsChanged(int index) {
            ListDataListener[] clone;
            List<ListDataListener> list = this.listeners;
            synchronized (list) {
                clone = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
            }
            ListDataEvent event = new ListDataEvent(this, 0, index, index);
            for (ListDataListener listener : clone) {
                listener.contentsChanged(event);
            }
        }
    }

    public static class LocationsComboBoxEditor
    implements ComboBoxEditor {
        private NbiTextField textField;
        private LocationValidator validator;
        private LocationsComboBoxModel model;

        public LocationsComboBoxEditor(LocationValidator validator) {
            this.validator = validator;
            this.textField = new NbiTextField();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    validator.validate(textField.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    validator.validate(textField.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    validator.validate(textField.getText());
                }
            });
            if (!SystemUtils.isMacOS()) {
                this.textField.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }

        public void setModel(LocationsComboBoxModel model) {
            this.model = model;
        }

        @Override
        public Component getEditorComponent() {
            return this.textField;
        }

        @Override
        public void setItem(Object object) {
            if (object != null) {
                int index = this.model.getLabels().indexOf(object);
                if (index != -1) {
                    this.textField.setText(this.model.getLocations().get(index));
                } else {
                    this.textField.setText(object.toString());
                }
            } else {
                this.textField.setText("");
            }
        }

        @Override
        public Object getItem() {
            String text = this.textField.getText();
            if (this.model == null) {
                return text;
            }
            int index = this.model.getLocations().indexOf(text);
            if (index != -1) {
                return this.model.getLabels().get(index);
            }
            return text;
        }

        @Override
        public void selectAll() {
            this.textField.selectAll();
        }

        @Override
        public void addActionListener(ActionListener listener) {
            this.textField.addActionListener(listener);
        }

        @Override
        public void removeActionListener(ActionListener listener) {
            this.textField.removeActionListener(listener);
        }
    }

    public static class LocationsListModel
    implements ListModel {
        private List<File> locations;
        private List<String> labels;

        public LocationsListModel(List<File> locations, List<String> labels) {
            this.locations = locations;
            this.labels = labels;
        }

        @Override
        public int getSize() {
            return this.locations.size();
        }

        public Object getElementAt(int index) {
            return this.getLabelAt(index);
        }

        public String getLabelAt(int index) {
            return this.labels.get(index);
        }

        public File getLocationAt(int index) {
            return this.locations.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
        }
    }

    public static class LocationsListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocationsListCellRenderer() {
            this.setBorder(new EmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setToolTipText(value.toString());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setOpaque(true);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setOpaque(false);
            }
            return this;
        }
    }

    public static class ApplicationLocationPanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        private ApplicationLocationPanel component;
        private NbiLabel locationLabel;
        private NbiTextField locationField;
        private NbiButton locationButton;
        private NbiLabel locationsLabel;
        private NbiList locationsList;
        private NbiScrollPane locationsScrollPane;
        private NbiPanel locationsListReplacement;
        private NbiDirectoryChooser fileChooser;

        public ApplicationLocationPanelSwingUi(ApplicationLocationPanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.initComponents();
        }

        @Override
        public JComponent getDefaultFocusOwner() {
            return this.locationField;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.locationLabel.setText(this.component.getProperty(ApplicationLocationPanel.LOCATION_LABEL_TEXT_PROPERTY));
            this.locationButton.setText(this.component.getProperty(ApplicationLocationPanel.LOCATION_BUTTON_TEXT_PROPERTY));
            this.locationsLabel.setText(this.component.getProperty(ApplicationLocationPanel.LIST_LABEL_TEXT_PROPERTY));
            LocationsListModel model = new LocationsListModel(this.component.getLocations(), this.component.getLabels());
            this.locationsList.setModel(model);
            File selectedLocation = this.component.getSelectedLocation();
            if (model.getSize() > 0) {
                if (selectedLocation != null) {
                    this.locationField.setText(selectedLocation.getAbsolutePath());
                } else {
                    this.locationField.setText(model.getLocationAt(0).getAbsolutePath());
                }
                this.locationsLabel.setVisible(true);
                this.locationsScrollPane.setVisible(true);
                this.locationsListReplacement.setVisible(false);
            } else {
                if (selectedLocation != null) {
                    this.locationField.setText(selectedLocation.getAbsolutePath());
                } else {
                    this.locationField.setText(SystemUtils.resolvePath(DEFAULT_LOCATION).getAbsolutePath());
                }
                this.locationsLabel.setVisible(false);
                this.locationsScrollPane.setVisible(false);
                this.locationsListReplacement.setVisible(true);
            }
            this.updateErrorMessage();
        }

        @Override
        protected void saveInput() {
            this.component.setLocation(new File(this.locationField.getText().trim()));
        }

        @Override
        protected String validateInput() {
            return this.component.validateLocation(this.locationField.getText().trim());
        }

        private void initComponents() {
            this.locationField = new NbiTextField();
            this.locationField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent event) {
                    this.locationChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent event) {
                    this.locationChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent event) {
                    this.locationChanged();
                }
            });
            this.locationLabel = new NbiLabel();
            this.locationLabel.setLabelFor(this.locationField);
            this.locationButton = new NbiButton();
            this.locationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.browseButtonPressed();
                }
            });
            this.locationsList = new NbiList();
            this.locationsList.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.locationsList.setCellRenderer(new LocationsListCellRenderer());
            this.locationsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        this.listSelectionChanged();
                    }
                }
            });
            this.locationsScrollPane = new NbiScrollPane(this.locationsList);
            this.locationsLabel = new NbiLabel();
            this.locationsLabel.setLabelFor(this.locationsList);
            this.locationsListReplacement = new NbiPanel();
            this.fileChooser = new NbiDirectoryChooser();
            this.add((Component)this.locationLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(7, 11, 0, 11), 0, 0));
            this.add((Component)this.locationField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(4, 11, 0, 4), 0, 0));
            this.add((Component)this.locationButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 0, 0, 11), 0, 0));
            this.add((Component)this.locationsLabel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 21, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.locationsScrollPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 11, 0, 11), 0, 0));
            this.add((Component)this.locationsListReplacement, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 11, 0, 11), 0, 0));
        }

        private void browseButtonPressed() {
            this.fileChooser.setSelectedFile(new File(this.locationField.getText()));
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.locationField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }

        private void listSelectionChanged() {
            String location;
            LocationsListModel model = (LocationsListModel)this.locationsList.getModel();
            int index = this.locationsList.getSelectedIndex();
            if (index != -1 && !(location = model.getLocationAt(index).getAbsolutePath()).equals(this.locationField.getText())) {
                this.locationField.setText(location);
            }
        }

        private void locationChanged() {
            this.updateErrorMessage();
            LocationsListModel model = (LocationsListModel)this.locationsList.getModel();
            String value = this.locationField.getText().trim();
            for (int i = 0; i < model.getSize(); ++i) {
                String element = model.getLocationAt(i).getAbsolutePath();
                if (!value.equals(element)) continue;
                this.locationsList.setSelectedIndex(i);
                return;
            }
            this.locationsList.clearSelection();
        }
    }
}

