/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.netbeans.modules.php.editor.actions.IconsUtils;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.PhpElementKind;

public class ImportData {
    public volatile boolean shouldShowUsesPanel;
    public volatile int caretPosition;
    private final List<DataItem> dataItems = new ArrayList<DataItem>();
    private final List<DataItem> dataItemsToReplace = new ArrayList<DataItem>();

    public void add(DataItem item) {
        this.dataItems.add(item);
    }

    public void addJustToReplace(DataItem item) {
        this.dataItemsToReplace.add(item);
    }

    public List<DataItem> getItems() {
        return new ArrayList<DataItem>(this.dataItems);
    }

    public List<DataItem> getItemsToReplace() {
        return new ArrayList<DataItem>(this.dataItemsToReplace);
    }

    public List<ItemVariant> getDefaultVariants() {
        ArrayList<ItemVariant> result = new ArrayList<ItemVariant>();
        for (DataItem dataItem : this.dataItems) {
            result.add(dataItem.getDefaultVariant());
        }
        return result;
    }

    public static class DataItem {
        private final String typeName;
        private final List<ItemVariant> variants;
        private final ItemVariant defaultVariant;
        private final List<UsedNamespaceName> usedNamespaceNames;

        public DataItem(String typeName, List<ItemVariant> variants, ItemVariant defaultVariant) {
            this(typeName, variants, defaultVariant, Collections.EMPTY_LIST);
        }

        public DataItem(String typeName, List<ItemVariant> variants, ItemVariant defaultVariant, List<UsedNamespaceName> usedNamespaceNames) {
            this.typeName = typeName;
            this.variants = variants;
            this.defaultVariant = defaultVariant;
            this.usedNamespaceNames = usedNamespaceNames;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public List<ItemVariant> getVariants() {
            return new ArrayList<ItemVariant>(this.variants);
        }

        public Icon[] getVariantIcons() {
            Icon[] variantIcons = new Icon[this.variants.size()];
            for (int i = 0; i < this.variants.size(); ++i) {
                ItemVariant itemVariant = this.variants.get(i);
                variantIcons[i] = itemVariant.getIcon();
            }
            return variantIcons;
        }

        public ItemVariant getDefaultVariant() {
            return this.defaultVariant;
        }

        public List<UsedNamespaceName> getUsedNamespaceNames() {
            return new ArrayList<UsedNamespaceName>(this.usedNamespaceNames);
        }

        public void addUsedNamespaceNames(List<UsedNamespaceName> usedNsNames) {
            this.usedNamespaceNames.addAll(usedNsNames);
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.typeName != null ? this.typeName.hashCode() : 0);
            hash = 37 * hash + (this.variants != null ? this.variants.hashCode() : 0);
            hash = 37 * hash + (this.defaultVariant != null ? this.defaultVariant.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataItem other = (DataItem)obj;
            if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
                return false;
            }
            if (!(this.variants == other.variants || this.variants != null && this.variants.equals(other.variants))) {
                return false;
            }
            return !(this.defaultVariant != null ? !this.defaultVariant.equals(other.defaultVariant) : other.defaultVariant != null);
        }
    }

    public static class ItemVariant
    implements Comparable<ItemVariant> {
        private final String name;
        private final UsagePolicy usagePolicy;
        private final Type type;
        private final boolean isFromAliasedElement;

        public ItemVariant(String name, UsagePolicy usagePolicy) {
            this(name, usagePolicy, Type.NONE, false);
        }

        public ItemVariant(String name, UsagePolicy usagePolicy, Type type, boolean isFromAliasedElement) {
            assert (name != null);
            this.name = name;
            this.usagePolicy = usagePolicy;
            this.type = type;
            this.isFromAliasedElement = isFromAliasedElement;
        }

        public ItemVariant(String name, UsagePolicy usagePolicy, PhpElementKind phpElementKind, boolean isFromAliasedElement) {
            this(name, usagePolicy, Type.create(phpElementKind), isFromAliasedElement);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Icon getIcon() {
            return this.type.getIcon();
        }

        public boolean canBeUsed() {
            return this.usagePolicy.canBeUsed();
        }

        public boolean isFromAliasedElement() {
            return this.isFromAliasedElement;
        }

        @Override
        public int compareTo(ItemVariant other) {
            return this.getName().compareToIgnoreCase(other.getName());
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemVariant other = (ItemVariant)obj;
            return Objects.equals(this.name, other.name);
        }

        public static enum Type {
            CONST{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.CONSTANT);
                }
            }
            ,
            FUNCTION{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.FUNCTION);
                }
            }
            ,
            INTERFACE{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.IFACE);
                }
            }
            ,
            CLASS{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.CLASS);
                }
            }
            ,
            TRAIT{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.TRAIT);
                }
            }
            ,
            ENUM{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getElementIcon(PhpElementKind.ENUM);
                }
            }
            ,
            ERROR{

                @Override
                public Icon getIcon() {
                    return IconsUtils.getErrorGlyphIcon();
                }
            }
            ,
            NONE{

                @Override
                public Icon getIcon() {
                    return null;
                }
            };


            public abstract Icon getIcon();

            public static Type create(PhpElementKind phpElementKind) {
                Type result;
                switch (phpElementKind) {
                    case CONSTANT: {
                        result = CONST;
                        break;
                    }
                    case FUNCTION: {
                        result = FUNCTION;
                        break;
                    }
                    case IFACE: {
                        result = INTERFACE;
                        break;
                    }
                    case CLASS: {
                        result = CLASS;
                        break;
                    }
                    case TRAIT: {
                        result = TRAIT;
                        break;
                    }
                    case ENUM: {
                        result = ENUM;
                        break;
                    }
                    default: {
                        result = ERROR;
                    }
                }
                return result;
            }
        }

        public static enum UsagePolicy {
            CAN_BE_USED{

                @Override
                boolean canBeUsed() {
                    return true;
                }
            }
            ,
            CAN_NOT_BE_USED{

                @Override
                boolean canBeUsed() {
                    return false;
                }
            };


            abstract boolean canBeUsed();
        }
    }
}

