/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugHistory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskAttachmentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataCollector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.UnrecognizedReponseException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.data.TaskRevision;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class BugzillaRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String BUG_ID = "&bug_id=";
    private static final String CHANGED_BUGS_CGI_ENDDATE = "&chfieldto=Now";
    private static final String CHANGED_BUGS_CGI_QUERY = "/buglist.cgi?query_format=advanced&chfieldfrom=";
    private static final String CLIENT_LABEL = Messages.BugzillaRepositoryConnector_BUGZILLA_CONNECTOR_LABEL;
    private static final String COMMENT_FORMAT = "yyyy-MM-dd HH:mm";
    private static final long HOUR = 3600000L;
    private final BugzillaTaskAttachmentHandler attachmentHandler = new BugzillaTaskAttachmentHandler(this);
    private final BugzillaTaskDataHandler taskDataHandler = new BugzillaTaskDataHandler(this);
    protected BugzillaClientManager clientManager;
    protected static BugzillaLanguageSettings enSetting;
    protected static final Set<BugzillaLanguageSettings> languages;
    private static final String ERROR_DELETING_CONFIGURATION = "Error removing corrupt repository configuration file.";
    private static final String ERROR_INCOMPATIBLE_CONFIGURATION = "Reset Bugzilla repository configuration cache due to format change";
    private boolean cacheFileRead;
    private File repositoryConfigurationFile;
    private final Map<String, RepositoryConfiguration> repositoryConfigurations = new HashMap<String, RepositoryConfiguration>();
    private static final Map<String, String> java2buzillaPlatformMap;

    static {
        languages = new LinkedHashSet<BugzillaLanguageSettings>();
        java2buzillaPlatformMap = new HashMap<String, String>();
        enSetting = new BugzillaLanguageSettings("en (default)");
        enSetting.addLanguageAttribute("error_login", "Login");
        enSetting.addLanguageAttribute("error_login", "log in");
        enSetting.addLanguageAttribute("error_login", "check e-mail");
        enSetting.addLanguageAttribute("error_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("error_login", "account locked");
        enSetting.addLanguageAttribute("error_collision", "Mid-air collision!");
        enSetting.addLanguageAttribute("error_collision", "Mid-air collision detected!");
        enSetting.addLanguageAttribute("error_comment_required", "Comment Required");
        enSetting.addLanguageAttribute("error_logged_out", "logged out");
        enSetting.addLanguageAttribute("bad_login", "Login");
        enSetting.addLanguageAttribute("bad_login", "log in");
        enSetting.addLanguageAttribute("bad_login", "check e-mail");
        enSetting.addLanguageAttribute("bad_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("bad_login", "account locked");
        enSetting.addLanguageAttribute("bad_login", "error");
        enSetting.addLanguageAttribute("processed", "processed");
        enSetting.addLanguageAttribute("changes_submitted", "Changes submitted");
        enSetting.addLanguageAttribute("changes_submitted", "added to Bug");
        enSetting.addLanguageAttribute("bug", "Bug");
        enSetting.addLanguageAttribute("bug", "Issue");
        enSetting.addLanguageAttribute("submitted", "Submitted");
        enSetting.addLanguageAttribute("submitted", "posted");
        enSetting.addLanguageAttribute("suspicious_action", "Suspicious action");
        enSetting.addLanguageAttribute("error_confirm_match", "confirm match");
        enSetting.addLanguageAttribute("error_match_failed", "match failed");
        languages.add(enSetting);
        java2buzillaPlatformMap.put("x86", "PC");
        java2buzillaPlatformMap.put("x86_64", "PC");
        java2buzillaPlatformMap.put("ia64", "PC");
        java2buzillaPlatformMap.put("ia64_32", "PC");
        java2buzillaPlatformMap.put("sparc", "Sun");
        java2buzillaPlatformMap.put("ppc", "Power PC");
    }

    public BugzillaRepositoryConnector() {
        if (BugzillaCorePlugin.getDefault() != null) {
            BugzillaCorePlugin.getDefault().setConnector(this);
            IPath path = BugzillaCorePlugin.getDefault().getConfigurationCachePath();
            this.repositoryConfigurationFile = path.toFile();
        }
    }

    public BugzillaRepositoryConnector(File repositoryConfigurationFile) {
        this.repositoryConfigurationFile = repositoryConfigurationFile;
    }

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData taskData) {
        TaskMapper scheme = this.getTaskMapping(taskData);
        scheme.applyTo(task);
        task.setUrl(BugzillaClient.getBugUrlWithoutLogin(repository.getRepositoryUrl(), taskData.getTaskId()));
        boolean isComplete = false;
        TaskAttribute attributeStatus = taskData.getRoot().getMappedAttribute("task.common.status");
        if (attributeStatus != null) {
            RepositoryConfiguration configuration = this.getRepositoryConfiguration(repository.getRepositoryUrl());
            isComplete = configuration == null || configuration.getClosedStatusValues().isEmpty() ? attributeStatus.getValue().equals("RESOLVED") || attributeStatus.getValue().equals("CLOSED") || attributeStatus.getValue().equals("VERIFIED") : configuration.getClosedStatusValues().contains(attributeStatus.getValue());
        }
        if (taskData.isPartial()) {
            if (isComplete) {
                if (task.getCompletionDate() == null) {
                    task.setCompletionDate(new Date(0L));
                }
            } else if (task.getCompletionDate() != null) {
                task.setCompletionDate(null);
            }
        } else {
            TaskAttribute attrSeverity;
            if (isComplete) {
                TaskAttribute attributeLastModified;
                TaskAttribute attributeCommentDate;
                TaskAttribute lastComment;
                Date completionDate = null;
                List taskComments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
                if (taskComments != null && taskComments.size() > 0 && (lastComment = (TaskAttribute)taskComments.get(taskComments.size() - 1)) != null && (attributeCommentDate = lastComment.getMappedAttribute("task.common.comment.date")) != null) {
                    try {
                        completionDate = new SimpleDateFormat(COMMENT_FORMAT).parse(attributeCommentDate.getValue());
                    }
                    catch (ParseException parseException) {}
                }
                if (completionDate == null && (attributeLastModified = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attributeLastModified.getValue().length() > 0) {
                    completionDate = taskData.getAttributeMapper().getDateValue(attributeLastModified);
                }
                if (completionDate == null) {
                    completionDate = new Date();
                }
                task.setCompletionDate(completionDate);
            } else {
                task.setCompletionDate(null);
            }
            if (scheme.getProduct() != null) {
                task.setAttribute("task.common.product", scheme.getProduct());
            }
            if ((attrSeverity = taskData.getRoot().getMappedAttribute(BugzillaAttribute.BUG_SEVERITY.getKey())) != null && !attrSeverity.getValue().equals("")) {
                task.setAttribute(BugzillaAttribute.BUG_SEVERITY.getKey(), attrSeverity.getValue());
            }
        }
        this.updateExtendedAttributes(task, taskData);
    }

    private void updateExtendedAttributes(ITask task, TaskData taskData) {
        BugzillaAttribute[] bugzillaAttributeArray = BugzillaAttribute.EXTENDED_ATTRIBUTES;
        int n = BugzillaAttribute.EXTENDED_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaAttribute bugzillaReportElement = bugzillaAttributeArray[n2];
            TaskAttribute taskAttribute = taskData.getRoot().getAttribute(bugzillaReportElement.getKey());
            if (taskAttribute != null) {
                task.setAttribute(bugzillaReportElement.getKey(), taskAttribute.getValue());
            }
            ++n2;
        }
    }

    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        TaskRepository repository = session.getTaskRepository();
        if (session.getTasks().isEmpty()) {
            return;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.BugzillaRepositoryConnector_checking_for_changed_tasks, session.getTasks().size());
            if (repository.getSynchronizationTimeStamp() == null) {
                for (ITask task : session.getTasks()) {
                    session.markStale(task);
                }
                return;
            }
            try {
                String dateString = repository.getSynchronizationTimeStamp();
                if (dateString == null) {
                    dateString = "";
                }
                String urlQueryBase = String.valueOf(repository.getRepositoryUrl()) + CHANGED_BUGS_CGI_QUERY + URLEncoder.encode(dateString, repository.getCharacterEncoding()) + CHANGED_BUGS_CGI_ENDDATE;
                StringBuilder urlQueryString = new StringBuilder(Math.min(30 + 9 * session.getTasks().size(), 7009));
                urlQueryString.append(String.valueOf(urlQueryBase) + BUG_ID);
                HashSet<ITask> changedTasks = new HashSet<ITask>();
                Iterator itr = session.getTasks().iterator();
                int queryCounter = 0;
                HashSet<ITask> checking = new HashSet<ITask>();
                while (itr.hasNext()) {
                    ITask task = (ITask)itr.next();
                    checking.add(task);
                    ++queryCounter;
                    urlQueryString.append(URLEncoder.encode(String.valueOf(task.getTaskId()) + ",", repository.getCharacterEncoding()));
                    if (urlQueryString.length() >= 7000) {
                        this.queryForChanged(repository, changedTasks, urlQueryString.toString(), session, (IProgressMonitor)new SubProgressMonitor(monitor, queryCounter));
                        queryCounter = 0;
                        urlQueryString.setLength(0);
                        urlQueryString.append(String.valueOf(urlQueryBase) + BUG_ID);
                    }
                    if (itr.hasNext() || queryCounter == 0) continue;
                    this.queryForChanged(repository, changedTasks, urlQueryString.toString(), session, (IProgressMonitor)new SubProgressMonitor(monitor, queryCounter));
                }
                for (ITask task : session.getTasks()) {
                    if (!changedTasks.contains(task)) continue;
                    session.markStale(task);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Repository configured with unsupported encoding: " + repository.getCharacterEncoding() + "\n\n Unable to determine changed tasks.", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryForChanged(TaskRepository repository, Set<ITask> changedTasks, String urlQueryString, ISynchronizationSession syncSession, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException {
        HashMap<String, ITask> taskById = new HashMap<String, ITask>();
        for (ITask task : syncSession.getTasks()) {
            taskById.put(task.getTaskId(), task);
        }
        BugzillaTaskDataCollector collector = new BugzillaTaskDataCollector();
        RepositoryQuery query = new RepositoryQuery(repository.getConnectorKind(), "");
        query.setSummary(Messages.BugzillaRepositoryConnector_Query_for_changed_tasks);
        query.setUrl(urlQueryString);
        this.performQuery(repository, (IRepositoryQuery)query, collector, syncSession, monitor);
        for (TaskData data : collector.getTaskData()) {
            ITask changedTask = (ITask)taskById.get(data.getTaskId());
            if (changedTask == null) continue;
            changedTasks.add(changedTask);
        }
        if (syncSession.getData() == null && collector.getQueryTimestamp() != null) {
            syncSession.setData((Object)collector.getQueryTimestamp());
        }
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession event, IProgressMonitor monitor) {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.BugzillaRepositoryConnector_running_query, -1);
            BugzillaClient client = this.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            TaskAttributeMapper mapper = this.getTaskDataHandler().getAttributeMapper(repository);
            boolean hitsReceived = client.getSearchHits(query, resultCollector, mapper, monitor);
            if (!hitsReceived) {
                client.logout(monitor);
                client.getSearchHits(query, resultCollector, mapper, monitor);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnrecognizedReponseException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 1, Messages.BugzillaRepositoryConnector_Unrecognized_response_from_server, (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 4, MessageFormat.format(Messages.BugzillaRepositoryConnector_Check_repository_configuration, e.getMessage()), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/show_bug.cgi?id=");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url == null) {
            return null;
        }
        int anchorIndex = url.lastIndexOf("#");
        String bugUrl = url;
        if (anchorIndex != -1) {
            bugUrl = url.substring(0, anchorIndex);
        }
        return (index = bugUrl.indexOf("/show_bug.cgi?id=")) == -1 ? null : bugUrl.substring(index + "/show_bug.cgi?id=".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        try {
            return BugzillaClient.getBugUrlWithoutLogin(repositoryUrl, taskId);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error constructing task url for " + repositoryUrl + "  id:" + taskId, (Throwable)e));
            return null;
        }
    }

    public String getTaskIdPrefix() {
        return "bug";
    }

    public BugzillaClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BugzillaClientManager(this);
        }
        return this.clientManager;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (repository != null) {
            this.getRepositoryConfiguration(repository, true, monitor);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (super.isRepositoryConfigurationStale(repository, monitor)) {
            String timestamp;
            boolean result = true;
            BugzillaClient client = this.getClientManager().getClient(repository, monitor);
            if (client != null && (timestamp = client.getConfigurationTimestamp(monitor)) != null) {
                String oldTimestamp = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
                if (oldTimestamp != null) {
                    result = !timestamp.equals(oldTimestamp);
                }
                repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", timestamp);
            }
            return result;
        }
        return false;
    }

    public static void addLanguageSetting(BugzillaLanguageSettings language) {
        if (!languages.contains(language)) {
            languages.add(language);
        }
    }

    public static Set<BugzillaLanguageSettings> getLanguageSettings() {
        return languages;
    }

    public static BugzillaLanguageSettings getLanguageSetting(String label) {
        for (BugzillaLanguageSettings language : BugzillaRepositoryConnector.getLanguageSettings()) {
            if (!language.getLanguageName().equals(label)) continue;
            return language;
        }
        return enSetting;
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("", 1);
            if (event.isFullSynchronization() && event.getStatus() == null) {
                event.getTaskRepository().setSynchronizationTimeStamp(this.getSynchronizationTimestamp(event));
            }
        }
        finally {
            monitor.done();
        }
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskAttribute attrModification;
        String lastKnownMod;
        if (taskData.isPartial() && task.getCreationDate() != null) {
            return false;
        }
        TaskAttribute attrSecurityToken = taskData.getRoot().getMappedAttribute(BugzillaAttribute.TOKEN.getKey());
        if (attrSecurityToken != null && !attrSecurityToken.getValue().equals("")) {
            task.setAttribute(BugzillaAttribute.TOKEN.getKey(), attrSecurityToken.getValue());
        }
        if ((lastKnownMod = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey())) != null && (attrModification = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attrModification.getValue() != null && attrModification.getValue().length() > 0) {
            boolean cachedHasTZ = this.hasTimzone(lastKnownMod);
            boolean repoHasTZ = this.hasTimzone(attrModification.getValue());
            if (!cachedHasTZ && !repoHasTZ) {
                return !lastKnownMod.equals(attrModification.getValue());
            }
            BugzillaAttributeMapper mapper = (BugzillaAttributeMapper)taskData.getAttributeMapper();
            Date oldModDate = BugzillaAttributeMapper.parseDate(lastKnownMod);
            Date newModDate = mapper.getDateValue(attrModification);
            if (oldModDate == null) {
                ((AbstractTask)task).setStatus((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to parse cached task modification timestamp " + lastKnownMod));
                return !lastKnownMod.equals(attrModification.getValue());
            }
            if (newModDate == null) {
                ((AbstractTask)task).setStatus((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to parse incoming task modification timestamp " + attrModification.getValue()));
                return !lastKnownMod.equals(attrModification.getValue());
            }
            if (cachedHasTZ && !repoHasTZ || !cachedHasTZ && repoHasTZ) {
                long delta = Math.abs(newModDate.getTime() - oldModDate.getTime());
                if (delta == 0L) {
                    return false;
                }
                return delta <= 0L || delta % 3600000L != 0L || delta >= 86400000L;
            }
            if (cachedHasTZ && repoHasTZ) {
                return oldModDate.compareTo(newModDate) != 0;
            }
        }
        return true;
    }

    private boolean hasTimzone(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return false;
        }
        String[] parts = dateString.split(" ");
        boolean hasTimeZone = parts != null && parts.length == 3;
        return hasTimeZone;
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        String taskId;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
        TaskAttribute attribute = taskData.getRoot().getAttribute(BugzillaAttribute.DEPENDSON.getKey());
        if (attribute != null && attribute.getValue().length() > 0) {
            stringArray = attribute.getValue().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                taskId = stringArray[n];
                relations.add(TaskRelation.subtask((String)taskId.trim()));
                ++n;
            }
        }
        if ((attribute = taskData.getRoot().getAttribute(BugzillaAttribute.BLOCKED.getKey())) != null && attribute.getValue().length() > 0) {
            stringArray = attribute.getValue().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                taskId = stringArray[n];
                relations.add(TaskRelation.parentTask((String)taskId.trim()));
                ++n;
            }
        }
        return relations;
    }

    private String getSynchronizationTimestamp(ISynchronizationSession event) {
        Date mostRecent = new Date(0L);
        String mostRecentTimeStamp = event.getTaskRepository().getSynchronizationTimeStamp();
        if (event.getData() != null) {
            mostRecentTimeStamp = (String)event.getData();
        } else {
            for (ITask task : event.getChangedTasks()) {
                Date taskModifiedDate = task.getModificationDate();
                if (taskModifiedDate == null || !taskModifiedDate.after(mostRecent)) continue;
                mostRecent = taskModifiedDate;
                mostRecentTimeStamp = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey());
            }
        }
        return mostRecentTimeStamp;
    }

    public boolean hasRepositoryDueDate(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()) != null;
    }

    public TaskMapper getTaskMapping(final TaskData taskData) {
        return new TaskMapper(taskData){

            public String getTaskKey() {
                TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(BugzillaAttribute.BUG_ID.getKey());
                if (attribute != null) {
                    return attribute.getValue();
                }
                return super.getTaskKey();
            }

            public String getTaskKind() {
                return taskData.getConnectorKind();
            }

            public String getTaskUrl() {
                return taskData.getRepositoryUrl();
            }

            public ITask.PriorityLevel getPriorityLevel() {
                RepositoryConfiguration repositoryConfiguration = BugzillaRepositoryConnector.this.getRepositoryConfiguration(taskData.getRepositoryUrl());
                String priority = this.getPriority();
                if (repositoryConfiguration == null) {
                    return BugzillaRepositoryConnector.getTaskPriority(priority);
                }
                List<String> priorities = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRIORITY);
                return BugzillaRepositoryConnector.getTaskPriority(priority, priorities);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readRepositoryConfigurationFile() {
        if (this.cacheFileRead || this.repositoryConfigurationFile == null || !this.repositoryConfigurationFile.exists()) {
            return;
        }
        Map<String, RepositoryConfiguration> map = this.repositoryConfigurations;
        synchronized (map) {
            block24: {
                ObjectInputStream in = null;
                try {
                    try {
                        in = new ObjectInputStream(new FileInputStream(this.repositoryConfigurationFile));
                        int size = in.readInt();
                        int nX = 0;
                        while (nX < size) {
                            RepositoryConfiguration item = (RepositoryConfiguration)in.readObject();
                            if (item != null) {
                                this.repositoryConfigurations.put(item.getRepositoryUrl(), item);
                            }
                            ++nX;
                        }
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.bugzilla", ERROR_INCOMPATIBLE_CONFIGURATION));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (this.repositoryConfigurationFile != null && this.repositoryConfigurationFile.exists() && !this.repositoryConfigurationFile.delete()) {
                                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                            }
                        }
                        catch (Exception exception) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                        }
                        this.cacheFileRead = true;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.cacheFileRead = true;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                this.cacheFileRead = true;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConfiguration getRepositoryConfiguration(TaskRepository repository, boolean forceRefresh, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            this.readRepositoryConfigurationFile();
            RepositoryConfiguration configuration = this.repositoryConfigurations.get(repository.getRepositoryUrl());
            if (configuration == null || forceRefresh) {
                Map<String, RepositoryConfiguration> map = this.repositoryConfigurations;
                synchronized (map) {
                    configuration = this.repositoryConfigurations.get(repository.getRepositoryUrl());
                    if (configuration == null || forceRefresh) {
                        String eTag = null;
                        Date lastModifiedHeader = null;
                        if (configuration != null && !forceRefresh) {
                            eTag = configuration.getETagValue();
                            lastModifiedHeader = configuration.getLastModifiedHeader();
                        }
                        BugzillaClient client = this.getClientManager().getClient(repository, monitor);
                        configuration = client.getRepositoryConfiguration(monitor, eTag);
                        boolean newer = true;
                        if (configuration != null) {
                            Date configLastModifiedHeader;
                            if (lastModifiedHeader != null && (configLastModifiedHeader = configuration.getLastModifiedHeader()) != null) {
                                boolean bl = newer = !configLastModifiedHeader.before(lastModifiedHeader);
                            }
                            if (newer) {
                                String repositoryVersion;
                                String configVersion = configuration.getInstallVersion().toString();
                                if (!configVersion.equals(repositoryVersion = repository.getVersion())) {
                                    repository.setVersion(configVersion);
                                }
                                this.internalAddConfiguration(configuration);
                            }
                        }
                    }
                }
            }
            return configuration;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Error retrieving task attributes from repository.\n\n" + e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            if (e.getMessage().equals("Not changed")) {
                RepositoryConfiguration configuration = this.repositoryConfigurations.get(repository.getRepositoryUrl());
                if (configuration == null) {
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Failed to retrieve repository configuration for " + repository.getRepositoryUrl().toString()));
                }
                return configuration;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryConfiguration(RepositoryConfiguration config) {
        if (config != null) {
            this.readRepositoryConfigurationFile();
            Map<String, RepositoryConfiguration> map = this.repositoryConfigurations;
            synchronized (map) {
                this.internalAddConfiguration(config);
            }
        }
    }

    private void internalAddConfiguration(RepositoryConfiguration config) {
        this.repositoryConfigurations.remove(config.getRepositoryUrl());
        this.repositoryConfigurations.put(config.getRepositoryUrl(), config);
    }

    public RepositoryConfiguration getRepositoryConfiguration(String repositoryUrl) {
        this.readRepositoryConfigurationFile();
        return this.repositoryConfigurations.get(repositoryUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguration(RepositoryConfiguration config) {
        Map<String, RepositoryConfiguration> map = this.repositoryConfigurations;
        synchronized (map) {
            this.repositoryConfigurations.remove(config.getRepositoryUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRepositoryConfigFile() {
        block20: {
            if (this.repositoryConfigurationFile != null) {
                ObjectOutputStream out = null;
                try {
                    try {
                        HashSet<RepositoryConfiguration> tempConfigs;
                        Map<String, RepositoryConfiguration> map = this.repositoryConfigurations;
                        synchronized (map) {
                            tempConfigs = new HashSet<RepositoryConfiguration>(this.repositoryConfigurations.values());
                        }
                        if (tempConfigs.size() > 0) {
                            out = new ObjectOutputStream(new FileOutputStream(this.repositoryConfigurationFile));
                            out.writeInt(tempConfigs.size());
                            for (RepositoryConfiguration repositoryConfiguration : tempConfigs) {
                                if (repositoryConfiguration == null) continue;
                                out.writeObject(repositoryConfiguration);
                            }
                        }
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", 0, "Failed to write repository configuration cache", (Throwable)e));
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void stop() {
        this.writeRepositoryConfigFile();
    }

    public void setPlatformDefaultsOrGuess(TaskRepository repository, TaskData newBugModel) {
        String platform = repository.getProperty("bugzilla.default.platform");
        String os = repository.getProperty("bugzilla.default.os");
        if (os != null && platform != null) {
            TaskAttribute opSysAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.OP_SYS.getKey());
            TaskAttribute platformAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.REP_PLATFORM.getKey());
            opSysAttribute.setValue(os);
            platformAttribute.setValue(platform);
            return;
        }
        this.setPlatformOptions(newBugModel);
    }

    public void setPlatformOptions(TaskData newBugModel) {
        try {
            String[] wsExtentionsTemp;
            char firstUpper;
            char firstLower;
            TaskAttribute opSysAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.OP_SYS.getKey());
            TaskAttribute platformAttribute = newBugModel.getRoot().getAttribute(BugzillaAttribute.REP_PLATFORM.getKey());
            String OS = Platform.getOS();
            String platform = Platform.getOSArch();
            String ws = Platform.getWS();
            String bugzillaOS = null;
            String bugzillaPlatform = null;
            String[] wsExtentions = null;
            if (ws.length() > 1) {
                char first = ws.charAt(0);
                firstLower = Character.toLowerCase(first);
                firstUpper = Character.toUpperCase(first);
                wsExtentionsTemp = new String[]{" - " + firstUpper + ws.substring(1, ws.length()), " - " + firstLower + ws.substring(1, ws.length()), " " + firstUpper + ws.substring(1, ws.length()), " " + firstLower + ws.substring(1, ws.length()), ""};
                wsExtentions = wsExtentionsTemp;
            } else if (ws.length() == 1) {
                char first = ws.charAt(0);
                firstLower = Character.toLowerCase(first);
                firstUpper = Character.toUpperCase(first);
                wsExtentionsTemp = new String[]{" - " + firstUpper, " - " + firstLower, " " + firstUpper, " " + firstLower, ""};
                wsExtentions = wsExtentionsTemp;
            } else {
                String[] wsExtentionsTemp2;
                wsExtentions = wsExtentionsTemp2 = new String[]{""};
            }
            bugzillaOS = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
            if (opSysAttribute != null) {
                String[] stringArray = wsExtentions;
                int n = wsExtentions.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String bugzillaOSTemp = bugzillaOS;
                    while (bugzillaOSTemp != null && opSysAttribute.getOption(String.valueOf(bugzillaOSTemp) + element) == null) {
                        int spaceindex;
                        int dotindex = bugzillaOSTemp.lastIndexOf(46);
                        bugzillaOSTemp = dotindex > 0 ? bugzillaOSTemp.substring(0, dotindex) : ((spaceindex = bugzillaOSTemp.lastIndexOf(32)) > 0 ? bugzillaOSTemp.substring(0, spaceindex) : null);
                    }
                    if (bugzillaOSTemp != null) {
                        bugzillaOS = String.valueOf(bugzillaOSTemp) + element;
                        break;
                    }
                    ++n2;
                }
            } else {
                bugzillaOS = null;
            }
            if (platform != null && java2buzillaPlatformMap.containsKey(platform)) {
                bugzillaPlatform = java2buzillaPlatformMap.get(platform);
                if (bugzillaPlatform != null && (bugzillaPlatform.compareTo("Power") == 0 || bugzillaPlatform.compareTo("PC") == 0) && OS != null && OS.compareTo("macosx") == 0) {
                    bugzillaPlatform = "Macintosh";
                } else if (platformAttribute != null && platformAttribute.getOption(bugzillaPlatform) == null) {
                    bugzillaPlatform = null;
                }
            }
            if (bugzillaOS != null && opSysAttribute != null && opSysAttribute.getOption(bugzillaOS) != null) {
                opSysAttribute.setValue(bugzillaOS);
            }
            if (bugzillaPlatform != null && platformAttribute != null && platformAttribute.getOption(bugzillaPlatform) != null) {
                platformAttribute.setValue(bugzillaPlatform);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "could not set platform options", (Throwable)e));
        }
    }

    public boolean canGetTaskHistory(TaskRepository repository, ITask task) {
        return Boolean.parseBoolean(repository.getProperty("bugzilla.xmlrpc.status.transition"));
    }

    public TaskHistory getTaskHistory(TaskRepository repository, ITask task, IProgressMonitor monitor) throws CoreException {
        BugzillaClient client = this.getClientManager().getClient(repository, monitor);
        BugHistory bugHistory = client.getBugHistory(task.getTaskId(), monitor).get(0);
        TaskHistory history = new TaskHistory(repository, task);
        for (BugHistory.Revision bugRevision : bugHistory.getRevisions()) {
            TaskRevision revision = new TaskRevision(Long.toString(bugRevision.getWhen().getTime()), bugRevision.getWhen(), repository.createPerson(bugRevision.getWho()));
            history.add(revision);
            for (BugHistory.Change bugChange : bugRevision.getChanges()) {
                String attributeId = bugChange.getAttachmentId() > 0 ? "task.common.attachment-" + bugChange.getAttachmentId() : bugChange.getFieldName();
                TaskRevision.Change change = new TaskRevision.Change(attributeId, bugChange.getFieldName(), bugChange.getRemoved(), bugChange.getAdded());
                revision.add(change);
            }
        }
        return history;
    }

    public static ITask.PriorityLevel getTaskPriority(String bugzillaPriority) {
        BugzillaPriorityLevel priority;
        if (bugzillaPriority != null && (priority = BugzillaPriorityLevel.fromPriority(bugzillaPriority)) != null) {
            return priority.toPriorityLevel();
        }
        return ITask.PriorityLevel.fromString((String)bugzillaPriority);
    }

    public static ITask.PriorityLevel getTaskPriority(String priority, List<String> priorities) {
        if (priority != null && priorities != null && priorities.size() > 0) {
            int size = priorities.size() - 1;
            int index = 0;
            for (String priority2test : priorities) {
                if (priority.equals(priority2test)) {
                    float relativeValue = (float)index / (float)size;
                    int value = (int)(relativeValue * 5.0f) + 1;
                    return ITask.PriorityLevel.fromLevel((int)value);
                }
                ++index;
            }
        }
        return BugzillaRepositoryConnector.getTaskPriority(priority);
    }

    public static enum BugzillaPriorityLevel {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST,
        NONE;


        public static BugzillaPriorityLevel fromPriority(String priority) {
            if (priority == null) {
                return null;
            }
            if (priority.equals("Highest")) {
                return HIGHEST;
            }
            if (priority.equals("High")) {
                return HIGH;
            }
            if (priority.equals("Normal")) {
                return NORMAL;
            }
            if (priority.equals("Low")) {
                return LOW;
            }
            if (priority.equals("Lowest")) {
                return LOWEST;
            }
            if (priority.equals("---")) {
                return NONE;
            }
            return null;
        }

        public ITask.PriorityLevel toPriorityLevel() {
            switch (this) {
                case HIGHEST: {
                    return ITask.PriorityLevel.P1;
                }
                case HIGH: {
                    return ITask.PriorityLevel.P2;
                }
                case NORMAL: {
                    return ITask.PriorityLevel.P3;
                }
                case LOW: {
                    return ITask.PriorityLevel.P4;
                }
                case LOWEST: {
                    return ITask.PriorityLevel.P5;
                }
                case NONE: {
                    return ITask.PriorityLevel.P3;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case HIGHEST: {
                    return "Highest";
                }
                case HIGH: {
                    return "High";
                }
                case NORMAL: {
                    return "Normal";
                }
                case LOW: {
                    return "Low";
                }
                case LOWEST: {
                    return "Lowest";
                }
                case NONE: {
                    return "---";
                }
            }
            return null;
        }
    }
}

