/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import org.apache.subversion.javahl.types.Revision;

public class RevisionRange
implements Comparable<RevisionRange>,
Serializable {
    private static final long serialVersionUID = 2L;
    private Revision from;
    private Revision to;
    private boolean inheritable;

    protected RevisionRange(long from, long to, boolean inheritable) {
        this.from = Revision.getInstance(from);
        this.to = Revision.getInstance(to);
        this.inheritable = inheritable;
    }

    public RevisionRange(Revision from, Revision to, boolean inheritable) {
        this.from = from;
        this.to = to;
        this.inheritable = inheritable;
    }

    public RevisionRange(Revision from, Revision to) {
        this.from = from;
        this.to = to;
        this.inheritable = true;
    }

    public RevisionRange(String revisionElement) {
        int hyphen;
        if (revisionElement == null) {
            return;
        }
        boolean bl = this.inheritable = !revisionElement.endsWith("*");
        if (!this.inheritable) {
            revisionElement = revisionElement.substring(0, revisionElement.length() - 1);
        }
        if ((hyphen = revisionElement.indexOf(45)) > 0) {
            try {
                long fromRev = Long.parseLong(revisionElement.substring(0, hyphen));
                long toRev = Long.parseLong(revisionElement.substring(hyphen + 1));
                this.from = new Revision.Number(fromRev);
                this.to = new Revision.Number(toRev);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            long revNum = Long.parseLong(revisionElement.trim());
            if (revNum <= 0L) {
                return;
            }
            this.to = new Revision.Number(revNum);
            this.from = new Revision.Number(revNum - 1L);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public Revision getFromRevision() {
        return this.from;
    }

    public Revision getToRevision() {
        return this.to;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public String toString() {
        if (this.from != null && this.to != null) {
            String rep = this.from.getKind() == Revision.Kind.number && this.to.getKind() == Revision.Kind.number && ((Revision.Number)this.from).getNumber() + 1L == ((Revision.Number)this.to).getNumber() ? this.to.toString() : (this.from.equals(this.to) ? this.from.toString() : this.from.toString() + '-' + this.to.toString());
            if (!this.inheritable) {
                return rep + '*';
            }
            return rep;
        }
        return super.toString();
    }

    public static Long getRevisionAsLong(Revision rev) {
        long val = 0L;
        if (rev != null && rev instanceof Revision.Number) {
            val = ((Revision.Number)rev).getNumber();
        }
        return val;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.inheritable ? 1 : 2;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object range) {
        if (this == range) {
            return true;
        }
        if (!super.equals(range)) {
            return false;
        }
        if (this.getClass() != range.getClass()) {
            return false;
        }
        RevisionRange other = (RevisionRange)range;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        return this.inheritable == other.inheritable;
    }

    @Override
    public int compareTo(RevisionRange range) {
        if (this == range) {
            return 0;
        }
        Revision other = range.getFromRevision();
        return RevisionRange.getRevisionAsLong(this.getFromRevision()).compareTo(RevisionRange.getRevisionAsLong(other));
    }
}

