/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.run;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.netbeans.modules.docker.api.DockerImageDetail;
import org.netbeans.modules.docker.api.ExposedPort;
import org.netbeans.modules.docker.api.PortMapping;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.run.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class RunPortBindingsVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DockerImageDetail info;
    private final PortMappingModel model = new PortMappingModel();
    private JButton addButton;
    private JButton addExposedButton;
    private JScrollPane jScrollPane1;
    private JLabel portMappingLabel;
    private JTable portMappingTable;
    private JCheckBox randomBindCheckBox;
    private JButton removeButton;

    public RunPortBindingsVisual(DockerImageDetail info) {
        this.initComponents();
        this.info = info;
        this.addExposedButton.setEnabled(info != null && !info.getExposedPorts().isEmpty());
        this.portMappingTable.setModel(this.model);
        UiUtils.configureRowHeight(this.portMappingTable);
        TableColumn typeColumn = this.portMappingTable.getColumnModel().getColumn(0);
        JComboBox<ExposedPort.Type> typeCombo = new JComboBox<ExposedPort.Type>(ExposedPort.Type.values());
        typeColumn.setCellEditor(new DefaultCellEditor(typeCombo));
        typeColumn.setPreferredWidth(typeColumn.getPreferredWidth() / 2);
        TableColumn portColumn = this.portMappingTable.getColumnModel().getColumn(2);
        portColumn.setCellRenderer(new CellRenderer("<random>", false));
        TableColumn addressColumn = this.portMappingTable.getColumnModel().getColumn(3);
        JComboBox<Object> addressCombo = new JComboBox<Object>(UiUtils.getAddresses(false, false).toArray());
        addressCombo.setEditable(true);
        addressColumn.setCellEditor(new DefaultCellEditor(addressCombo));
        addressColumn.setCellRenderer(new CellRenderer("<any>", false));
        addressColumn.setPreferredWidth(addressColumn.getPreferredWidth() * 2);
        this.portMappingTable.setAutoResizeMode(3);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RunPortBindingsVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isRandomBind() {
        return this.randomBindCheckBox.isSelected();
    }

    public void setRandomBind(boolean randomBind) {
        this.randomBindCheckBox.setSelected(randomBind);
    }

    public List<PortMapping> getPortMapping() {
        return this.model.getMappings();
    }

    public void setPortMapping(List<PortMapping> mapping) {
        this.model.setMappings(mapping);
    }

    @Override
    public String getName() {
        return Bundle.LBL_RunPortBindings();
    }

    private void initComponents() {
        this.portMappingLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.portMappingTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addExposedButton = new JButton();
        this.randomBindCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.portMappingLabel, (String)NbBundle.getMessage(RunPortBindingsVisual.class, (String)"RunPortBindingsVisual.portMappingLabel.text"));
        this.jScrollPane1.setViewportView(this.portMappingTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RunPortBindingsVisual.class, (String)"RunPortBindingsVisual.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunPortBindingsVisual.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RunPortBindingsVisual.class, (String)"RunPortBindingsVisual.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunPortBindingsVisual.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addExposedButton, (String)NbBundle.getMessage(RunPortBindingsVisual.class, (String)"RunPortBindingsVisual.addExposedButton.text"));
        this.addExposedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunPortBindingsVisual.this.addExposedButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.randomBindCheckBox, (String)NbBundle.getMessage(RunPortBindingsVisual.class, (String)"RunPortBindingsVisual.randomBindCheckBox.text"));
        this.randomBindCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RunPortBindingsVisual.this.randomBindCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.portMappingLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.randomBindCheckBox, -1, 520, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addExposedButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.randomBindCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.portMappingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addExposedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE))));
    }

    private void addExposedButtonActionPerformed(ActionEvent evt) {
        List<PortMapping> current = this.model.getMappings();
        for (ExposedPort p : this.info.getExposedPorts()) {
            boolean present = false;
            for (PortMapping m : current) {
                if (p.getType() != m.getType() || m.getPort() == null || p.getPort() != m.getPort().intValue()) continue;
                present = true;
                break;
            }
            if (present) continue;
            this.model.addRow(new PortMapping(p.getType(), Integer.valueOf(p.getPort()), Integer.valueOf(p.getPort()), null));
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.model.addRow(new PortMapping(ExposedPort.Type.TCP, null, null, null));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.portMappingTable.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.model.removeRow(selectedRows[i]);
        }
    }

    private void randomBindCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.randomBindCheckBox.isSelected();
        this.portMappingTable.setEnabled(!selected);
        this.addExposedButton.setEnabled(!selected);
        this.addButton.setEnabled(!selected);
        this.removeButton.setEnabled(!selected);
        TableCellEditor editor = this.portMappingTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        this.portMappingTable.clearSelection();
    }

    private static final class PortMappingModel
    extends AbstractTableModel {
        private final List<PortMapping> mappings = new ArrayList<PortMapping>();

        @Override
        public int getRowCount() {
            return this.mappings.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PortMapping single = this.mappings.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return single.getType();
                }
                case 1: {
                    return single.getPort();
                }
                case 2: {
                    return single.getHostPort();
                }
                case 3: {
                    return single.getHostAddress();
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex > this.mappings.size() - 1 || rowIndex < 0) {
                return;
            }
            PortMapping single = this.mappings.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    this.mappings.set(rowIndex, new PortMapping((ExposedPort.Type)aValue, single.getPort(), single.getHostPort(), single.getHostAddress()));
                    break;
                }
                case 1: {
                    String str;
                    Integer val1 = null;
                    if (aValue != null && !(str = aValue.toString()).isEmpty()) {
                        val1 = Integer.parseInt(str);
                    }
                    this.mappings.set(rowIndex, new PortMapping(single.getType(), val1, single.getHostPort(), single.getHostAddress()));
                    break;
                }
                case 2: {
                    String str;
                    Integer val2 = null;
                    if (aValue != null && !(str = aValue.toString()).isEmpty()) {
                        val2 = Integer.parseInt(str);
                    }
                    this.mappings.set(rowIndex, new PortMapping(single.getType(), single.getPort(), val2, single.getHostAddress()));
                    break;
                }
                case 3: {
                    this.mappings.set(rowIndex, new PortMapping(single.getType(), single.getPort(), single.getHostPort(), aValue != null ? aValue.toString() : null));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown column index: " + columnIndex);
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Bundle.LBL_PortMappingType();
                }
                case 1: {
                    return Bundle.LBL_PortMappingPort();
                }
                case 2: {
                    return Bundle.LBL_PortMappingTargetPort();
                }
                case 3: {
                    return Bundle.LBL_PortMappingTargetAddres();
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ExposedPort.Type.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return String.class;
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void addRow(PortMapping mapping) {
            this.mappings.add(mapping);
            this.fireTableRowsInserted(this.mappings.size() - 1, this.mappings.size() - 1);
        }

        public void removeRow(int row) {
            this.mappings.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public List<PortMapping> getMappings() {
            return new ArrayList<PortMapping>(this.mappings);
        }

        public void setMappings(List<PortMapping> mappings) {
            this.mappings.clear();
            this.mappings.addAll(mappings);
            this.fireTableDataChanged();
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private final String emptyValue;
        private final boolean italic;

        public CellRenderer(String emptyValue, boolean italic) {
            this.emptyValue = emptyValue;
            this.italic = italic;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object toRender = value;
            if (this.emptyValue != null && (toRender == null || toRender instanceof String && ((String)toRender).trim().isEmpty())) {
                toRender = this.emptyValue;
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, toRender, isSelected, hasFocus, row, column);
            if (toRender != null && Number.class.isAssignableFrom(toRender.getClass())) {
                label.setHorizontalAlignment(11);
            } else {
                label.setHorizontalAlignment(10);
            }
            if (this.italic) {
                if (toRender != value) {
                    Font italic = new Font(label.getFont().getName(), 2, label.getFont().getSize());
                    label.setFont(italic);
                } else {
                    label.setFont(table.getFont());
                }
            }
            return label;
        }
    }
}

