/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.xml.multiview.Refreshable;

public class ItemEditorHelper
implements Refreshable {
    ItemDocument doc;
    private final JTextComponent editorComponent;
    private ItemEditorModel model;

    private JTextComponent getEditorComponent() {
        return this.editorComponent;
    }

    public ItemEditorHelper(JTextComponent textComponent) {
        this(textComponent, null);
    }

    public ItemEditorHelper(JTextComponent textComponent, ItemEditorModel model) {
        this.editorComponent = textComponent;
        this.doc = new ItemDocument();
        this.setModel(model);
        this.editorComponent.setDocument(this.doc);
        this.refresh();
    }

    public ItemEditorModel getModel() {
        return this.model;
    }

    private void setModel(ItemEditorModel model) {
        this.model = model != null ? model : ItemEditorHelper.createDefaultModel();
        this.model.itemEditorHelper = this;
    }

    private static ItemEditorModel createDefaultModel() {
        return new ItemEditorModel(){
            private String value;

            @Override
            public String getItemValue() {
                return this.value;
            }

            @Override
            public boolean setItemValue(String value) {
                this.value = value;
                return true;
            }

            @Override
            public void documentUpdated() {
            }
        };
    }

    @Override
    public void refresh() {
        this.doc.refresh();
    }

    public String getEditorText() {
        return this.editorComponent.getText();
    }

    public static abstract class ItemEditorModel {
        private ItemEditorHelper itemEditorHelper;

        public final String getEditorText() {
            return this.itemEditorHelper == null ? null : this.itemEditorHelper.getEditorText();
        }

        public final JTextComponent getEditorComponent() {
            return this.itemEditorHelper == null ? null : this.itemEditorHelper.getEditorComponent();
        }

        public abstract String getItemValue();

        public abstract boolean setItemValue(String var1);

        public abstract void documentUpdated();
    }

    private class ItemDocument
    extends PlainDocument {
        boolean refreshing = false;

        private ItemDocument() {
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            this.updateModel();
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            this.updateModel();
        }

        private void updateModel() {
            if (!this.refreshing) {
                ItemEditorHelper.this.model.documentUpdated();
                this.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            block9: {
                this.refreshing = true;
                try {
                    String text;
                    String itemValue = ItemEditorHelper.this.model.getItemValue();
                    try {
                        text = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e) {
                        text = "";
                        e.printStackTrace();
                    }
                    if (text.equals(itemValue)) break block9;
                    try {
                        super.remove(0, this.getLength());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    try {
                        super.insertString(0, itemValue, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }
}

