/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.css;

import org.eclipse.tm4e.core.internal.css.CSSValueImpl;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class Measure
extends CSSValueImpl {
    LexicalUnit value;

    public Measure(LexicalUnit value) {
        this.value = value;
    }

    @Override
    public float getFloatValue(short valueType) throws DOMException {
        if (this.value.getLexicalUnitType() == 13) {
            return this.value.getIntegerValue();
        }
        return this.value.getFloatValue();
    }

    public int getIntegerValue(short valueType) throws DOMException {
        return this.value.getIntegerValue();
    }

    @Override
    public String getStringValue() throws DOMException {
        short lexicalUnit = this.value.getLexicalUnitType();
        if (lexicalUnit == 35 || lexicalUnit == 36 || lexicalUnit == 24) {
            return this.value.getStringValue();
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public short getPrimitiveType() {
        switch (this.value.getLexicalUnitType()) {
            case 35: {
                return 21;
            }
            case 13: 
            case 14: {
                return 1;
            }
            case 24: {
                return 20;
            }
            case 23: {
                return 2;
            }
            case 17: {
                return 5;
            }
            case 19: {
                return 6;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 36: {
                return 19;
            }
            case 42: {
                return 18;
            }
            case 0: {
                return 3;
            }
            case 12: {
                return 0;
            }
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED - LexicalUnit type: " + this.value.getLexicalUnitType());
    }

    @Override
    public String getCssText() {
        switch (this.value.getLexicalUnitType()) {
            case 13: {
                return String.valueOf(this.value.getIntegerValue());
            }
            case 14: {
                return String.valueOf(this.value.getFloatValue());
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                return String.valueOf(this.value.getFloatValue()) + this.value.getDimensionUnitText();
            }
            case 24: {
                return "url(" + this.value.getStringValue() + ")";
            }
            case 0: {
                return ",";
            }
            case 12: {
                return "inherit";
            }
        }
        return this.value.getStringValue();
    }
}

