/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JavacMessages
implements Messages {
    public static final Context.Key<JavacMessages> messagesKey = new Context.Key();
    private Map<Locale, SoftReference<List<ResourceBundle>>> bundleCache;
    private List<ResourceBundleHelper> bundleHelpers = List.nil();
    private Locale currentLocale;
    private List<ResourceBundle> currentBundles;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    private JCDiagnostic.Factory diagFactory;
    Context context;
    private static final String defaultBundleName = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle defaultBundle;
    private static JavacMessages defaultMessages;

    public static JavacMessages instance(Context context) {
        JavacMessages instance = context.get(messagesKey);
        if (instance == null) {
            instance = new JavacMessages(context);
        }
        return instance;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.currentBundles = this.getBundles(locale);
        this.currentLocale = locale;
    }

    public JavacMessages(Context context) {
        this(defaultBundleName, context.get(Locale.class));
        this.context = context;
        context.put(messagesKey, this);
        Options options = Options.instance(context);
        boolean rawDiagnostics = options.isSet("rawDiagnostics");
        this.diagFormatter = rawDiagnostics ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this);
    }

    public JavacMessages(String bundleName) throws MissingResourceException {
        this(bundleName, null);
    }

    public JavacMessages(String bundleName, Locale locale) throws MissingResourceException {
        this.bundleCache = new HashMap<Locale, SoftReference<List<ResourceBundle>>>();
        this.add(bundleName);
        this.setCurrentLocale(locale);
    }

    public JavacMessages() throws MissingResourceException {
        this(defaultBundleName);
    }

    @Override
    public void add(String bundleName) throws MissingResourceException {
        this.add((Locale locale) -> ResourceBundle.getBundle(bundleName, locale));
    }

    public void add(ResourceBundleHelper ma) {
        this.bundleHelpers = this.bundleHelpers.prepend(ma);
        if (!this.bundleCache.isEmpty()) {
            this.bundleCache.clear();
        }
        this.currentBundles = null;
    }

    public List<ResourceBundle> getBundles(Locale locale) {
        List<ResourceBundle> bundleList;
        if (locale == this.currentLocale && this.currentBundles != null) {
            return this.currentBundles;
        }
        SoftReference<List<ResourceBundle>> bundles = this.bundleCache.get(locale);
        List<ResourceBundle> list = bundleList = bundles == null ? null : bundles.get();
        if (bundleList == null) {
            bundleList = List.nil();
            for (ResourceBundleHelper helper : this.bundleHelpers) {
                try {
                    ResourceBundle rb = helper.getResourceBundle(locale);
                    bundleList = bundleList.prepend(rb);
                }
                catch (MissingResourceException e) {
                    throw new InternalError("Cannot find requested resource bundle for locale " + locale, e);
                }
            }
            this.bundleCache.put(locale, new SoftReference<List<ResourceBundle>>(bundleList));
        }
        return bundleList;
    }

    public String getLocalizedString(String key, Object ... args) {
        return this.getLocalizedString(this.currentLocale, key, args);
    }

    public String getLocalizedString(JCDiagnostic.DiagnosticInfo diagInfo) {
        return this.getLocalizedString(this.currentLocale, diagInfo);
    }

    @Override
    public String getLocalizedString(Locale l, String key, Object ... args) {
        if (l == null) {
            l = this.getCurrentLocale();
        }
        return JavacMessages.getLocalizedString(this.getBundles(l), key, args);
    }

    public String getLocalizedString(Locale l, JCDiagnostic.DiagnosticInfo diagInfo) {
        if (l == null) {
            l = this.getCurrentLocale();
        }
        return this.getLocalizedString(this.getBundles(l), diagInfo);
    }

    static String getDefaultLocalizedString(String key, Object ... args) {
        return JavacMessages.getLocalizedString(List.of(JavacMessages.getDefaultBundle()), key, args);
    }

    @Deprecated
    static JavacMessages getDefaultMessages() {
        if (defaultMessages == null) {
            defaultMessages = new JavacMessages(defaultBundleName);
        }
        return defaultMessages;
    }

    public static ResourceBundle getDefaultBundle() {
        try {
            if (defaultBundle == null) {
                defaultBundle = ResourceBundle.getBundle(defaultBundleName);
            }
            return defaultBundle;
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for compiler is missing", e);
        }
    }

    private static String getLocalizedString(List<ResourceBundle> bundles, String key, Object ... args) {
        String msg = null;
        List<ResourceBundle> l = bundles;
        while (l.nonEmpty() && msg == null) {
            ResourceBundle rb = (ResourceBundle)l.head;
            try {
                msg = rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            l = l.tail;
        }
        if (msg == null) {
            msg = "compiler message file broken: key=" + key + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        return MessageFormat.format(msg, args);
    }

    private String getLocalizedString(List<ResourceBundle> bundles, JCDiagnostic.DiagnosticInfo diagInfo) {
        String msg = null;
        List<ResourceBundle> l = bundles;
        while (l.nonEmpty() && msg == null) {
            ResourceBundle rb = (ResourceBundle)l.head;
            try {
                msg = rb.getString(diagInfo.key());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            l = l.tail;
        }
        if (msg == null) {
            msg = "compiler message file broken: key=" + diagInfo.key() + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        if (diagInfo == CompilerProperties.Errors.Error) {
            return MessageFormat.format(msg, new Object[0]);
        }
        return this.diagFormatter.format(this.getDiagFactory().create(DiagnosticSource.NO_SOURCE, null, diagInfo), this.getCurrentLocale());
    }

    JCDiagnostic.Factory getDiagFactory() {
        if (this.diagFactory == null) {
            this.diagFactory = JCDiagnostic.Factory.instance(this.context);
        }
        return this.diagFactory;
    }

    public static interface ResourceBundleHelper {
        public ResourceBundle getResourceBundle(Locale var1);
    }
}

