/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.netserver.ReadHandler;
import org.netbeans.modules.netserver.SocketServer;

public abstract class SocketFramework
implements Runnable {
    protected static final Logger LOG = Logger.getLogger(SocketServer.class.getCanonicalName());
    private Selector selector;
    private Queue<SelectionKey> keys = new ConcurrentLinkedQueue<SelectionKey>();
    private ReadHandler handler;
    private volatile boolean stop;

    public SocketFramework() throws IOException {
        this.selector = Selector.open();
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    public void close(SelectionKey key) throws IOException {
        this.chanelClosed(key);
        key.channel().close();
        key.cancel();
    }

    public void stop() {
        this.stop = true;
        this.getSelector().wakeup();
    }

    public void send(byte[] data, SelectionKey key) {
        this.getWriteQueue(key).add(ByteBuffer.wrap(data));
        this.keys.add(key);
        this.getSelector().wakeup();
    }

    public boolean isStopped() {
        return this.stop;
    }

    protected void doRun() throws IOException {
        while (!this.stop) {
            SelectionKey key;
            while ((key = this.keys.poll()) != null) {
                if (!key.isValid()) continue;
                int currentOps = key.interestOps();
                key.interestOps(currentOps | 4);
            }
            this.getSelector().select();
            if (this.isStopped()) {
                return;
            }
            Iterator<SelectionKey> iterator = this.getSelector().selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey key2 = iterator.next();
                iterator.remove();
                if (!key2.isValid()) continue;
                try {
                    this.process(key2);
                }
                catch (ClosedChannelException e) {
                    this.close(key2);
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, null, e);
                    this.close(key2);
                }
            }
        }
        this.getSelector().close();
    }

    protected void process(SelectionKey key) throws IOException {
        if (key.isReadable()) {
            this.readData(key);
        }
        if (key.isValid() && key.isWritable()) {
            this.writeData(key);
        }
    }

    protected abstract void chanelClosed(SelectionKey var1);

    protected abstract SocketAddress getAddress();

    protected abstract Queue<ByteBuffer> getWriteQueue(SelectionKey var1);

    protected void setReadHandler(ReadHandler handler) {
        this.handler = handler;
    }

    protected ReadHandler getReadHandler() {
        return this.handler;
    }

    protected Selector getSelector() {
        return this.selector;
    }

    protected void readData(SelectionKey key) throws IOException {
        this.handler.read(key);
    }

    protected void writeData(SelectionKey key) throws IOException {
        ByteBuffer buffer;
        Queue<ByteBuffer> queue = this.getWriteQueue(key);
        int ops = 1;
        while (queue != null && (buffer = queue.peek()) != null) {
            int length = buffer.remaining();
            int written = ((SocketChannel)key.channel()).write(buffer);
            if (written < length) {
                ops |= 4;
                break;
            }
            queue.poll();
        }
        key.interestOps(ops);
    }
}

