/*
 * Decompiled with CFR 0.152.
 */
package com.github.rzymek.opczip.reader.skipping;

import com.github.rzymek.opczip.reader.skipping.ExactIO;
import com.github.rzymek.opczip.reader.skipping.SignatureMatcher;
import com.github.rzymek.opczip.reader.skipping.ZipReadSpec;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

class CompressedEntryInputStream
extends FilterInputStream {
    private final SignatureMatcher cen = new SignatureMatcher(ZipReadSpec.CEN);
    private final SignatureMatcher lfh = new SignatureMatcher(ZipReadSpec.LFH);
    private final SignatureMatcher dat = new SignatureMatcher(ZipReadSpec.DAT);
    private final ZipEntry entry;
    private final boolean expectingDatSig;
    private boolean endOfEntry = false;
    int count = 0;
    CRC32 crc32 = new CRC32();

    public CompressedEntryInputStream(PushbackInputStream in, ZipEntry entry, boolean expectingDatSig) {
        super(in);
        this.entry = entry;
        this.expectingDatSig = expectingDatSig;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        return read == 1 ? b[0] : read;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.endOfEntry) {
            return -1;
        }
        if (this.entry.getCompressedSize() > 0L) {
            long leftToRead = this.entry.getCompressedSize() - (long)this.count;
            if (leftToRead <= 0L) {
                return -1;
            }
            int readCount = super.read(buf, off, (int)Math.min((long)len, leftToRead));
            if (readCount > 0) {
                this.count += readCount;
                this.crc(buf, off, readCount);
            }
            return readCount;
        }
        int readCount = super.read(buf, off, len);
        this.crc(buf, off, readCount);
        for (int i = 0; i < len; ++i) {
            byte currentByte = buf[off + i];
            if (this.expectingDatSig && this.dat.matchNext(currentByte)) {
                this.eof(buf, off, len, i - ZipReadSpec.DAT.length() + 1);
                ExactIO.skipExactly(this.in, 16L);
                return i - ZipReadSpec.DAT.length() + 1;
            }
            if (!this.lfh.matchNext(currentByte) && !this.cen.matchNext(currentByte)) continue;
            this.eof(buf, off, len, i - ZipReadSpec.LFH.length() + 1);
            return i - ZipReadSpec.LFH.length() + 1;
        }
        return readCount;
    }

    private void crc(byte[] buf, int off, int readCount) {
        if (this.entry.getCrc() > 0L) {
            this.crc32.update(buf, off, readCount);
        }
    }

    private void eof(byte[] buf, int off, int len, int i) throws IOException {
        ((PushbackInputStream)this.in).unread(buf, off + i, len - i);
        this.endOfEntry = true;
        if (this.entry.getCrc() != -1L && this.crc32.getValue() != this.entry.getCrc()) {
            throw new IOException("CRC32: Expecting " + this.entry.getCrc() + ". Got: " + this.crc32.getValue());
        }
        if (this.entry.getCompressedSize() != -1L && (long)this.count != this.entry.getCompressedSize()) {
            throw new IOException("Expecting compressed size " + this.entry.getCompressedSize() + ". Got: " + this.count);
        }
    }
}

