/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import com.sun.source.util.Trees;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.LazySortText;
import org.netbeans.modules.java.completion.Utilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.CompositeCompletionItem;
import org.netbeans.spi.editor.completion.LazyCompletionItem;

public abstract class LazyJavaCompletionItem<T extends Element>
extends JavaCompletionItem.WhiteListJavaCompletionItem<T>
implements LazyCompletionItem {
    private Source source;
    private JavaCompletionItem delegate = null;

    public static JavaCompletionItem createTypeItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, ReferencesCount referencesCount, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends, WhiteListQuery.WhiteList whiteList) {
        return new TypeItem(handle, kinds, substitutionOffset, referencesCount, source, insideNew, addTypeVars, afterExtends, whiteList);
    }

    public static JavaCompletionItem createStaticMemberItem(ElementHandle<TypeElement> handle, String name, int substitutionOffset, boolean addSemicolon, ReferencesCount referencesCount, Source source, WhiteListQuery.WhiteList whiteList) {
        return new StaticMemberItem(handle, name, substitutionOffset, addSemicolon, referencesCount, source, whiteList);
    }

    private LazyJavaCompletionItem(int substitutionOffset, ElementHandle<? extends Element> handle, Source source, WhiteListQuery.WhiteList whiteList) {
        super(substitutionOffset, handle, whiteList);
        this.source = source;
    }

    public boolean accept() {
        if (this.delegate == null && this.getElementHandle() != null) {
            try {
                JavaCompletionProvider.JavaCompletionQuery.javadocBreak.set(true);
                ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(LazyJavaCompletionItem.this.substitutionOffset));
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element t = LazyJavaCompletionItem.this.getElementHandle().resolve((CompilationInfo)controller);
                        if (t != null) {
                            ScopeHolder scopeHolder = (ScopeHolder)controller.getCachedValue(ScopeHolder.class);
                            if (scopeHolder == null || scopeHolder.pos != LazyJavaCompletionItem.this.substitutionOffset) {
                                scopeHolder = new ScopeHolder(LazyJavaCompletionItem.this.substitutionOffset, controller.getTrees().getScope(controller.getTreeUtilities().pathFor(LazyJavaCompletionItem.this.substitutionOffset)));
                                controller.putCachedValue(ScopeHolder.class, (Object)scopeHolder, CompilationInfo.CacheClearPolicy.ON_CHANGE);
                            }
                            LazyJavaCompletionItem.this.delegate = LazyJavaCompletionItem.this.getDelegate((CompilationInfo)controller, scopeHolder.scope, t);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    protected abstract JavaCompletionItem getDelegate(CompilationInfo var1, Scope var2, T var3);

    protected JavaCompletionItem getDelegate() {
        return this.delegate;
    }

    @Override
    public void defaultAction(JTextComponent component) {
        if (this.delegate != null) {
            this.delegate.defaultAction(component);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(evt);
        }
    }

    @Override
    public int getPreferredWidth(Graphics g, Font defaultFont) {
        if (this.delegate != null) {
            return this.delegate.getPreferredWidth(g, defaultFont);
        }
        return 0;
    }

    @Override
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (this.delegate != null) {
            this.delegate.render(g, defaultFont, defaultColor, backgroundColor, width, height, selected);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    static class TypeItem
    extends LazyJavaCompletionItem<TypeElement>
    implements CompositeCompletionItem {
        private EnumSet<ElementKind> kinds;
        private boolean insideNew;
        private boolean addTypeVars;
        private boolean afterExtends;
        private String name;
        private String simpleName;
        private String pkgName;
        private CharSequence sortText;
        private ReferencesCount referencesCount;

        private TypeItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, ReferencesCount referencesCount, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, handle, source, whiteList);
            this.kinds = kinds;
            this.insideNew = insideNew;
            this.addTypeVars = addTypeVars;
            this.afterExtends = afterExtends;
            this.name = handle.getQualifiedName();
            int idx = this.name.lastIndexOf(46);
            this.simpleName = idx > -1 ? this.name.substring(idx + 1) : this.name;
            this.pkgName = idx > -1 ? this.name.substring(0, idx) : "";
            this.sortText = new LazySortText(this.simpleName, this.pkgName, handle, referencesCount);
            this.referencesCount = referencesCount;
        }

        @Override
        protected JavaCompletionItem getDelegate(CompilationInfo info, Scope scope, TypeElement te) {
            Elements elements = info.getElements();
            if (!(te == null || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(te) || !info.getTrees().isAccessible(scope, te) || !this.isOfKind(te, this.kinds) || this.afterExtends && te.getModifiers().contains((Object)Modifier.FINAL) || this.isInDefaultPackage(te) && !this.isInDefaultPackage(scope.getEnclosingClass()) || Utilities.isExcluded((CharSequence)te.getQualifiedName()))) {
                return TypeItem.createTypeItem(info, te, (DeclaredType)te.asType(), this.substitutionOffset, this.referencesCount, elements.isDeprecated(te), this.insideNew, this.addTypeVars, false, false, false, this.getWhiteList());
            }
            return null;
        }

        public int getSortPriority() {
            return 700;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public List<? extends CompletionItem> getSubItems() {
            return this.getDelegate() instanceof CompositeCompletionItem ? ((CompositeCompletionItem)this.getDelegate()).getSubItems() : Collections.emptyList();
        }

        public String toString() {
            return this.name;
        }

        private boolean isOfKind(Element e, EnumSet<ElementKind> kinds) {
            if (kinds.contains((Object)e.getKind())) {
                return true;
            }
            for (Element element : e.getEnclosedElements()) {
                if (!this.isOfKind(element, kinds)) continue;
                return true;
            }
            return false;
        }

        private boolean isInDefaultPackage(Element e) {
            while (e != null && e.getKind() != ElementKind.PACKAGE) {
                e = e.getEnclosingElement();
            }
            return e != null && e.getSimpleName().length() == 0;
        }
    }

    private static class StaticMemberItem
    extends LazyJavaCompletionItem<TypeElement> {
        private boolean addSemicolon;
        private String name;
        private CharSequence sortText;

        private StaticMemberItem(ElementHandle<TypeElement> handle, String name, int substitutionOffset, boolean addSemicolon, ReferencesCount referencesCount, Source source, WhiteListQuery.WhiteList whiteList) {
            super(substitutionOffset, handle, source, whiteList);
            this.name = name;
            this.sortText = new LazySortText(this.name, handle.getQualifiedName(), handle, referencesCount);
            this.addSemicolon = addSemicolon;
        }

        @Override
        protected JavaCompletionItem getDelegate(CompilationInfo info, Scope scope, TypeElement te) {
            Elements elements = info.getElements();
            Trees trees = info.getTrees();
            if (te != null) {
                Element element = null;
                boolean multiVersion = false;
                for (Element element2 : te.getEnclosedElements()) {
                    if (!element2.getKind().isField() && element2.getKind() != ElementKind.METHOD || !this.name.contentEquals(Utilities.isCaseSensitive() ? element2.getSimpleName() : element2.getSimpleName().toString().toLowerCase()) || !element2.getModifiers().contains((Object)Modifier.STATIC) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element2) || !trees.isAccessible(scope, element2, (DeclaredType)te.asType())) continue;
                    if (element != null) {
                        multiVersion = true;
                        break;
                    }
                    element = element2;
                }
                if (element != null) {
                    this.name = element.getSimpleName().toString();
                    return StaticMemberItem.createStaticMemberItem(info, (DeclaredType)te.asType(), element, element.asType(), multiVersion, this.substitutionOffset, elements.isDeprecated(element), this.addSemicolon, this.getWhiteList());
                }
            }
            return null;
        }

        public int getSortPriority() {
            return 710;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.name;
        }
    }

    private static class ScopeHolder {
        private int pos;
        private Scope scope;

        private ScopeHolder(int pos, Scope scope) {
            this.pos = pos;
            this.scope = scope;
        }
    }
}

