/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.openfile.Bundle;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.RecentFiles;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class RecentFilesWidget
implements DashboardWidget {
    private static final RequestProcessor RP = new RequestProcessor("RecentFiles");
    private static final int MAX_FILES = 5;
    private final List<WidgetElement> elements = new ArrayList<WidgetElement>();
    private final List<FileInfo> files = new ArrayList<FileInfo>();
    private final Set<DashboardDisplayer.Panel> active = new HashSet<DashboardDisplayer.Panel>();
    private final PropertyChangeListener filesListener = e -> this.loadFiles();
    private final Action newFile;
    private final Action openFile;

    public RecentFilesWidget() {
        Action newFileOriginal = Actions.forID((String)"Project", (String)"org.netbeans.modules.project.ui.NewFile");
        this.newFile = newFileOriginal != null ? new FilesDelegateAction(newFileOriginal) : null;
        Action openFileOriginal = Actions.forID((String)"System", (String)"org.netbeans.modules.openfile.OpenFileAction");
        this.openFile = openFileOriginal != null ? new FilesDelegateAction(openFileOriginal) : null;
        this.buildElements();
        this.loadFiles();
    }

    public String title(DashboardDisplayer.Panel panel) {
        return Bundle.TITLE_RecentFiles();
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel panel) {
        return List.copyOf(this.elements);
    }

    public void showing(DashboardDisplayer.Panel panel) {
        if (this.active.isEmpty()) {
            RecentFiles.addPropertyChangeListener(this.filesListener);
        }
        this.active.add(panel);
        panel.refresh();
        this.loadFiles();
    }

    public void hidden(DashboardDisplayer.Panel panel) {
        this.active.remove(panel);
        if (this.active.isEmpty()) {
            RecentFiles.removePropertyChangeListener(this.filesListener);
        }
    }

    private void loadFiles() {
        RP.execute(() -> {
            ArrayList<FileInfo> files = new ArrayList<FileInfo>(5);
            for (RecentFiles.HistoryItem item : RecentFiles.getRecentFiles()) {
                File file = new File(item.getPath());
                if (!file.exists()) continue;
                Icon icon = item.getIcon();
                files.add(new FileInfo(file, icon));
                if (files.size() < 5) continue;
                break;
            }
            EventQueue.invokeLater(() -> this.updateFilesList(files));
        });
    }

    private void buildElements() {
        this.elements.clear();
        if (this.files.isEmpty()) {
            this.elements.add((WidgetElement)WidgetElement.unavailable((String)Bundle.LBL_NoRecentFiles()));
        } else {
            for (FileInfo info : this.files) {
                this.elements.add((WidgetElement)WidgetElement.actionLink((Action)new OpenFileAction(info)));
            }
        }
        if (this.newFile != null || this.openFile != null) {
            this.elements.add((WidgetElement)WidgetElement.separator());
        }
        if (this.newFile != null) {
            this.elements.add((WidgetElement)WidgetElement.actionLink((Action)this.newFile));
        }
        if (this.openFile != null) {
            this.elements.add((WidgetElement)WidgetElement.actionLink((Action)this.openFile));
        }
    }

    private void updateFilesList(List<FileInfo> files) {
        if (!this.files.equals(files)) {
            this.files.clear();
            this.files.addAll(files);
            this.buildElements();
            this.active.forEach(DashboardDisplayer.Panel::refresh);
        }
    }

    private static class FilesDelegateAction
    extends AbstractAction {
        private final Action delegate;

        private FilesDelegateAction(Action delegate) {
            super(Actions.cutAmpersand((String)String.valueOf(delegate.getValue("Name")).replace("...", "")));
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    private record FileInfo(File file, Icon icon) {
    }

    private static class OpenFileAction
    extends AbstractAction {
        private final FileInfo info;

        private OpenFileAction(FileInfo info) {
            super(info.file().getName(), info.icon());
            this.info = info;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File nf = FileUtil.normalizeFile((File)this.info.file());
            String msg = OpenFile.open(FileUtil.toFileObject((File)nf), -1);
            if (msg != null) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }
    }
}

