/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.completion.support;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.completion.CompletionSupportSpiPackageAccessor;
import org.netbeans.modules.editor.completion.PatchedHtmlRenderer;
import org.netbeans.modules.editor.completion.SimpleCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

public final class CompletionUtilities {
    private static final int BEFORE_ICON_GAP = 1;
    private static final int AFTER_ICON_GAP = 4;
    private static final int ICON_HEIGHT = 16;
    private static final int ICON_WIDTH = 16;
    private static final int BEFORE_RIGHT_TEXT_GAP = 5;
    private static final int AFTER_RIGHT_TEXT_GAP = 3;

    private CompletionUtilities() {
    }

    public static int getPreferredWidth(String leftHtmlText, String rightHtmlText, Graphics g, Font defaultFont) {
        int width = 24;
        if (leftHtmlText != null && leftHtmlText.length() > 0) {
            width += (int)PatchedHtmlRenderer.renderHTML(leftHtmlText, g, 0, 0, Integer.MAX_VALUE, 0, defaultFont, Color.black, 0, false, true);
        }
        if (rightHtmlText != null && rightHtmlText.length() > 0) {
            if (leftHtmlText != null) {
                width += 5;
            }
            width += (int)PatchedHtmlRenderer.renderHTML(rightHtmlText, g, 0, 0, Integer.MAX_VALUE, 0, defaultFont, Color.black, 0, false, true);
        }
        return width;
    }

    public static void renderHtml(ImageIcon icon, String leftHtmlText, String rightHtmlText, Graphics g, Font defaultFont, Color defaultColor, int width, int height, boolean selected) {
        if (icon != null) {
            g.drawImage(icon.getImage(), 1, (height - icon.getIconHeight()) / 2, null);
        }
        int iconWidth = 1 + (icon != null ? icon.getIconWidth() : 16) + 4;
        int rightTextX = width - 3;
        FontMetrics fm = g.getFontMetrics(defaultFont);
        int textY = (height - fm.getHeight()) / 2 + fm.getHeight() - fm.getDescent();
        if (rightHtmlText != null && rightHtmlText.length() > 0) {
            int rightTextWidth = (int)PatchedHtmlRenderer.renderHTML(rightHtmlText, g, 0, 0, Integer.MAX_VALUE, 0, defaultFont, defaultColor, 0, false, true);
            rightTextX = Math.max(iconWidth, rightTextX - rightTextWidth);
            PatchedHtmlRenderer.renderHTML(rightHtmlText, g, rightTextX, textY, rightTextWidth, textY, defaultFont, defaultColor, 0, true, selected);
            rightTextX = Math.max(iconWidth, rightTextX - 5);
        }
        if (leftHtmlText != null && leftHtmlText.length() > 0 && rightTextX > iconWidth) {
            PatchedHtmlRenderer.renderHTML(leftHtmlText, g, iconWidth, textY, rightTextX - iconWidth, textY, defaultFont, defaultColor, 1, true, selected);
        }
    }

    public static CompletionItemBuilder newCompletionItemBuilder(String insertText) {
        return new CompletionItemBuilder(insertText);
    }

    static {
        CompletionSupportSpiPackageAccessor.register(new SpiAccessor());
    }

    public static final class CompletionItemBuilder {
        private String insertText;
        private int startOffset = -1;
        private int endOffset = -1;
        private String iconResource;
        private String leftHtmlText;
        private String rightHtmlText;
        private int sortPriority = 10000;
        private CharSequence sortText;
        private Supplier<CompletionTask> documentationTask;
        private Supplier<CompletionTask> tooltipTask;
        private Consumer<OnSelectContext> onSelectCallback;

        private CompletionItemBuilder(String insertText) {
            this.insertText = insertText;
        }

        public CompletionItemBuilder insertText(String insertText) {
            this.insertText = insertText;
            return this;
        }

        public CompletionItemBuilder startOffset(int offset) {
            this.startOffset = offset;
            return this;
        }

        public CompletionItemBuilder endOffset(int offset) {
            this.endOffset = offset;
            return this;
        }

        public CompletionItemBuilder iconResource(String iconResource) {
            this.iconResource = iconResource;
            return this;
        }

        public CompletionItemBuilder leftHtmlText(String leftHtmlText) {
            this.leftHtmlText = leftHtmlText;
            return this;
        }

        public CompletionItemBuilder rightHtmlText(String rightHtmlText) {
            this.rightHtmlText = rightHtmlText;
            return this;
        }

        public CompletionItemBuilder sortPriority(int sortPriority) {
            this.sortPriority = sortPriority;
            return this;
        }

        public CompletionItemBuilder sortText(CharSequence sortText) {
            this.sortText = sortText;
            return this;
        }

        public CompletionItemBuilder documentationTask(Supplier<CompletionTask> task) {
            this.documentationTask = task;
            return this;
        }

        public CompletionItemBuilder tooltipTask(Supplier<CompletionTask> task) {
            this.tooltipTask = task;
            return this;
        }

        public CompletionItemBuilder onSelect(Consumer<OnSelectContext> callback) {
            this.onSelectCallback = callback;
            return this;
        }

        public CompletionItem build() {
            return new SimpleCompletionItem(this.insertText, this.startOffset, this.endOffset, this.iconResource, this.leftHtmlText, this.rightHtmlText, this.sortPriority, this.sortText, this.documentationTask, this.tooltipTask, this.onSelectCallback);
        }
    }

    private static final class SpiAccessor
    extends CompletionSupportSpiPackageAccessor {
        private SpiAccessor() {
        }

        @Override
        public OnSelectContext createOnSelectContext(JTextComponent component, boolean overwrite) {
            return new OnSelectContext(component, overwrite);
        }
    }

    public static final class OnSelectContext {
        private final JTextComponent component;
        private final boolean overwrite;

        private OnSelectContext(JTextComponent component, boolean overwrite) {
            this.component = component;
            this.overwrite = overwrite;
        }

        public JTextComponent getComponent() {
            return this.component;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }
    }
}

