/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.Constants;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.ModuleMBean;

public class JvmOptions
extends ModuleMBean
implements Constants {
    private ObjectName configObjName = null;
    private boolean isServerEightOne = true;

    public JvmOptions(MBeanServerConnection in_conn) {
        super(in_conn);
        this.runtimeObjName = this.configObjName = this.createConfigObjectName();
    }

    public JvmOptions(ObjectName objName, MBeanServerConnection in_conn) {
        super(objName, in_conn);
        this.configObjName = this.createConfigObjectName();
    }

    public JvmOptions(ObjectName objName, MBeanServerConnection in_conn, boolean in_isServerEightOne) {
        super(objName, in_conn);
        this.configObjName = this.createConfigObjectName();
        this.isServerEightOne = in_isServerEightOne;
    }

    private ObjectName createConfigObjectName() {
        ObjectName configName = null;
        try {
            configName = new ObjectName("com.sun.appserv:type=java-config,config=server-config,category=config");
        }
        catch (Exception ex) {
            return null;
        }
        return configName;
    }

    public ObjectName getConfigObjectName() {
        return this.configObjName;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attList = null;
        try {
            String addrValue = this.getAddressValue();
            Attribute jpdaAttr = null;
            if (this.isSharedMemory()) {
                if (this.isWindows()) {
                    jpdaAttr = new Attribute("shared_memory", addrValue);
                } else {
                    Attribute newAttr = new Attribute("debug-options", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=11000");
                    this.setAttribute(newAttr);
                    Integer value = 11000;
                    jpdaAttr = new Attribute("jpda_port_number", value);
                }
            } else {
                Integer value = new Integer(addrValue);
                jpdaAttr = new Attribute("jpda_port_number", value);
            }
            attList = this.conn.getAttributes(this.configObjName, attributes);
            attList.add(jpdaAttr);
        }
        catch (Exception ex) {
            return attList;
        }
        return attList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo updatedInfo = null;
        try {
            MBeanInfo newInfo = this.conn.getMBeanInfo(this.configObjName);
            MBeanAttributeInfo[] newAttrInfo = newInfo.getAttributes();
            int size = newAttrInfo.length + 1;
            MBeanAttributeInfo[] updatedAttrInfo = new MBeanAttributeInfo[size];
            for (int i = 0; i < newAttrInfo.length; ++i) {
                updatedAttrInfo[i] = newAttrInfo[i];
            }
            updatedAttrInfo[size - 1] = this.isSharedMemory() && this.isWindows() ? new MBeanAttributeInfo("shared_memory", "java.lang.String", "Shared Memory", true, true, false) : new MBeanAttributeInfo("jpda_port_number", "int", "JPDA port number", true, true, false);
            updatedInfo = new MBeanInfo(newInfo.getClassName(), newInfo.getDescription(), updatedAttrInfo, newInfo.getConstructors(), newInfo.getOperations(), newInfo.getNotifications());
        }
        catch (Exception ex) {
            return updatedInfo;
        }
        return updatedInfo;
    }

    @Override
    public void setAttribute(Attribute attribute) throws RemoteException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (attribute.getName().equals("jpda_port_number")) {
            if (attribute.getValue() != null) {
                this.setAddressValue(attribute.getValue().toString());
            }
        } else if (attribute.getName().equals("shared_memory")) {
            if (attribute.getValue() != null) {
                this.setAddressValue(attribute.getValue().toString());
            }
        } else if (attribute.getName().equals("debug-options")) {
            if (attribute.getValue() != null && attribute.getValue().toString().indexOf("transport=dt_shmem") == -1) {
                this.conn.setAttribute(this.configObjName, attribute);
            } else if (this.isWindows()) {
                this.conn.setAttribute(this.configObjName, attribute);
            }
        } else {
            this.conn.setAttribute(this.configObjName, attribute);
        }
    }

    private String getDebugOptions() {
        String debugOptionsAttr = this.getConfigAttributeValue("debug-options");
        String debugOptionsVal = null;
        if (debugOptionsAttr != null) {
            debugOptionsVal = debugOptionsAttr.toString().trim();
        }
        return debugOptionsVal;
    }

    public String getAddressValue() {
        int hasMore;
        String debugOptionsVal = this.getDebugOptions();
        if (debugOptionsVal != null && (hasMore = (debugOptionsVal = debugOptionsVal.substring(debugOptionsVal.indexOf("address=") + "address=".length(), debugOptionsVal.length())).indexOf(",")) != -1) {
            debugOptionsVal = debugOptionsVal.substring(0, hasMore);
        }
        return debugOptionsVal;
    }

    public void setAddressValue(String portNumber) {
        try {
            String debugOptionsVal = this.getDebugOptions();
            String debugOptionsStart = debugOptionsVal.substring(0, debugOptionsVal.indexOf("address=") + "address=".length());
            debugOptionsStart = debugOptionsStart + portNumber;
            String inMiddle = debugOptionsVal.substring(debugOptionsVal.indexOf("address=") + "address=".length(), debugOptionsVal.length());
            int hasMore = inMiddle.indexOf(",");
            if (hasMore != -1) {
                String debugOptionsEnd = inMiddle.substring(hasMore);
                debugOptionsStart = debugOptionsStart + debugOptionsEnd;
            }
            Attribute newAttr = new Attribute("debug-options", debugOptionsStart);
            this.setAttribute(newAttr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getClassPath() {
        String serverClassPath = this.getConfigAttributeValue("server_classpath");
        return serverClassPath;
    }

    public void setClassPath(String classpath) {
        try {
            Attribute classPathAttr = new Attribute("server_classpath", classpath);
            this.setAttribute(classPathAttr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getConfigAttributeValue(String attributeName) {
        return super.getAttribute(this.configObjName, attributeName);
    }

    public boolean isSharedMemory() {
        boolean isShared;
        block10: {
            isShared = false;
            String debugOpt = this.getDebugOptions();
            if (debugOpt.indexOf("transport=dt_shmem") == -1 && debugOpt.indexOf("transport=dt_socket") == -1) {
                try {
                    Attribute attr = null;
                    attr = this.isServerEightOne ? new Attribute("debug-options", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=9009") : new Attribute("debug-options", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=1044");
                    this.setAttribute(attr);
                }
                catch (Exception attr) {}
            } else if (debugOpt.indexOf("transport=dt_socket") != -1) {
                String addrValue = this.getAddressValue();
                Integer value = null;
                try {
                    value = new Integer(addrValue);
                }
                catch (Exception ex) {
                    if (this.isServerEightOne) {
                        value = 9009;
                        this.setAddressValue("9009");
                        break block10;
                    }
                    value = 1044;
                    this.setAddressValue("1044");
                }
            } else if (debugOpt.indexOf("transport=dt_shmem") != -1) {
                return true;
            }
        }
        return isShared;
    }

    public boolean isWindows() {
        String javaHome = this.getConfigAttributeValue("java-home");
        if (javaHome == null) {
            return false;
        }
        try {
            String local_osName = System.getProperty("os.name");
            return local_osName.toLowerCase(Locale.ENGLISH).indexOf("windows") != -1;
        }
        catch (IndexOutOfBoundsException ee) {
            return false;
        }
    }

    public void setDefaultTransportForDebug(String addressVal) {
        Attribute newAttr = null;
        if (this.isWindows()) {
            String value = "-agentlib:jdwp=transport=dt_shmem,server=y,suspend=n,address=";
            value = addressVal != null ? value + addressVal : value + "defaultAddress";
            newAttr = new Attribute("debug-options", value);
        } else if (this.getAddressValue().equals("1044") || this.getAddressValue().equals("9009")) {
            newAttr = new Attribute("debug-options", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=11000");
        }
        try {
            if (newAttr != null) {
                this.setAttribute(newAttr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

