/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.javaee.project.api.ant.AntProjectUtil;
import org.netbeans.modules.web.project.WebProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ClassPathSupportCallbackImpl
implements ClassPathSupport.Callback {
    private AntProjectHelper helper;
    public static final String PATH_IN_DEPLOYMENT = "pathInDeployment";
    private static final String TAG_PATH_IN_WAR = "path-in-war";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_DIRS = "dirs";
    public static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    public static final String TAG_WEB_MODULE__ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
    public static final String PATH_IN_WAR_DIR = "WEB-INF/classes";
    public static final String PATH_IN_WAR_NONE = null;

    public ClassPathSupportCallbackImpl(AntProjectHelper helper) {
        this.helper = helper;
    }

    public void readAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        Map<String, String> warIncludesMap = ClassPathSupportCallbackImpl.createWarIncludesMap(this.helper, projectXMLElement);
        for (ClassPathSupport.Item item : items) {
            String property = CommonProjectUtils.getAntPropertyName((String)item.getReference());
            String deploymentPath = warIncludesMap.get(property);
            item.setAdditionalProperty(PATH_IN_DEPLOYMENT, deploymentPath);
            item.setAdditionalProperty("destinationDirectory", warIncludesMap.get(property + "." + "destinationDirectory"));
        }
    }

    public void storeAdditionalProperties(List<ClassPathSupport.Item> items, String projectXMLElement) {
        ClassPathSupportCallbackImpl.putIncludedLibraries(items, this.helper, projectXMLElement);
    }

    private static Map<String, String> createWarIncludesMap(AntProjectHelper uh, String webModuleLibraries) {
        LinkedHashMap<String, String> warIncludesMap = new LinkedHashMap<String, String>();
        for (int idx = WebProjectType.getConfigurationNamespaceList().length - 1; idx >= 0; --idx) {
            Element webModuleLibs;
            String ns = WebProjectType.getConfigurationNamespaceList()[idx];
            Element data = uh.createAuxiliaryConfiguration().getConfigurationFragment("data", ns, true);
            if (data == null || (webModuleLibs = (Element)data.getElementsByTagNameNS(ns, webModuleLibraries).item(0)) == null) continue;
            NodeList ch = webModuleLibs.getChildNodes();
            for (int i = 0; i < ch.getLength(); ++i) {
                if (ch.item(i).getNodeType() != 1) continue;
                Element library = (Element)ch.item(i);
                String dirs = library.getAttribute(ATTR_DIRS);
                if (!("100".equals(dirs) || "200".equals(dirs) || "300".equals(dirs))) {
                    dirs = null;
                }
                Node webFile = library.getElementsByTagNameNS(ns, TAG_FILE).item(0);
                NodeList pathInWarElements = library.getElementsByTagNameNS(ns, TAG_PATH_IN_WAR);
                String webFileText = XMLUtil.findText((Node)webFile);
                webFileText = webFileText.substring(2, webFileText.length() - 1);
                if (webModuleLibraries.equals(TAG_WEB_MODULE__ADDITIONAL_LIBRARIES)) {
                    String pathInWar = PATH_IN_WAR_NONE;
                    if (pathInWarElements.getLength() > 0 && (pathInWar = XMLUtil.findText((Node)((Element)pathInWarElements.item(0)))) == null) {
                        pathInWar = "";
                    }
                    warIncludesMap.put(webFileText, pathInWar);
                } else {
                    warIncludesMap.put(webFileText, pathInWarElements.getLength() > 0 ? XMLUtil.findText((Node)((Element)pathInWarElements.item(0))) : PATH_IN_WAR_NONE);
                }
                if (dirs == null) continue;
                warIncludesMap.put(webFileText + "." + "destinationDirectory", dirs);
            }
            return warIncludesMap;
        }
        return warIncludesMap;
    }

    private static void putIncludedLibraries(List<ClassPathSupport.Item> classpath, AntProjectHelper antProjectHelper, String webModuleLibraries) {
        assert (antProjectHelper != null);
        assert (webModuleLibraries != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element webModuleLibs = (Element)data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", webModuleLibraries).item(0);
        if (webModuleLibs == null) {
            webModuleLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", webModuleLibraries);
            data.appendChild(webModuleLibs);
        }
        while (webModuleLibs.hasChildNodes()) {
            webModuleLibs.removeChild(webModuleLibs.getChildNodes().item(0));
        }
        for (ClassPathSupport.Item item : classpath) {
            webModuleLibs.appendChild(ClassPathSupportCallbackImpl.createLibraryElement(antProjectHelper, doc, CommonProjectUtils.getAntPropertyName((String)item.getReference()), item));
        }
        antProjectHelper.putPrimaryConfigurationData(data, true);
    }

    private static Element createLibraryElement(AntProjectHelper antProjectHelper, Document doc, String pathItem, ClassPathSupport.Item item) {
        Element libraryElement = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_LIBRARY);
        Element webFile = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_FILE);
        libraryElement.appendChild(webFile);
        webFile.appendChild(doc.createTextNode("${" + pathItem + "}"));
        if (item.getAdditionalProperty(PATH_IN_DEPLOYMENT) != null) {
            Element pathInWar = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_PATH_IN_WAR);
            pathInWar.appendChild(doc.createTextNode(item.getAdditionalProperty(PATH_IN_DEPLOYMENT)));
            libraryElement.appendChild(pathInWar);
        }
        AntProjectUtil.updateDirsAttributeInCPSItem((ClassPathSupport.Item)item, (Element)libraryElement);
        return libraryElement;
    }
}

