/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.spi.IssuePriorityInfo;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.TaskAttribute;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.openide.util.NbBundle;

public class TaskSorter {
    private static TaskSorter instance;
    private List<TaskAttribute> attributes;
    private static final String PRIORITY_ID = "tasks.attribute.priority";
    private static final String STATUS_ID = "tasks.attribute.status";
    private static final String TASKID_ID = "tasks.attribute.taskid";
    private static final String SCHEDULED_ID = "tasks.attribute.scheduled";

    public static TaskSorter getInstance() {
        if (instance == null) {
            instance = new TaskSorter();
        }
        return instance;
    }

    private TaskSorter() {
        this.initAttributes();
        this.updateAttributes();
    }

    public Comparator<TaskNode> getComparator() {
        return new TaskComparator();
    }

    public List<TaskAttribute> getAttributes() {
        return this.getClonedAttributes();
    }

    public void setAttributes(List<TaskAttribute> attributes) {
        this.attributes = attributes;
        DashboardSettings.getInstance().setSortingAttributes(attributes);
    }

    private void updateAttributes() {
        DashboardSettings.getInstance().updateSortingAttributes(this.attributes);
        Collections.sort(this.attributes);
    }

    private List<TaskAttribute> getClonedAttributes() {
        ArrayList<TaskAttribute> cloned = new ArrayList<TaskAttribute>(this.attributes.size());
        for (TaskAttribute taskAttribute : this.attributes) {
            cloned.add(taskAttribute.getClone());
        }
        return cloned;
    }

    private void initAttributes() {
        this.attributes = new ArrayList<TaskAttribute>();
        TaskAttribute priority = new TaskAttribute(PRIORITY_ID, NbBundle.getMessage(TaskSorter.class, (String)"LBL_PriorityDisplayName"), new Comparator<TaskNode>(){

            @Override
            public int compare(TaskNode tn1, TaskNode tn2) {
                String priority1 = tn1.getTask().getPriority();
                int rank1 = this.getIndexOf(tn1.getTask().getRepositoryImpl().getPriorityInfos(), priority1);
                String priority2 = tn2.getTask().getPriority();
                int rank2 = this.getIndexOf(tn2.getTask().getRepositoryImpl().getPriorityInfos(), priority2);
                return Integer.compare(rank2, rank1);
            }

            private int getIndexOf(IssuePriorityInfo[] priorityInfos, String priorityName) {
                for (int i = 0; i < priorityInfos.length; ++i) {
                    IssuePriorityInfo issuePriorityInfo = priorityInfos[i];
                    if (!issuePriorityInfo.getDisplayName().equals(priorityName)) continue;
                    return i;
                }
                return Integer.MAX_VALUE;
            }
        });
        priority.setRank(1);
        priority.setAsceding(false);
        this.attributes.add(priority);
        TaskAttribute status = new TaskAttribute(STATUS_ID, NbBundle.getMessage(TaskSorter.class, (String)"LBL_StatusDisplayName"), new Comparator<TaskNode>(){

            @Override
            public int compare(TaskNode tn1, TaskNode tn2) {
                return tn1.getTask().getStatus().compareTo(tn2.getTask().getStatus());
            }
        });
        status.setRank(2);
        status.setAsceding(true);
        this.attributes.add(status);
        TaskAttribute scheduled = new TaskAttribute(SCHEDULED_ID, NbBundle.getMessage(TaskSorter.class, (String)"LBL_ScheduledDisplayName"), new ScheduleComparator());
        scheduled.setRank(3);
        scheduled.setAsceding(true);
        this.attributes.add(scheduled);
        TaskAttribute taskId = new TaskAttribute(TASKID_ID, NbBundle.getMessage(TaskSorter.class, (String)"LBL_TaskidDisplayName"), new Comparator<TaskNode>(){

            @Override
            public int compare(TaskNode tn1, TaskNode tn2) {
                return DashboardUtils.compareTaskIds(tn1.getTask().getID(), tn2.getTask().getID());
            }
        });
        taskId.setRank(4);
        taskId.setAsceding(false);
        this.attributes.add(taskId);
    }

    public static Comparator<TaskNode> getScheduleComparator() {
        return new ScheduleComparator();
    }

    private class TaskComparator
    implements Comparator<TaskNode> {
        private TaskComparator() {
        }

        @Override
        public int compare(TaskNode t1, TaskNode t2) {
            for (TaskAttribute taskAttribute : TaskSorter.this.attributes) {
                int compare = taskAttribute.compare(t1, t2);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }

    private static class ScheduleComparator
    implements Comparator<TaskNode> {
        private ScheduleComparator() {
        }

        @Override
        public int compare(TaskNode tn1, TaskNode tn2) {
            int scheduleIndex1 = DashboardUtils.getScheduleIndex(tn1.getTask());
            int scheduleIndex2 = DashboardUtils.getScheduleIndex(tn2.getTask());
            return -Integer.compare(scheduleIndex1, scheduleIndex2);
        }
    }
}

