/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.netbeans.ProxyClassPackages;
import org.netbeans.ProxyClassParents;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public class ProxyClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private static final boolean LOG_LOADING;
    private static final ClassLoader TOP_CL;
    private final ConcurrentMap<String, Package> packages = new ConcurrentHashMap<String, Package>();
    volatile ProxyClassParents parents;
    private BiFunction<String, ClassLoader, Boolean> delegatingPredicate;
    private static final Set<String> arbitraryLoadWarnings;
    private static ConcurrentMap<String, Boolean> sclPackages;

    public ProxyClassLoader(ClassLoader[] parents, boolean transitive) {
        super(TOP_CL);
        this.parents = ProxyClassParents.coalesceParents(this, parents, TOP_CL, transitive);
    }

    public ProxyClassLoader(ClassLoader[] parents, boolean transitive, BiFunction<String, ClassLoader, Boolean> delegatingPredicate) {
        super(TOP_CL);
        this.parents = ProxyClassParents.coalesceParents(this, parents, TOP_CL, transitive);
        this.delegatingPredicate = delegatingPredicate;
    }

    protected final void addCoveredPackages(Iterable<String> coveredPackages) {
        ProxyClassPackages.addCoveredPackages(this, coveredPackages);
    }

    public void append(ClassLoader[] nueparents) throws IllegalArgumentException {
        if (nueparents == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (ClassLoader cl : nueparents) {
            if (cl != null) continue;
            throw new IllegalArgumentException("null parent: " + Arrays.asList(nueparents));
        }
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        this.parents = moduleFactory != null && moduleFactory.removeBaseClassLoader() ? ProxyClassParents.coalesceParents(this, nueparents, ClassLoader.getSystemClassLoader(), this.parents.isTransitive()) : this.parents.append(this, nueparents);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.doFindClass(name);
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        LOGGER.log(Level.FINEST, "{0} finding class {1}", new Object[]{this, name});
        return this.doFindClass(name);
    }

    private Class<?> doFindClass(String name) throws ClassNotFoundException {
        if (LOG_LOADING && !name.startsWith("java.")) {
            LOGGER.log(Level.FINEST, "{0} initiated loading of {1}", new Object[]{this, name});
        }
        Class<?> cls = null;
        int last = name.lastIndexOf(46);
        if (last == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + name + ")");
        }
        String pkg = last >= 0 ? name.substring(0, last) : "";
        String path = pkg.replace('.', '/') + "/";
        Set<ProxyClassLoader> del = ProxyClassPackages.findCoveredPkg(pkg);
        Boolean boo = ProxyClassLoader.isSystemPackage(pkg);
        if ((boo == null || boo.booleanValue()) && this.shouldDelegateResource(path, null)) {
            try {
                cls = this.parents.systemCL().loadClass(name);
                if (boo == null) {
                    ProxyClassLoader.registerSystemPackage(pkg, true);
                }
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (del != null) {
            if (del.size() == 1) {
                ProxyClassLoader pcl = del.iterator().next();
                if ((pcl == this || this.parents.contains(pcl) && this.shouldDelegateResource(path, pcl)) && (cls = super.selfLoadClass(pkg, name)) != null) {
                    ProxyClassLoader.registerSystemPackage(pkg, false);
                }
            } else {
                for (ProxyClassLoader pcl : this.parents.loaders()) {
                    Class<?> _cls;
                    if (!del.contains(pcl) || !this.shouldDelegateResource(path, pcl) || (_cls = pcl.selfLoadClass(pkg, name)) == null) continue;
                    if (cls == null) {
                        cls = _cls;
                        continue;
                    }
                    if (cls == _cls) continue;
                    String message = "Will not load class " + name + " arbitrarily from one of " + cls.getClassLoader() + " and " + pcl + " starting from " + this + "; see http://wiki.netbeans.org/DevFaqModuleCCE";
                    ClassNotFoundException cnfe = new ClassNotFoundException(message);
                    if (arbitraryLoadWarnings.add(message)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, null, cnfe);
                        } else {
                            LOGGER.warning(message);
                        }
                    }
                    throw cnfe;
                }
                if (cls == null && del.contains(this)) {
                    cls = this.selfLoadClass(pkg, name);
                }
                if (cls != null) {
                    ProxyClassLoader.registerSystemPackage(pkg, false);
                }
            }
        }
        if (cls == null && this.shouldDelegateResource(path, null)) {
            try {
                cls = this.parents.systemCL().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(this.diagnosticCNFEMessage(e.getMessage(), del), e);
            }
        }
        if (cls == null) {
            throw new ClassNotFoundException(this.diagnosticCNFEMessage(name, del));
        }
        return cls;
    }

    private String diagnosticCNFEMessage(String base, Set<ProxyClassLoader> del) {
        int size = this.parents.size();
        StringBuilder b = new StringBuilder();
        b.append(base).append(" starting from ").append(this).append(" with possible defining loaders ").append(del).append(" and declared parents ");
        Iterator<ProxyClassLoader> parentSetI = this.parents.loaders().iterator();
        for (int i = 0; i < 10 && parentSetI.hasNext(); ++i) {
            b.append(i == 0 ? "[" : ", ");
            b.append(parentSetI.next());
        }
        if (parentSetI.hasNext()) {
            b.append(", ...").append(size - 10).append(" more");
        }
        b.append(']');
        return b.toString();
    }

    private synchronized Class<?> selfLoadClass(String pkg, String name) {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            try {
                cls = this.doLoadClass(pkg, name);
            }
            catch (NoClassDefFoundError e) {
                throw (NoClassDefFoundError)new NoClassDefFoundError(e.getMessage() + " while loading " + name + "; see http://wiki.netbeans.org/DevFaqTroubleshootClassNotFound").initCause(e);
            }
            if (LOG_LOADING && !name.startsWith("java.")) {
                LOGGER.log(Level.FINEST, "{0} loaded {1}", new Object[]{this, name});
            }
        }
        return cls;
    }

    protected Class<?> doLoadClass(String pkg, String name) {
        return null;
    }

    private String stripInitialSlash(String resource) {
        if (resource.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", resource);
            return resource.substring(1);
        }
        return resource;
    }

    @Override
    public final URL getResource(String name) {
        return this.getResourceImpl(name);
    }

    URL getResourceImpl(String name) {
        Set<ProxyClassLoader> snd;
        URL u;
        String pkg;
        URL url = null;
        name = this.stripInitialSlash(name);
        int last = name.lastIndexOf(47);
        String fallDef = null;
        if (last >= 0) {
            if (name.startsWith("META-INF/")) {
                pkg = name.substring(8);
                fallDef = name.substring(0, last).replace('/', '.');
            } else {
                pkg = name.substring(0, last).replace('/', '.');
            }
        } else {
            pkg = "default/" + name;
            fallDef = "";
        }
        String path = name.substring(0, last + 1);
        Boolean systemPackage = ProxyClassLoader.isSystemPackage(pkg);
        if ((systemPackage == null || systemPackage.booleanValue()) && this.shouldDelegateResource(path, null) && (u = this.parents.systemCL().getResource(name)) != null) {
            if (systemPackage == null) {
                ProxyClassLoader.registerSystemPackage(pkg, true);
            }
            return u;
        }
        Set<ProxyClassLoader> del = ProxyClassPackages.findCoveredPkg(pkg);
        if (fallDef != null && (snd = ProxyClassPackages.findCoveredPkg(fallDef)) != null) {
            if (del != null) {
                del = new HashSet<ProxyClassLoader>(del);
                del.addAll(snd);
            } else {
                del = snd;
            }
        }
        if (del == null) {
            if (this.shouldDelegateResource(path, null)) {
                url = this.parents.systemCL().getResource(name);
            }
        } else if (del.size() == 1) {
            ProxyClassLoader pcl = del.iterator().next();
            if (pcl == this || this.parents.contains(pcl) && this.shouldDelegateResource(path, pcl)) {
                url = pcl.findResource(name);
            }
        } else {
            ProxyClassLoader pcl;
            Iterator<ProxyClassLoader> iterator = this.parents.loaders().iterator();
            while (!(!iterator.hasNext() || del.contains(pcl = iterator.next()) && this.shouldDelegateResource(path, pcl) && (url = pcl.findResource(name)) != null)) {
            }
            if (url == null && del.contains(this)) {
                url = this.findResource(name);
            }
        }
        if (url == null && this.shouldDelegateResource(path, null)) {
            url = this.parents.systemCL().getResource(name);
        }
        return url;
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        return this.getResourcesImpl(name);
    }

    synchronized Enumeration<URL> getResourcesImpl(String name) throws IOException {
        Set<ProxyClassLoader> snd;
        String pkg;
        name = this.stripInitialSlash(name);
        int slashIdx = name.lastIndexOf(47);
        String path = name.substring(0, slashIdx + 1);
        String fallDef = null;
        if (slashIdx >= 0) {
            if (name.startsWith("META-INF/")) {
                pkg = name.substring(8);
                fallDef = name.substring(0, slashIdx).replace('/', '.');
            } else {
                pkg = name.substring(0, slashIdx).replace('/', '.');
            }
        } else {
            pkg = "default/" + name;
            fallDef = "";
        }
        ArrayList<Enumeration<URL>> sub = new ArrayList<Enumeration<URL>>();
        if (this.shouldDelegateResource(path, null)) {
            sub.add(this.parents.systemCL().getResources(name));
        }
        Set<ProxyClassLoader> del = ProxyClassPackages.findCoveredPkg(pkg);
        if (fallDef != null && (snd = ProxyClassPackages.findCoveredPkg(fallDef)) != null) {
            if (del != null) {
                del = new HashSet<ProxyClassLoader>(del);
                del.addAll(snd);
            } else {
                del = snd;
            }
        }
        if (del != null) {
            for (ProxyClassLoader pcl : this.parents.loaders()) {
                if (!del.contains(pcl) || !this.shouldDelegateResource(path, pcl)) continue;
                sub.add(pcl.findResources(name));
            }
            if (del.contains(this)) {
                sub.add(this.findResources(name));
            }
        }
        return Enumerations.concat(Collections.enumeration(sub));
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    protected Package getPackage(String name) {
        return this.getPackageFast(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String name, boolean recurse) {
        Package pkg = (Package)this.packages.get(name);
        if (pkg != null) {
            return pkg;
        }
        if (!recurse) {
            return null;
        }
        ConcurrentMap<String, Package> concurrentMap = this.packages;
        synchronized (concurrentMap) {
            pkg = (Package)this.packages.get(name);
            String path = name.replace('.', '/');
            for (ProxyClassLoader par : this.parents.loaders()) {
                if (this.shouldDelegateResource(path, par) && (pkg = par.getPackageFast(name, false)) != null) break;
            }
            if (pkg == null && this.shouldDelegateResource(path + "/", null)) {
                pkg = super.getPackage(name);
            }
            if (pkg != null) {
                this.packages.put(name, pkg);
            }
            return pkg;
        }
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        this.packages.put(name, pkg);
        return pkg;
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package[] getPackages(Set<ClassLoader> addedParents) {
        HashMap<String, Package> all = new HashMap<String, Package>();
        this.addPackages(all, super.getPackages());
        for (ClassLoader classLoader : this.parents.loaders()) {
            if (!(classLoader instanceof ProxyClassLoader) || !addedParents.add(classLoader)) continue;
            this.addPackages(all, ((ProxyClassLoader)classLoader).getPackages(addedParents));
        }
        ConcurrentMap<String, Package> concurrentMap = this.packages;
        synchronized (concurrentMap) {
            all.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(all);
            return this.packages.values().toArray(new Package[this.packages.size()]);
        }
    }

    private void addPackages(Map<String, Package> all, Package[] pkgs) {
        for (int i = 0; i < pkgs.length; ++i) {
            all.put(pkgs[i].getName(), pkgs[i]);
        }
    }

    protected final void setSystemClassLoader(ClassLoader s) {
        this.parents = this.parents.changeSystemClassLoader(s);
    }

    protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
        if (this.delegatingPredicate != null) {
            return this.delegatingPredicate.apply(pkg, parent);
        }
        return true;
    }

    public void destroy() {
        ProxyClassPackages.removeCoveredPakcages(this);
    }

    final ClassLoader firstParent() {
        Iterator<ProxyClassLoader> it = this.parents.loaders().iterator();
        return it.hasNext() ? (ClassLoader)it.next() : null;
    }

    private static Boolean isSystemPackage(String pkg) {
        return (Boolean)sclPackages.get(pkg);
    }

    private static void registerSystemPackage(String pkg, boolean isSystemPkg) {
        sclPackages.put(pkg, isSystemPkg);
    }

    static {
        TOP_CL = ProxyClassLoader.class.getClassLoader();
        boolean prop1 = System.getProperty("org.netbeans.ProxyClassLoader.level") != null;
        LOG_LOADING = prop1 || LOGGER.isLoggable(Level.FINE);
        arbitraryLoadWarnings = ConcurrentHashMap.newKeySet();
        sclPackages = new ConcurrentHashMap<String, Boolean>();
    }
}

