/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.FPU;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.OperatingSystem;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.Verification;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.DiscoClient;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.MajorVersion;
import java.util.Objects;
import java.util.OptionalInt;

public class Pkg {
    public static final String FIELD_ID = "id";
    public static final String FIELD_ARCHIVE_TYPE = "archive_type";
    public static final String FIELD_DISTRIBUTION = "distribution";
    public static final String FIELD_MAJOR_VERSION = "major_version";
    public static final String FIELD_JAVA_VERSION = "java_version";
    public static final String FIELD_DISTRIBUTION_VERSION = "distribution_version";
    public static final String FIELD_LATEST_BUILD_AVAILABLE = "latest_build_available";
    public static final String FIELD_RELEASE_STATUS = "release_status";
    public static final String FIELD_TERM_OF_SUPPORT = "term_of_support";
    public static final String FIELD_OPERATING_SYSTEM = "operating_system";
    public static final String FIELD_LIB_C_TYPE = "lib_c_type";
    public static final String FIELD_ARCHITECTURE = "architecture";
    public static final String FIELD_BITNESS = "bitness";
    public static final String FIELD_FPU = "fpu";
    public static final String FIELD_PACKAGE_TYPE = "package_type";
    public static final String FIELD_JAVAFX_BUNDLED = "javafx_bundled";
    public static final String FIELD_DIRECTLY_DOWNLOADABLE = "directly_downloadable";
    public static final String FIELD_FILENAME = "filename";
    public static final String FIELD_EPHEMERAL_ID = "ephemeral_id";
    public static final String FIELD_FREE_USE_IN_PROD = "free_use_in_production";
    public static final String FIELD_TCK_TESTED = "tck_tested";
    public static final String FIELD_TCK_CERT_URI = "tck_cert_uri";
    public static final String FIELD_AQAVIT_CERTIFIED = "aqavit_certified";
    public static final String FIELD_AQAVIT_CERT_URI = "aqavit_cert_uri";
    public static final String FIELD_SIZE = "size";
    private String id;
    private String ephemeralId;
    private Distribution distribution;
    private MajorVersion majorVersion;
    private Semver javaVersion;
    private VersionNumber distributionVersion;
    private Architecture architecture;
    private FPU fpu;
    private OperatingSystem operatingSystem;
    private LibCType libcType;
    private PackageType packageType;
    private ReleaseStatus releaseStatus;
    private ArchiveType archiveType;
    private TermOfSupport termOfSupport;
    private Boolean javafxBundled;
    private Boolean latestBuildAvailable;
    private Boolean directlyDownloadable;
    private String fileName;
    private Boolean freeUseInProduction;
    private Verification tckTested;
    private String tckCertUri;
    private Verification aqavitCertified;
    private String aqavitCertUri;
    private long size;

    public Pkg(String packageJson) {
        if (null == packageJson || packageJson.isEmpty()) {
            throw new IllegalArgumentException("Package json string cannot be null or empty.");
        }
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(packageJson, JsonObject.class);
        this.id = json.has(FIELD_ID) ? json.get(FIELD_ID).getAsString() : "";
        this.distribution = json.has(FIELD_DISTRIBUTION) ? DiscoClient.getDistributionFromText(json.get(FIELD_DISTRIBUTION).getAsString()) : null;
        this.majorVersion = json.has(FIELD_MAJOR_VERSION) ? new MajorVersion(json.get(FIELD_MAJOR_VERSION).getAsInt()) : new MajorVersion(1);
        this.javaVersion = json.has(FIELD_JAVA_VERSION) ? Semver.fromText(json.get(FIELD_JAVA_VERSION).getAsString()).getSemver1() : new Semver(new VersionNumber());
        this.distributionVersion = json.has(FIELD_DISTRIBUTION) ? VersionNumber.fromText(json.get(FIELD_DISTRIBUTION_VERSION).getAsString()) : new VersionNumber();
        this.latestBuildAvailable = json.has(FIELD_LATEST_BUILD_AVAILABLE) ? json.get(FIELD_LATEST_BUILD_AVAILABLE).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.architecture = json.has(FIELD_ARCHITECTURE) ? Architecture.fromText(json.get(FIELD_ARCHITECTURE).getAsString()) : Architecture.NOT_FOUND;
        this.fpu = json.has(FIELD_FPU) ? FPU.fromText(json.get(FIELD_FPU).getAsString()) : FPU.NOT_FOUND;
        this.operatingSystem = json.has(FIELD_OPERATING_SYSTEM) ? OperatingSystem.fromText(json.get(FIELD_OPERATING_SYSTEM).getAsString()) : OperatingSystem.NOT_FOUND;
        this.libcType = json.has(FIELD_LIB_C_TYPE) ? LibCType.fromText(json.get(FIELD_LIB_C_TYPE).getAsString()) : LibCType.NOT_FOUND;
        this.packageType = json.has(FIELD_PACKAGE_TYPE) ? PackageType.fromText(json.get(FIELD_PACKAGE_TYPE).getAsString()) : PackageType.NOT_FOUND;
        this.releaseStatus = json.has(FIELD_RELEASE_STATUS) ? ReleaseStatus.fromText(json.get(FIELD_RELEASE_STATUS).getAsString()) : ReleaseStatus.NOT_FOUND;
        this.archiveType = json.has(FIELD_ARCHIVE_TYPE) ? ArchiveType.fromText(json.get(FIELD_ARCHIVE_TYPE).getAsString()) : ArchiveType.NOT_FOUND;
        this.termOfSupport = json.has(FIELD_TERM_OF_SUPPORT) ? TermOfSupport.fromText(json.get(FIELD_TERM_OF_SUPPORT).getAsString()) : TermOfSupport.NOT_FOUND;
        this.javafxBundled = json.has(FIELD_JAVAFX_BUNDLED) ? json.get(FIELD_JAVAFX_BUNDLED).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.directlyDownloadable = json.has(FIELD_DIRECTLY_DOWNLOADABLE) ? json.get(FIELD_DIRECTLY_DOWNLOADABLE).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.fileName = json.has(FIELD_FILENAME) ? json.get(FIELD_FILENAME).getAsString() : "";
        this.ephemeralId = json.has(FIELD_EPHEMERAL_ID) ? json.get(FIELD_EPHEMERAL_ID).getAsString() : "";
        this.freeUseInProduction = json.has(FIELD_FREE_USE_IN_PROD) ? json.get(FIELD_FREE_USE_IN_PROD).getAsBoolean() : Boolean.TRUE.booleanValue();
        this.tckTested = json.has(FIELD_TCK_TESTED) ? Verification.fromText(json.get(FIELD_TCK_TESTED).getAsString()) : Verification.UNKNOWN;
        this.tckCertUri = json.has(FIELD_TCK_CERT_URI) ? json.get(FIELD_TCK_CERT_URI).getAsString() : "";
        this.aqavitCertified = json.has(FIELD_AQAVIT_CERTIFIED) ? Verification.fromText(json.get(FIELD_AQAVIT_CERTIFIED).getAsString()) : Verification.UNKNOWN;
        this.aqavitCertUri = json.has(FIELD_AQAVIT_CERT_URI) ? json.get(FIELD_AQAVIT_CERT_URI).getAsString() : "";
        this.size = json.has(FIELD_SIZE) ? json.get(FIELD_SIZE).getAsLong() : -1L;
    }

    public String getId() {
        return this.id;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public String getDistributionName() {
        return this.distribution.getName();
    }

    public MajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public Semver getJavaVersion() {
        return this.javaVersion;
    }

    public VersionNumber getDistributionVersion() {
        return this.distributionVersion;
    }

    public Boolean isLatestBuildAvailable() {
        return this.latestBuildAvailable;
    }

    public OptionalInt getFeatureVersion() {
        return this.javaVersion.getVersionNumber().getFeature();
    }

    public OptionalInt getInterimVersion() {
        return this.javaVersion.getVersionNumber().getInterim();
    }

    public OptionalInt getUpdateVersion() {
        return this.javaVersion.getVersionNumber().getUpdate();
    }

    public OptionalInt getPatchVersion() {
        return this.javaVersion.getVersionNumber().getPatch();
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public Bitness getBitness() {
        return this.architecture == Architecture.NOT_FOUND ? Bitness.NOT_FOUND : this.architecture.getBitness();
    }

    public FPU getFpu() {
        return this.fpu;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public LibCType getLibCType() {
        return this.libcType;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public TermOfSupport getTermOfSupport() {
        return this.termOfSupport;
    }

    public Boolean isJavaFXBundled() {
        return this.javafxBundled;
    }

    public Boolean isDirectlyDownloadable() {
        return this.directlyDownloadable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public Boolean getFreeUseInProduction() {
        return this.freeUseInProduction;
    }

    public Verification getTckTested() {
        return this.tckTested;
    }

    public String getTckCertUri() {
        return this.tckCertUri;
    }

    public Verification getAqavitCertified() {
        return this.aqavitCertified;
    }

    public String getAqavitCertUri() {
        return this.aqavitCertUri;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pkg pkg = (Pkg)o;
        return this.javafxBundled == pkg.javafxBundled && this.distribution.equals(pkg.distribution) && this.javaVersion.equalTo(pkg.javaVersion) && this.architecture == pkg.architecture && this.operatingSystem == pkg.operatingSystem && this.packageType == pkg.packageType && this.releaseStatus == pkg.releaseStatus && this.archiveType == pkg.archiveType && this.termOfSupport == pkg.termOfSupport && this.ephemeralId.equals(pkg.ephemeralId) && this.latestBuildAvailable == pkg.latestBuildAvailable;
    }

    public int hashCode() {
        return Objects.hash(this.distribution, this.javaVersion, this.latestBuildAvailable, this.architecture, this.operatingSystem, this.packageType, this.releaseStatus, this.archiveType, this.termOfSupport, this.javafxBundled, this.ephemeralId);
    }

    public String toString() {
        return "{" + "\"" + FIELD_ID + "\"" + ":" + "\"" + this.getId() + "\"" + "," + "\"" + FIELD_DISTRIBUTION + "\"" + ":" + "\"" + this.distribution.getName() + "\"" + "," + "\"" + FIELD_JAVA_VERSION + "\"" + ":" + "\"" + this.javaVersion.toString() + "\"" + "," + "\"" + FIELD_DISTRIBUTION_VERSION + "\"" + ":" + "\"" + this.distributionVersion + "\"" + "," + "\"" + FIELD_LATEST_BUILD_AVAILABLE + "\"" + ":" + this.latestBuildAvailable + "," + "\"" + FIELD_ARCHITECTURE + "\"" + ":" + "\"" + this.architecture.name() + "\"" + "," + "\"" + FIELD_BITNESS + "\"" + ":" + this.architecture.getBitness().getAsInt() + "," + "\"" + FIELD_FPU + "\"" + ":" + "\"" + this.fpu.name() + "\"" + "," + "\"" + FIELD_OPERATING_SYSTEM + "\"" + ":" + "\"" + this.operatingSystem.name() + "\"" + "," + "\"" + FIELD_PACKAGE_TYPE + "\"" + ":" + "\"" + this.packageType.name() + "\"" + "," + "\"" + FIELD_RELEASE_STATUS + "\"" + ":" + "\"" + this.releaseStatus.name() + "\"" + "," + "\"" + FIELD_ARCHIVE_TYPE + "\"" + ":" + "\"" + this.archiveType.getUiString() + "\"" + "," + "\"" + FIELD_TERM_OF_SUPPORT + "\"" + ":" + "\"" + this.termOfSupport.name() + "\"" + "," + "\"" + FIELD_JAVAFX_BUNDLED + "\"" + ":" + this.javafxBundled + "," + "\"" + FIELD_FILENAME + "\"" + ":" + "\"" + this.fileName + "\"" + "," + "\"" + FIELD_EPHEMERAL_ID + "\"" + ":" + "\"" + this.ephemeralId + "\"" + "," + "\"" + FIELD_FREE_USE_IN_PROD + "\"" + ":" + this.freeUseInProduction + "," + "\"" + FIELD_TCK_TESTED + "\"" + ":" + "\"" + this.tckTested.getApiString() + "\"" + "," + "\"" + FIELD_TCK_CERT_URI + "\"" + ":" + "\"" + this.tckCertUri + "\"" + "," + "\"" + FIELD_AQAVIT_CERTIFIED + "\"" + ":" + "\"" + this.aqavitCertified.getApiString() + "\"" + "," + "\"" + FIELD_AQAVIT_CERT_URI + "\"" + ":" + "\"" + this.aqavitCertUri + "\"" + "," + "\"" + FIELD_SIZE + "\"" + ":" + this.size + "\"" + "}";
    }
}

