/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.netbeans.libs.freemarker.FreemarkerEngine;

public class FreemarkerFactory
implements ScriptEngineFactory {
    private static final List<String> names = List.of("FreeMarker", "freemarker");
    private static final List<String> extensions = List.of("fm", "ftl");
    private static final List<String> mimeTypes = List.of("text/x-freemarker");

    @Override
    public String getEngineName() {
        return "freemarker";
    }

    @Override
    public String getEngineVersion() {
        return "2.3.33";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "freemarker";
    }

    @Override
    public String getLanguageVersion() {
        return "2.3.33";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append("${");
        buf.append(obj);
        buf.append(".");
        buf.append(m);
        buf.append("(");
        if (args.length != 0) {
            int i;
            for (i = 0; i < args.length - 1; ++i) {
                buf.append("$").append(args[i]);
                buf.append(", ");
            }
            buf.append("$").append(args[i]);
        }
        buf.append(")}");
        return buf.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        int len = toDisplay.length();
        buf.append("${context.getWriter().write(\"");
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")}");
        return buf.toString();
    }

    @Override
    public String getParameter(String key) {
        return switch (key) {
            case "javax.script.name" -> this.getLanguageName();
            case "javax.script.engine" -> this.getEngineName();
            case "javax.script.engine_version" -> this.getEngineVersion();
            case "javax.script.language" -> this.getLanguageName();
            case "javax.script.language_version" -> this.getLanguageVersion();
            case "THREADING" -> "MULTITHREADED";
            default -> null;
        };
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            buf.append(statements[i]);
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new FreemarkerEngine(this);
    }
}

