/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.support.wizard.AbstractGroovyWizard;
import org.netbeans.modules.groovy.support.wizard.JUnit;
import org.netbeans.modules.gsf.testrunner.api.SelfResizingPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class GroovyJUnitTestWizard
extends AbstractGroovyWizard {
    private static final ResourceBundle BUNDLE = NbBundle.getBundle(GroovyJUnitTestWizard.class);

    private GroovyJUnitTestWizard() {
    }

    @Override
    protected List<SourceGroup> getSourceGroups() {
        List<SourceGroup> testSourceGroups;
        List<SourceGroup> sourceGroups = this.retrieveGroups();
        if (!this.strategy.existsGroovyTestFolder(sourceGroups)) {
            this.strategy.createGroovyTestFolder();
            sourceGroups = this.retrieveGroups();
        }
        if (!(testSourceGroups = this.strategy.getOnlyTestSourceGroups(sourceGroups)).isEmpty()) {
            return testSourceGroups;
        }
        return sourceGroups;
    }

    @Override
    protected FileObject findCorrectTemplate() {
        JUnit currentJUnit = this.strategy.findJUnitVersion();
        if (currentJUnit == JUnit.NOT_DECLARED) {
            JUnit jUnitToUse = this.askUserWhichJUnitToUse();
            if (jUnitToUse == null) {
                return super.findCorrectTemplate();
            }
            this.strategy.setjUnitVersion(jUnitToUse);
            this.strategy.addJUnitLibrary(jUnitToUse);
        } else {
            this.strategy.setjUnitVersion(currentJUnit);
        }
        return this.strategy.findTemplate(this.wiz);
    }

    private JUnit askUserWhichJUnitToUse() {
        JRadioButton radioButtonForJUnit3 = new JRadioButton();
        JRadioButton radioButtonForJUnit4 = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radioButtonForJUnit3, (String)BUNDLE.getString("LBL_JUnit3_generator"));
        Mnemonics.setLocalizedText((AbstractButton)radioButtonForJUnit4, (String)BUNDLE.getString("LBL_JUnit4_generator"));
        radioButtonForJUnit3.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_JUnit3_generator"));
        radioButtonForJUnit4.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_JUnit4_generator"));
        ButtonGroup group = new ButtonGroup();
        group.add(radioButtonForJUnit3);
        group.add(radioButtonForJUnit4);
        radioButtonForJUnit4.setSelected(true);
        JTextComponent msg = this.createMultilineLabel(BUNDLE.getString("MSG_select_junit_version"));
        JPanel choicePanel = new JPanel(new GridLayout(0, 1, 0, 3));
        choicePanel.add(radioButtonForJUnit3);
        choicePanel.add(radioButtonForJUnit4);
        JPanel panel = new JPanel(new BorderLayout(0, 12));
        panel.add((Component)msg, "North");
        panel.add((Component)choicePanel, "Center");
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)BUNDLE.getString("LBL_Select"));
        button.getAccessibleContext().setAccessibleDescription("AD_Select");
        button.getAccessibleContext().setAccessibleName("AN_Select");
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)GroovyJUnitTestWizard.wrapDialogContent(panel), BUNDLE.getString("LBL_title_select_generator"), true, new Object[]{button, NotifyDescriptor.CANCEL_OPTION}, (Object)button, 0, null, (ActionListener)null));
        if (answer == button) {
            if (radioButtonForJUnit3.isSelected()) {
                return JUnit.JUNIT3;
            }
            return JUnit.JUNIT4;
        }
        return null;
    }

    private JTextComponent createMultilineLabel(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setOpaque(false);
        textArea.setColumns(25);
        textArea.setDisabledTextColor(new JLabel().getForeground());
        return textArea;
    }

    private static JComponent wrapDialogContent(JComponent comp) {
        SelfResizingPanel result = new SelfResizingPanel();
        result.setLayout(new GridLayout());
        result.add(comp);
        result.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        result.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_title_select_generator"));
        return result;
    }
}

