/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.CatCommand;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;

public class StashListCommand
extends GitCommand {
    private final List<GitRevisionInfo> revisions = new ArrayList<GitRevisionInfo>();
    private final RevisionInfoListener listener;

    public StashListCommand(Repository repository, GitClassFactory accessor, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, accessor, monitor);
        this.listener = listener;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try (RevWalk fullWalk = new RevWalk(repository);){
            Collection stashes = new Git(repository).stashList().call();
            for (RevCommit stash : stashes) {
                this.addRevision(this.getClassFactory().createRevisionInfo(fullWalk.parseCommit((AnyObjectId)stash), repository));
            }
        }
        catch (JGitInternalException ex) {
            throw new GitException(Utils.getBundle(CatCommand.class).getString("MSG_Error_StashMissingCommit"), ex);
        }
        catch (IOException | GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git stash list";
    }

    public GitRevisionInfo[] getRevisions() {
        return this.revisions.toArray(new GitRevisionInfo[0]);
    }

    private void addRevision(GitRevisionInfo info) {
        this.revisions.add(info);
        this.listener.notifyRevisionInfo(info);
    }
}

