<?php

namespace {

	/**
	 * Flush system output buffer
	 * <p>Flushes the system write buffers of PHP and the backend used by PHP (e.g.: CGI, a web server). In a command line environment <b>flush()</b> will attempt to flush the contents of the buffers only whereas in a web context headers and the contents of the buffers are flushed.</p><p><b>Note</b>:  <b>flush()</b> may not be able to override the buffering scheme of the web server and it has no effect on any client-side buffering in the browser. </p><p><b>Note</b>:  This function does not have any effect on user level output handlers such as those started by <code>ob_start()</code> or <code>output_add_rewrite_var()</code>. </p><p><b>flush()</b> can interfere with output handlers that set and send headers in a web context (e.g. <code>ob_gzhandler()</code>) by sending headers before these handlers can do so.</p>
	 * @return void <p>No value is returned.</p>
	 * @link https://php.net/manual/en/function.flush.php
	 * @see ob_flush(), ob_clean(), ob_end_flush(), ob_end_clean()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function flush(): void {}

	/**
	 * Clean (erase) the contents of the active output buffer
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> flag), discards it's return value and cleans (erases) the contents of the active output buffer.</p><p>This function does not turn off the active output buffer like <code>ob_end_clean()</code> or <code>ob_get_clean()</code> does.</p><p><b>ob_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-clean.php
	 * @see ob_start(), ob_get_contents(), ob_end_clean(), ob_get_clean(), ob_flush()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_clean(): bool {}

	/**
	 * Clean (erase) the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> and <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flags), discards it's return value, discards the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_end_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_end_clean()</b> will discard the contents of the active output buffer even if it was started without the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-end-clean.php
	 * @see ob_start(), ob_get_contents(), ob_clean(), ob_get_clean(), ob_end_flush()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_end_clean(): bool {}

	/**
	 * Flush (send) the return value of the active output handler and turn the active output buffer off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flag), flushes (sends) it's return value, discards the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_end_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_end_flush()</b> will flush (send) the return value of the output handler even if the active output buffer was started without the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-end-flush.php
	 * @see ob_start(), ob_get_contents(), ob_flush(), ob_get_flush(), ob_end_clean()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_end_flush(): bool {}

	/**
	 * Flush (send) the return value of the active output handler
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FLUSH</code></b> flag), flushes (sends) it's return value and discards the contents of the active output buffer.</p><p>This function does not turn off the active output buffer like <code>ob_end_flush()</code> or <code>ob_get_flush()</code> does.</p><p><b>ob_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-flush.php
	 * @see ob_start(), ob_get_contents(), ob_end_flush(), ob_get_flush(), ob_clean()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_flush(): bool {}

	/**
	 * Get the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> and <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flags), discards it's return value, returns the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_get_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_get_clean()</b> will discard the contents of the active output buffer even if it was started without the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return string|false <p>Returns the contents of the active output buffer on success or <b><code>false</code></b> on failure.</p><b>Caution</b> <p><b>ob_get_clean()</b> will return false but will not generate an <b><code>E_NOTICE</code></b> if there is no active output buffer.</p>
	 * @link https://php.net/manual/en/function.ob-get-clean.php
	 * @see ob_start(), ob_get_contents(), ob_clean(), ob_end_clean(), ob_get_flush()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_clean(): string|false {}

	/**
	 * Return the contents of the output buffer
	 * <p>Gets the contents of the output buffer without clearing it.</p>
	 * @return string|false <p>This will return the contents of the output buffer or <b><code>false</code></b>, if output buffering isn't active.</p>
	 * @link https://php.net/manual/en/function.ob-get-contents.php
	 * @see ob_start(), ob_get_length()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_contents(): string|false {}

	/**
	 * Flush (send) the return value of the active output handler, return the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flag), flushes (sends) it's return value, returns the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_get_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_get_flush()</b> will flush (send) the return value of the output handler even if the active output buffer was started without the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return string|false <p>Returns the contents of the active output buffer on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-get-flush.php
	 * @see ob_start(), ob_get_contents(), ob_flush(), ob_end_flush(), ob_get_clean()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_flush(): string|false {}

	/**
	 * Return the length of the output buffer
	 * <p>This will return the length of the contents in the output buffer, in bytes.</p>
	 * @return int|false <p>Returns the length of the output buffer contents, in bytes, or <b><code>false</code></b> if no buffering is active.</p>
	 * @link https://php.net/manual/en/function.ob-get-length.php
	 * @see ob_start(), ob_get_contents()
	 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_length(): int|false {}

	/**
	 * Return the nesting level of the output buffering mechanism
	 * <p>Returns the nesting level of the output buffering mechanism.</p>
	 * @return int <p>Returns the level of nested output buffering handlers or zero if output buffering is not active.</p><b>Caution</b> <p>The value for identical levels between <b>ob_get_level()</b> and <code>ob_get_status()</code> is off by one. For <b>ob_get_level()</b> the first level is <code>1</code>. Whereas for <code>ob_get_status()</code> the first level is <code>0</code>.</p>
	 * @link https://php.net/manual/en/function.ob-get-level.php
	 * @see ob_start(), ob_get_status(), ob_get_contents()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_level(): int {}

	/**
	 * Get status of output buffers
	 * <p><b>ob_get_status()</b> returns status information on either the top level output buffer or all active output buffer levels if <code>full_status</code> is set to <b><code>true</code></b>.</p>
	 * @param bool $full_status <p><b><code>true</code></b> to return all active output buffer levels. If <b><code>false</code></b> or not set, only the top level output buffer is returned.</p>
	 * @return array <p>If <code>full_status</code> is omitted or <b><code>false</code></b> a simple array holding status information on the active output level is returned.</p><p>If <code>full_status</code> is <b><code>true</code></b> an array with one element for each active output buffer level is returned. The output level is used as key of the top level array and each array element itself is another array holding status information on one active output level.</p><p>An empty array is returned if output buffering is not turned on.</p> <b><b>ob_get_status()</b> return array elements</b> KeyValue  name  Name of active output handler (see the return values of <code>ob_list_handlers()</code> for details)    type  <code>0</code> (internal handler) or <code>1</code> (user supplied handler)    flags  Bitmask of flags set by <code>ob_start()</code>, the type of output handler (see above) and the status of the buffering process ( <b><code>PHP_OUTPUT_HANDLER_&#42;</code></b>  constants). If the handler successfully processed the buffer and did not return <b><code>false</code></b>, <b><code>PHP_OUTPUT_HANDLER_STARTED</code></b> and <b><code>PHP_OUTPUT_HANDLER_PROCESSED</code></b> will be set. If the handler failed while processing the buffer or returned <b><code>false</code></b>, <b><code>PHP_OUTPUT_HANDLER_STARTED</code></b> and <b><code>PHP_OUTPUT_HANDLER_DISABLED</code></b> will be set.    level  Output nesting level (zero based). Note that the value returned for the same level by <code>ob_get_level()</code> is off by one. The first level is <code>0</code> for <b>ob_get_status()</b>, and <code>1</code> for <code>ob_get_level()</code>.    chunk_size  Chunk size in bytes. Set by <code>ob_start()</code> or output_buffering is enabled and its value is set to a positive integer    buffer_size  Output buffer size in bytes    buffer_used  Size of data in output buffer in bytes (the same as the integer return value of <code>ob_get_length()</code>)
	 * @link https://php.net/manual/en/function.ob-get-status.php
	 * @see ob_get_level(), ob_list_handlers(), ob_get_length(), ob_start()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_status(bool $full_status = false): array {}

	/**
	 * Turn implicit flush on/off
	 * <p><b>ob_implicit_flush()</b> will turn implicit flushing on or off. Implicit flushing will result in a flush operation after every block of code resulting in output, so that explicit calls to <code>flush()</code> will no longer be needed.</p><p><b>Note</b>:  Printing empty strings or sending headers is not considered output and will not result in a flush operation. </p><p><b>Note</b>:  This function does not have any effect on user level output handlers such as those started by <code>ob_start()</code> or <code>output_add_rewrite_var()</code>. </p>
	 * @param bool $enable <p><b><code>true</code></b> to turn implicit flushing on, <b><code>false</code></b> otherwise.</p>
	 * @return void <p>No value is returned.</p>
	 * @link https://php.net/manual/en/function.ob-implicit-flush.php
	 * @see flush(), ob_start(), ob_end_flush()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_implicit_flush(bool $enable = true): void {}

	/**
	 * List all output handlers in use
	 * <p>Lists all output handlers in use.</p>
	 * @return array <p>This will return an array with the output handlers in use (if any).</p><p>If output_buffering is enabled and no output_handler is set, or no callback or <b><code>null</code></b> was passed to <code>ob_start()</code>, <code>"default output handler"</code> is returned. Enabling output_buffering and setting an output_handler is equivalent to passing an internal (built-in) function to <code>ob_start()</code>.</p><p>If a <code>callable</code> was passed to <code>ob_start()</code>, the fully qualified name of the <code>callable</code> is returned. If the <code>callable</code> is an object implementing __invoke(), the fully qualified name of the object's __invoke() method is returned. If the <code>callable</code> is a <code>Closure</code>, <code>"Closure::__invoke"</code> is returned.</p>
	 * @link https://php.net/manual/en/function.ob-list-handlers.php
	 * @see ob_end_clean(), ob_end_flush(), ob_get_flush(), ob_start()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_list_handlers(): array {}

	/**
	 * Turn on output buffering
	 * <p>This function will turn output buffering on. While output buffering is active no output is sent from the script, instead the output is stored in an internal buffer. See What Output Is Buffered&#63; on exactly what output is affected.</p><p>Output buffers are stackable, that is, <b>ob_start()</b> may be called while another buffer is active. If multiple output buffers are active, output is being filtered sequentially through each of them in nesting order. See Nesting Output Buffers for more details.</p><p>See User-Level Output Buffers for a detailed description of output buffers.</p>
	 * @param callable $callback <p>An optional <code>callback</code> <code>callable</code> may be specified. It can also be bypassed by passing <b><code>null</code></b>.</p> <p><code>callback</code> is invoked when the output buffer is flushed (sent), cleaned, or when the output buffer is flushed at the end of the script.</p> <p>The signature of the <code>callback</code> is as follows:</p> <p></p> handler(<code>string</code> <code>$buffer</code>, <code>int</code> <code>$phase</code> = &#63;): <code>string</code>   <code>buffer</code>   Contents of the output buffer.    <code>phase</code>   Bitmask of  <b><code>PHP_OUTPUT_HANDLER_&#42;</code></b> constants . See Flags Passed To Output Handlers for more details.    <p>If <code>callback</code> returns <b><code>false</code></b> the contents of the buffer are returned. See Output Handler Return Values for more details.</p> <p><b>Warning</b></p> <p>Calling any of the following functions from within an output handler will result in a fatal error: <code>ob_clean()</code>, <code>ob_end_clean()</code>, <code>ob_end_flush()</code>, <code>ob_flush()</code>, <code>ob_get_clean()</code>, <code>ob_get_flush()</code>, <b>ob_start()</b>.</p>  <p>See Output Handlers and Working With Output Handlers for more details on <code>callback</code>s (output handlers).</p>
	 * @param int $chunk_size <p>If the optional parameter <code>chunk_size</code> is passed, the buffer will be flushed after any block of code resulting in output that causes the buffer's length to equal or exceed <code>chunk_size</code>. The default value <code>0</code> means that all output is buffered until the buffer is turned off. See Buffer Size for more details.</p>
	 * @param int $flags <p>The <code>flags</code> parameter is a bitmask that controls the operations that can be performed on the output buffer. The default is to allow output buffers to be cleaned, flushed and removed, which can be set explicitly via the  buffer control flags . See Operations Allowed On Buffers for more details.</p> <p>Each flag controls access to a set of functions, as described below:</p>   Constant Functions     <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b>  <code>ob_clean()</code>    <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b>  <code>ob_end_flush()</code>    <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b>  <code>ob_end_clean()</code>, <code>ob_end_flush()</code>, <code>ob_get_clean()</code>, <code>ob_get_flush()</code>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-start.php
	 * @see ob_get_contents(), ob_end_clean(), ob_end_flush(), ob_implicit_flush(), ob_gzhandler(), ob_iconv_handler(), mb_output_handler(), ob_tidyhandler()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_start(callable $callback = null, int $chunk_size = 0, int $flags = PHP_OUTPUT_HANDLER_STDFLAGS): bool {}

	/**
	 * Add URL rewriter values
	 * <p>This function starts the <code>'URL-Rewriter'</code> output buffer handler if it is not active, stores the <code>name</code> and <code>value</code> parameters, and when the buffer is flushed rewrites the URLs and forms based on the applicable ini settings. Subsequent calls to this function will store all additional name/value pairs until the handler is turned off.</p><p>When the output buffer is flushed (by calling <code>ob_flush()</code>, <code>ob_end_flush()</code>, <code>ob_get_flush()</code> or at the end of the script) the <code>'URL-Rewriter'</code> handler adds the name/value pairs as query parameters to URLs in attributes of HTML tags and adds hidden fields to forms based on the values of the url_rewriter.tags and url_rewriter.hosts configuration directives.</p><p>Each name/value pair added to the <code>'URL-Rewriter'</code> handler is added to the URLs and/or forms even if this results in duplicate URL query parameters or elements with the same name attributes.</p><p><b>Note</b>:  Once the <code>'URL-Rewriter'</code> handler has been turned off it cannot be started again. </p>
	 * @param string $name <p>The variable name.</p>
	 * @param string $value <p>The variable value.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.output-add-rewrite-var.php
	 * @see output_reset_rewrite_vars(), ob_flush(), ob_list_handlers()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function output_add_rewrite_var(string $name, string $value): bool {}

	/**
	 * Reset URL rewriter values
	 * <p>This function removes all rewrite variables previously set by the <code>output_add_rewrite_var()</code> function.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.output-reset-rewrite-vars.php
	 * @see output_add_rewrite_var(), ob_flush(), ob_list_handlers()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function output_reset_rewrite_vars(): bool {}

	/**
	 * <p>Indicates that the output buffer has been cleaned.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CLEAN', 2);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be cleaned by <code>ob_clean()</code>. This flag does not control the behaviour of <code>ob_end_clean()</code> or <code>ob_get_clean()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CLEANABLE', 16);

	/**
	 * <p>Indicates that the buffer has been flushed, but output buffering will continue.</p> <p>This is an alias for <b><code>PHP_OUTPUT_HANDLER_WRITE</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CONT', 0);

	/**
	 * <p>Indicates that the output handler is disabled. This flag is set when the output handler returns <b><code>false</code></b> or fails while processing the buffer, or it was set prior to calling the output handler.</p>
	 */
	define('PHP_OUTPUT_HANDLER_DISABLED', 8192);

	/**
	 * <p>Indicates that output buffering has ended.</p> <p>This is an alias for <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_END', 8);

	/**
	 * <p>Indicates that this is the final output buffering operation.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FINAL', 8);

	/**
	 * <p>Indicates that the buffer has been flushed.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FLUSH', 4);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be flushed by <code>ob_flush()</code>. This flag does not control the behaviour of <code>ob_end_flush()</code> or <code>ob_get_flush()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FLUSHABLE', 32);

	/**
	 * <p>Indicates that the output handler successfully processed the buffer.</p>
	 */
	define('PHP_OUTPUT_HANDLER_PROCESSED', null);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be removed before the end of the script or when calling <code>ob_end_clean()</code>, <code>ob_end_flush()</code>, <code>ob_get_clean()</code> or <code>ob_get_flush()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_REMOVABLE', 64);

	/**
	 * <p>Indicates that output buffering has begun.</p>
	 */
	define('PHP_OUTPUT_HANDLER_START', 1);

	/**
	 * <p>Indicates that the output handler was called.</p>
	 */
	define('PHP_OUTPUT_HANDLER_STARTED', 4096);

	/**
	 * <p>The default set of output buffer flags; currently equivalent to <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_STDFLAGS', 112);

	/**
	 * <p>Indicates that the output buffer is being flushed, and had data to output.</p>
	 */
	define('PHP_OUTPUT_HANDLER_WRITE', 0);

}
