/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.gui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.externalfinder.gui.ExternalFinderSubItemEditorPanel;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class ExternalFinderItemURLEditorController {
    private final ExternalFinderSubItemEditorPanel panel;
    private final ExternalFinderItemURL.Builder builder;
    private boolean userDidConfirm;

    public ExternalFinderItemURLEditorController() {
        this(new ExternalFinderItemURL.Builder().setURL(""));
    }

    public ExternalFinderItemURLEditorController(ExternalFinderItemURL item) {
        this(ExternalFinderItemURL.Builder.from(item));
    }

    public ExternalFinderItemURLEditorController(ExternalFinderItemURL.Builder builder) {
        this.builder = builder;
        this.panel = new ExternalFinderSubItemEditorPanel();
    }

    public boolean show(Window parent) {
        JDialog dialog = new JDialog(parent, OStrings.getString("EXTERNALFINDER_URLEDITOR_TITLE"));
        dialog.setModal(true);
        dialog.getContentPane().add(this.panel);
        dialog.setDefaultCloseOperation(2);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        this.panel.commandPanel.setVisible(false);
        this.panel.urlTextArea.setText(this.builder.getURL());
        this.panel.urlTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ExternalFinderItemURLEditorController.this.builder.setURL(((ExternalFinderItemURLEditorController)ExternalFinderItemURLEditorController.this).panel.urlTextArea.getText().trim());
                ExternalFinderItemURLEditorController.this.validate();
            }
        });
        this.panel.targetComboBox.setModel(new DefaultComboBoxModel<ExternalFinderItem.TARGET>(ExternalFinderItem.TARGET.values()));
        this.panel.targetComboBox.setSelectedItem((Object)this.builder.getTarget());
        this.panel.targetComboBox.addActionListener(e -> {
            this.builder.setTarget((ExternalFinderItem.TARGET)((Object)((Object)this.panel.targetComboBox.getSelectedItem())));
            this.validate();
        });
        this.panel.encodingComboBox.setModel(new DefaultComboBoxModel<ExternalFinderItem.ENCODING>(ExternalFinderItem.ENCODING.values()));
        this.panel.encodingComboBox.setSelectedItem((Object)this.builder.getEncoding());
        this.panel.encodingComboBox.addActionListener(e -> {
            this.builder.setEncoding((ExternalFinderItem.ENCODING)((Object)((Object)this.panel.encodingComboBox.getSelectedItem())));
            this.validate();
        });
        this.panel.okButton.addActionListener(e -> {
            if (this.validate()) {
                this.userDidConfirm = true;
                StaticUIUtils.closeWindowByEvent(dialog);
            }
        });
        dialog.getRootPane().setDefaultButton(this.panel.okButton);
        this.panel.cancelButton.addActionListener(e -> {
            this.userDidConfirm = false;
            StaticUIUtils.closeWindowByEvent(dialog);
        });
        this.panel.testButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(this.builder.generateSampleURL());
            }
            catch (Exception ex) {
                Logger.getLogger(ExternalFinderItemURLEditorController.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(dialog, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
            }
        });
        this.validate();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.userDidConfirm;
    }

    public ExternalFinderItemURL getResult() {
        return this.builder.build();
    }

    private boolean validate() {
        boolean isValid = true;
        String sampleOutput = null;
        try {
            sampleOutput = this.builder.validate().toString();
        }
        catch (ExternalFinderValidationException e) {
            isValid = false;
            sampleOutput = e.getLocalizedMessage();
        }
        this.panel.okButton.setEnabled(isValid);
        this.panel.testButton.setEnabled(isValid);
        this.panel.sampleOutputTextArea.setText(sampleOutput);
        this.panel.sampleOutputTextArea.setForeground(isValid ? Color.BLACK : Color.RED);
        return isValid;
    }
}

